/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLModelCookie;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLMultiViewFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.netbeans.modules.xml.xdm.nodes.Convertors;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class WSDLEditorSupport
extends DataEditorSupport
implements WSDLModelCookie,
OpenCookie,
EditCookie,
EditorCookie.Observable,
LineCookie,
CloseCookie,
PrintCookie {
    private transient Task prepareTask2;

    public WSDLEditorSupport(WSDLDataObject wSDLDataObject) {
        super((DataObject)wSDLDataObject, (CloneableEditorSupport.Env)new WSDLEditorEnv(wSDLDataObject));
        this.setMIMEType("text/x-wsdl+xml");
    }

    public WSDLEditorEnv getEnv() {
        return (WSDLEditorEnv)this.env;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = WSDLMultiViewFactory.createMultiView((WSDLDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    public static boolean isLastView(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WSDLEditorSupport.this.updateTitles();
            }
        });
    }

    protected void updateTitles() {
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent;
                ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
                DataObject dataObject = WSDLEditorSupport.this.getDataObject();
                TopComponent topComponent2 = TopComponent.getRegistry().getActivated();
                if (topComponent2 != null && dataObject == topComponent2.getLookup().lookup(DataObject.class)) {
                    arrayList.add(topComponent2);
                }
                Set set = TopComponent.getRegistry().getOpened();
                for (Object object : set) {
                    topComponent = (TopComponent)object;
                    if (dataObject != topComponent.getLookup().lookup(DataObject.class)) continue;
                    arrayList.add(topComponent);
                }
                for (TopComponent topComponent3 : arrayList) {
                    topComponent = MultiViews.findMultiViewHandler((TopComponent)topComponent3);
                    if (topComponent == null) continue;
                    topComponent3.setHtmlDisplayName(WSDLEditorSupport.this.messageHtmlName());
                    String string = WSDLEditorSupport.this.messageName();
                    topComponent3.setDisplayName(string);
                    topComponent3.setName(string);
                    topComponent3.setToolTipText(WSDLEditorSupport.this.messageToolTip());
                }
            }
        });
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (task != this.prepareTask2) {
            this.prepareTask2 = task;
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    QuietUndoManager quietUndoManager = WSDLEditorSupport.this.getUndoManager();
                    StyledDocument styledDocument = WSDLEditorSupport.this.getDocument();
                    QuietUndoManager quietUndoManager2 = quietUndoManager;
                    synchronized (quietUndoManager2) {
                        quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                        if (!quietUndoManager.isCompound()) {
                            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            WSDLEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                        }
                    }
                    WSDLEditorSupport.this.prepareTask2 = null;
                }
            });
        }
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = WSDLEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = WSDLEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound()) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            WSDLModel wSDLModel;
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            if ((wSDLModel = this.getModel()) != null) {
                wSDLModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
        }
        super.notifyClosed();
    }

    public WSDLModel getModel() {
        WSDLDataObject wSDLDataObject = this.getEnv().getWSDLDataObject();
        ModelSource modelSource = Utilities.getModelSource((FileObject)wSDLDataObject.getPrimaryFile(), (boolean)true);
        if (modelSource != null) {
            return WSDLModelFactory.getDefault().getModel(modelSource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            WSDLModel wSDLModel = this.getModel();
            if (wSDLModel != null) {
                wSDLModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        WSDLModel wSDLModel = this.getModel();
        if (wSDLModel != null) {
            wSDLModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            wSDLModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)wSDLModel);
        }
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public void syncModel() {
        try {
            WSDLModel wSDLModel = this.getModel();
            if (wSDLModel != null) {
                wSDLModel.sync();
            }
        }
        catch (Throwable throwable) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSDLEditorSupport.class, (String)"MSG_NotWellformedWsdl"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        String string = EncodingUtil.detectEncoding((InputStream)inputStream);
        if (string == null) {
            string = "UTF8";
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            editorKit.read(inputStreamReader, (Document)styledDocument, 0);
        }
        catch (CharConversionException charConversionException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        String string = EncodingUtil.detectEncoding((Document)styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException("Unsupported encoding " + string);
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(WSDLEditorSupport.class, (String)"MSG_WSDLEditorSupport_Unsupported_Encoding", (Object)string));
            throw iOException;
        }
    }

    public void saveDocument() throws IOException {
        block8: {
            final StyledDocument styledDocument = this.getDocument();
            String string = EncodingUtil.detectEncoding((Document)styledDocument);
            if (string == null) {
                string = "UTF8";
            }
            try {
                new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
                if (!this.checkCharsetConversion(Convertors.java2iana((String)string))) {
                    return;
                }
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getMessage(WSDLEditorSupport.class, (String)"MSG_WSDLEditorSupport_Use_UTF8"), string));
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (!object.equals(NotifyDescriptor.YES_OPTION)) break block8;
                try {
                    int n;
                    int n2 = Math.min(1000, styledDocument.getLength());
                    final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                    int n3 = 0;
                    if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                        for (n = 3; n < n2; ++n) {
                            if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                            n3 = n + 1;
                            break;
                        }
                    }
                    n = n3;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    styledDocument.remove(0, n + 1);
                                    styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?>\n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    badLocationException.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        }
    }

    private boolean checkCharsetConversion(String string) {
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                Object[] objectArray = new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string};
                String string2 = NbBundle.getMessage(WSDLEditorSupport.class, (String)"MSG_WSDLEditorSupport_BadCharConversion", (Object[])objectArray);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return bl;
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3838395157610633251L;
        private DataObject dataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private WSDLEditorSupport getWSDLEditorSupport() {
            return this.dataObject instanceof WSDLDataObject ? ((WSDLDataObject)this.dataObject).getWSDLEditorSupport() : null;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            boolean bl;
            WSDLEditorSupport wSDLEditorSupport = this.getWSDLEditorSupport();
            boolean bl2 = bl = wSDLEditorSupport != null ? wSDLEditorSupport.canClose() : true;
            if (bl) {
                this.dataObject.setModified(false);
            }
            return bl;
        }
    }

    protected static class WSDLEditorEnv
    extends DataEditorSupport.Env {
        static final long serialVersionUID = 1099957785497677206L;

        public WSDLEditorEnv(WSDLDataObject wSDLDataObject) {
            super((DataObject)wSDLDataObject);
        }

        public CloneableEditorSupport findTextEditorSupport() {
            return this.getWSDLDataObject().getWSDLEditorSupport();
        }

        public WSDLDataObject getWSDLDataObject() {
            return (WSDLDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.getDataObject().getPrimaryFile().lock();
        }
    }
}

