/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.spi;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.ui.spi.ExtensibilityElementConfigurator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ExtensibilityElementConfiguratorFactory {
    private Map<QName, ExtensibilityElementConfigurator> configurators;
    private static ExtensibilityElementConfiguratorFactory factory;
    private boolean hasChanged = false;

    private ExtensibilityElementConfiguratorFactory() {
        this.initialise();
    }

    private void initialise() {
        this.configurators = new HashMap<QName, ExtensibilityElementConfigurator>();
        Lookup.Result result = Lookup.getDefault().lookupResult(ExtensibilityElementConfigurator.class);
        result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ExtensibilityElementConfiguratorFactory.this.hasChanged = true;
            }
        });
        this.lookupFactories();
    }

    public static ExtensibilityElementConfiguratorFactory getDefault() {
        if (factory == null) {
            ExtensibilityElementConfiguratorFactory.createFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFactory() {
        Class<ExtensibilityElementConfiguratorFactory> clazz = ExtensibilityElementConfiguratorFactory.class;
        synchronized (ExtensibilityElementConfiguratorFactory.class) {
            if (factory == null) {
                factory = new ExtensibilityElementConfiguratorFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public ExtensibilityElementConfigurator getExtensibilityElementConfigurator(QName qName) {
        this.checkUpdates();
        if (this.configurators == null || qName == null) {
            return null;
        }
        return this.configurators.get(qName);
    }

    public Node.Property getNodeProperty(ExtensibilityElement extensibilityElement, QName qName, String string) {
        this.checkUpdates();
        if (this.configurators == null) {
            return null;
        }
        ExtensibilityElementConfigurator extensibilityElementConfigurator = this.configurators.get(qName);
        if (extensibilityElementConfigurator != null) {
            return extensibilityElementConfigurator.getProperty(extensibilityElement, qName, string);
        }
        return null;
    }

    private void checkUpdates() {
        if (this.hasChanged) {
            this.lookupFactories();
            this.hasChanged = false;
        }
    }

    private synchronized void lookupFactories() {
        this.configurators.clear();
        for (ExtensibilityElementConfigurator extensibilityElementConfigurator : Lookup.getDefault().lookupAll(ExtensibilityElementConfigurator.class)) {
            for (QName qName : extensibilityElementConfigurator.getSupportedQNames()) {
                if (this.configurators.containsKey(qName)) {
                    ErrorManager.getDefault().notify((Throwable)new Exception("There is a ExtensibilityConfigurator already present for this " + qName.toString()));
                }
                this.configurators.put(qName, extensibilityElementConfigurator);
            }
        }
    }
}

