/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor.pastetype;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DnDImportPanel
extends JPanel {
    private DialogDescriptor dd;
    private Set existingPrefixes;
    private DocumentListener listener;
    private CommonMessagePanel errorWarningMessagePanel;
    private JLabel fileNameLabel;
    private JTextField fileTextField;
    private JLabel namespaceLabel;
    private JTextField namespaceTextField;
    private JLabel prefixLabel;
    private JTextField prefixTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public DnDImportPanel() {
        this.initComponents();
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validatePrefix();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validatePrefix();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validatePrefix();
            }

            void validatePrefix() {
                String string = null;
                String string2 = DnDImportPanel.this.prefixTextField.getText();
                if (string2 == null || string2.trim().length() == 0 || !Utils.isValidNCName((String)string2)) {
                    string = NbBundle.getMessage(DnDImportPanel.class, (String)"ERRMSG_InvalidPrefix", (Object)string2);
                }
                if (DnDImportPanel.this.existingPrefixes != null && DnDImportPanel.this.existingPrefixes.contains(string2)) {
                    string = NbBundle.getMessage(DnDImportPanel.class, (String)"ERRMSG_PrefixAlreadyExists", (Object)string2);
                }
                if (string != null) {
                    DnDImportPanel.this.errorWarningMessagePanel.setErrorMessage(string);
                } else {
                    DnDImportPanel.this.errorWarningMessagePanel.setMessage(null);
                }
                DnDImportPanel.this.dd.setValid(string == null);
            }
        };
        this.prefixTextField.getDocument().addDocumentListener(this.listener);
    }

    String getPrefix() {
        return this.prefixTextField.getText();
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
    }

    void setFileName(FileObject fileObject) {
        this.fileTextField.setText(fileObject.getNameExt());
    }

    void setNamespace(String string) {
        this.namespaceTextField.setText(string);
    }

    void setPrefix(String string) {
        this.prefixTextField.getDocument().removeDocumentListener(this.listener);
        this.prefixTextField.setText(string);
        this.prefixTextField.getDocument().addDocumentListener(this.listener);
    }

    void setPrefixes(Set set) {
        this.existingPrefixes = set;
    }

    void setProject(Project project) {
        this.projectNameTextField.setText(project.getProjectDirectory().getName());
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.namespaceLabel = new JLabel();
        this.namespaceTextField = new JTextField();
        this.prefixLabel = new JLabel();
        this.prefixTextField = new JTextField();
        this.errorWarningMessagePanel = new CommonMessagePanel();
        this.setName("Form");
        this.fileNameLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.fileNameLabel.text"));
        this.fileNameLabel.setToolTipText(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.fileNameLabel.toolTipText"));
        this.fileNameLabel.setName("fileNameLabel");
        this.fileTextField.setEditable(false);
        this.fileTextField.setName("fileTextField");
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.projectNameLabel.text"));
        this.projectNameLabel.setToolTipText(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.projectNameLabel.toolTipText"));
        this.projectNameLabel.setName("projectNameLabel");
        this.projectNameTextField.setEditable(false);
        this.projectNameTextField.setName("projectNameTextField");
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.namespaceLabel.text"));
        this.namespaceLabel.setToolTipText(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.namespaceLabel.toolTipText"));
        this.namespaceLabel.setName("namespaceLabel");
        this.namespaceTextField.setEditable(false);
        this.namespaceTextField.setName("namespaceTextField");
        this.prefixLabel.setLabelFor(this.prefixTextField);
        Mnemonics.setLocalizedText((JLabel)this.prefixLabel, (String)NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.prefixLabel.text"));
        this.prefixLabel.setToolTipText(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.prefixLabel.toolTipText"));
        this.prefixLabel.setName("prefixLabel");
        this.prefixTextField.setName("prefixTextField");
        this.errorWarningMessagePanel.setName("errorWarningMessagePanel");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorWarningMessagePanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.projectNameLabel, -1, -1, Short.MAX_VALUE).add((Component)this.prefixLabel, -1, -1, Short.MAX_VALUE).add((Component)this.namespaceLabel, -1, -1, Short.MAX_VALUE).add((Component)this.fileNameLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.projectNameTextField, -1, 240, Short.MAX_VALUE).add((Component)this.fileTextField, -1, 240, Short.MAX_VALUE).add(1, (Component)this.prefixTextField, -1, 240, Short.MAX_VALUE).add(1, (Component)this.namespaceTextField, -1, 240, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileNameLabel).add((Component)this.fileTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.namespaceLabel).add((Component)this.namespaceTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.prefixTextField, -2, -1, -2).add((Component)this.prefixLabel)).add(18, 18, 18).add((Component)this.errorWarningMessagePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.fileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.fileTextField.AccessibleContext.accessibleName"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.fileTextField.AccessibleContext.accessibleDescription"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.projectNameTextField.AccessibleContext.accessibleName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.projectNameTextField.AccessibleContext.accessibleDescription"));
        this.namespaceTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.namespaceTextField.AccessibleContext.accessibleName"));
        this.namespaceTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.namespaceTextField.AccessibleContext.accessibleDescription"));
        this.prefixTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.prefixTextField.AccessibleContext.accessibleName"));
        this.prefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DnDImportPanel.class, (String)"DnDImportPanel.prefixTextField.AccessibleContext.accessibleDescription"));
    }
}

