/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.OperationPanel;
import org.netbeans.modules.xml.wsdl.ui.wizard.WsdlUIPanel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class WsdlPanel
implements WizardDescriptor.FinishablePanel {
    public static final String FILE_NAME = "FILE_NAME";
    public static final String WSDL_TARGETNAMESPACE = "WSDL_TARGETNAMESPACE";
    public static final String WSDL_DEFINITION_NAME = "WSDL_DEFINITION_NAME";
    public static final String ENCODING = "PROJECT_ENCODING";
    private static final String DEFAULT_TARGET_NAMESPACE = "urn:WS/wsdl";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private WsdlUIPanel gui;
    private Project project;
    private TemplateWizard templateWizard;
    private JTextField fileNameTextField;
    private File tempWSDLFile = null;
    private WSDLModel mTempWSDLModel = null;
    private String mErrorMessage;
    private TextChangeListener mListener = new TextChangeListener();

    WsdlPanel(Project project) {
        this.project = project;
    }

    TemplateWizard getTemplateWizard() {
        return this.templateWizard;
    }

    void setNameTF(JTextField jTextField) {
        this.gui.attachFileNameListener(jTextField);
        if (jTextField != null) {
            jTextField.getDocument().removeDocumentListener(this.mListener);
            jTextField.getDocument().addDocumentListener(this.mListener);
            this.fileNameTextField = jTextField;
        }
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new WsdlUIPanel(this);
            this.gui.getSchemaFileTextField().addPropertyChangeListener(new SchemaImportTextChangeListener());
            this.gui.getSchemaFileTextField().getDocument().addDocumentListener(new SchemaImportTextChangeListener());
        }
        return this.gui;
    }

    public Project getProject() {
        return this.project;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(WsdlPanel.class);
    }

    void cleanup() {
        DataObject dataObject;
        WSDLModel wSDLModel = (WSDLModel)this.templateWizard.getProperty("TEMP_WSDLMODEL");
        if (wSDLModel != null && (dataObject = ActionHelper.getDataObject((Model)wSDLModel)) != null) {
            dataObject.setModified(false);
            try {
                dataObject.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.templateWizard.putProperty("TEMP_WSDLMODEL", null);
        if (this.mTempWSDLModel != null) {
            dataObject = ActionHelper.getDataObject((Model)this.mTempWSDLModel);
            if (dataObject != null) {
                dataObject.setModified(false);
                try {
                    dataObject.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mTempWSDLModel = null;
        }
    }

    public boolean isValid() {
        if (this.templateWizard != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)this.mErrorMessage);
        }
        return this.mErrorMessage == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.templateWizard = (TemplateWizard)object;
        this.cleanup();
        this.templateWizard.putProperty("TEMP_WSDLFILE", null);
        this.tempWSDLFile = null;
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        Object object2 = templateWizard.getValue();
        if (object2 == NotifyDescriptor.CANCEL_OPTION || object2 == WizardDescriptor.PREVIOUS_OPTION) {
            this.cleanup();
            return;
        }
        String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        if (string == null) {
            return;
        }
        templateWizard.putProperty(FILE_NAME, (Object)string);
        String string2 = this.getNS();
        templateWizard.putProperty(WSDL_TARGETNAMESPACE, (Object)string2);
        String string3 = string;
        templateWizard.putProperty(WSDL_DEFINITION_NAME, (Object)string3);
        try {
            if (this.tempWSDLFile == null) {
                this.tempWSDLFile = File.createTempFile(string + "RIT", ".wsdl");
                this.populateFileFromTemplate(this.tempWSDLFile);
                this.tempWSDLFile.deleteOnExit();
                this.templateWizard.putProperty("TEMP_WSDLFILE", (Object)this.tempWSDLFile);
                this.mTempWSDLModel = this.prepareModelFromFile(this.tempWSDLFile, string3);
                templateWizard.putProperty("TEMP_WSDLMODEL", (Object)this.mTempWSDLModel);
            } else {
                templateWizard.putProperty("TEMP_WSDLMODEL", (Object)this.mTempWSDLModel);
                templateWizard.putProperty("TEMP_WSDLFILE", (Object)this.tempWSDLFile);
                this.mTempWSDLModel.startTransaction();
                this.mTempWSDLModel.getDefinitions().setTargetNamespace(string2);
                this.mTempWSDLModel.getDefinitions().setName(string3);
                if (this.mTempWSDLModel.getDefinitions().getTypes() == null) {
                    this.mTempWSDLModel.getDefinitions().setTypes(this.mTempWSDLModel.getFactory().createTypes());
                }
                this.mTempWSDLModel.endTransaction();
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    void populateFileFromTemplate(File file) throws DataObjectNotFoundException, IOException {
        if (this.templateWizard == null) {
            throw new IOException("templateWizard not defined");
        }
        String string = (String)this.templateWizard.getProperty(ENCODING);
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null) {
            EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)dataObject.getPrimaryFile()).getCookie(EditorCookie.class);
            editorCookie.openDocument();
            StyledDocument styledDocument = editorCookie.getDocument();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                stringBuilder.append(styledDocument.getText(0, styledDocument.getLength()));
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            if (!string.equalsIgnoreCase("UTF-8")) {
                stringBuilder.delete(30, 35);
                stringBuilder.insert(30, string);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            outputStreamWriter.write(stringBuilder.toString());
            outputStreamWriter.close();
            fileOutputStream.close();
        }
    }

    WSDLModel prepareModelFromFile(File file, String string) {
        File file2 = FileUtil.normalizeFile((File)file);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)fileObject.canWrite());
        WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
        wSDLModel.startTransaction();
        wSDLModel.getDefinitions().setName(string);
        String string2 = this.getNS();
        wSDLModel.getDefinitions().setTargetNamespace(string2);
        ((AbstractDocumentComponent)wSDLModel.getDefinitions()).addPrefix("tns", string2);
        if (wSDLModel.getDefinitions().getTypes() == null) {
            wSDLModel.getDefinitions().setTypes(wSDLModel.getFactory().createTypes());
        }
        wSDLModel.endTransaction();
        return wSDLModel;
    }

    String getNS() {
        String string = this.gui.getNS();
        if (string.length() == 0) {
            string = DEFAULT_TARGET_NAMESPACE;
        }
        return string;
    }

    WsdlUIPanel.SchemaInfo[] getSchemas() {
        return this.gui.getSchemas();
    }

    boolean isImport() {
        return this.gui.isImport();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    private void fireChangeEvent() {
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ChangeListener changeListener = iterator.next();
            changeListener.stateChanged(changeEvent);
        }
    }

    private boolean isValidName(Document document) {
        try {
            String string = document.getText(0, document.getLength());
            boolean bl = Utils.isValidNCName((String)string);
            this.mErrorMessage = !bl ? NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string) : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mErrorMessage == null;
    }

    private void validateFileName() {
        boolean bl = this.isValidName(this.fileNameTextField.getDocument());
        if (!bl) {
            this.fireChangeEvent();
            return;
        }
    }

    public void validateSchemas() {
        try {
            this.gui.validateSchemas();
        }
        catch (WizardValidationException wizardValidationException) {
            this.mErrorMessage = wizardValidationException.getLocalizedMessage();
            this.fireChangeEvent();
            return;
        }
        this.mErrorMessage = null;
        this.fireChangeEvent();
    }

    class SchemaImportTextChangeListener
    implements PropertyChangeListener,
    DocumentListener {
        SchemaImportTextChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("VALUE_SET")) {
                WsdlPanel.this.validateSchemas();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateSchemas();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateSchemas();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateSchemas();
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateFileName();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateFileName();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            WsdlPanel.this.validateFileName();
        }
    }
}

