/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.wizard.ImportSchemaCreator;
import org.netbeans.modules.xml.wsdl.ui.wizard.WsdlPanel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.ui.customizer.Customizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlUIPanel
extends JPanel {
    private static final String TARGET_URL_PREFIX = NbBundle.getMessage(WsdlUIPanel.class, (String)"TXT_defaultTNS");
    private WsdlPanel wizardPanel;
    private JTextField fileNameTF;
    private boolean hasUserModifiedNamespace = false;
    private NamespaceDocListener mListener = new NamespaceDocListener();
    private JButton browseButton;
    private JCheckBox cbImport;
    private JPanel jPanel1;
    private JLabel namespaceLB;
    private JTextField nsTF;
    private JLabel schemaLB;
    private JTextField schemaTF;

    WsdlUIPanel(WsdlPanel wsdlPanel) {
        this.initComponents();
        this.wizardPanel = wsdlPanel;
        this.nsTF.setText(TARGET_URL_PREFIX);
    }

    void attachFileNameListener(JTextField jTextField) {
        this.fileNameTF = jTextField;
        if (this.fileNameTF != null) {
            this.nsTF.setText(TARGET_URL_PREFIX + this.fileNameTF.getText());
            DocListener docListener = new DocListener();
            Document document = this.fileNameTF.getDocument();
            document.addDocumentListener(docListener);
        } else {
            this.nsTF.setText(TARGET_URL_PREFIX);
        }
        this.nsTF.getDocument().addDocumentListener(this.mListener);
    }

    private void initComponents() {
        this.cbImport = new JCheckBox();
        this.schemaTF = new JTextField();
        this.browseButton = new JButton();
        this.schemaLB = new JLabel();
        this.namespaceLB = new JLabel();
        this.nsTF = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbImport, (String)NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_importSchema"));
        this.cbImport.setToolTipText(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_schemaFiles"));
        this.cbImport.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbImport.setMargin(new Insets(0, 0, 0, 0));
        this.cbImport.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WsdlUIPanel.this.cbImportItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 6, 5);
        this.add((Component)this.cbImport, gridBagConstraints);
        this.cbImport.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_importSchema"));
        this.cbImport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_schemaFiles"));
        this.schemaTF.setEditable(false);
        this.schemaTF.setToolTipText(NbBundle.getBundle(WsdlUIPanel.class).getString("HINT_schemaFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.schemaTF, gridBagConstraints);
        this.schemaTF.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_schemaFiles"));
        this.schemaTF.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"A11Y_schemaTF"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_browse"));
        this.browseButton.setToolTipText(NbBundle.getMessage(WsdlUIPanel.class, (String)"A11Y_browse"));
        this.browseButton.setEnabled(false);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WsdlUIPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_browse"));
        this.schemaLB.setLabelFor(this.schemaTF);
        Mnemonics.setLocalizedText((JLabel)this.schemaLB, (String)NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_schemaFiles"));
        this.schemaLB.setToolTipText(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_schemaFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.schemaLB, gridBagConstraints);
        this.namespaceLB.setLabelFor(this.nsTF);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLB, (String)NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_targetNamespace"));
        this.namespaceLB.setToolTipText(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.namespaceLB, gridBagConstraints);
        this.namespaceLB.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlUIPanel.class, (String)"LBL_targetNamespace"));
        this.namespaceLB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_targetNamespace"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/xml/wsdl/ui/wizard/Bundle");
        this.nsTF.setToolTipText(resourceBundle.getString("HINT_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.add((Component)this.nsTF, gridBagConstraints);
        this.nsTF.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WsdlUIPanel.class, (String)"WsdlUIPanel.nsTF.AccessibleContext.accessibleName"));
        this.nsTF.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WsdlUIPanel.class, (String)"HINT_targetNamespace"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        Project project = this.wizardPanel.getProject();
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("nbproject/private");
        File file = FileUtil.toFile((FileObject)(fileObject2 != null ? fileObject2 : fileObject));
        String string2 = this.fileNameTF.getText();
        if (string2 == null || string2.length() == 0) {
            string2 = "wizard";
        }
        File file2 = null;
        try {
            file2 = File.createTempFile(string2, ".wsdl", file);
            this.wizardPanel.populateFileFromTemplate(file2);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            if (file2 != null) {
                file2.delete();
            }
            return;
        }
        WSDLModel wSDLModel = this.wizardPanel.prepareModelFromFile(file2, string2);
        wSDLModel.startTransaction();
        WSDLSchema wSDLSchema = wSDLModel.getFactory().createWSDLSchema();
        Definitions definitions = wSDLModel.getDefinitions();
        definitions.getTypes().addExtensibilityElement((ExtensibilityElement)wSDLSchema);
        SchemaModel schemaModel = wSDLSchema.getSchemaModel();
        Schema schema = schemaModel.getSchema();
        schema.setTargetNamespace(definitions.getTargetNamespace());
        wSDLModel.endTransaction();
        String string3 = this.schemaTF.getText().trim();
        ImportSchemaCreator importSchemaCreator = new ImportSchemaCreator(schema, wSDLModel, string3);
        DialogDescriptor dialogDescriptor = UIUtilities.getCreatorDialog((Customizer)importSchemaCreator, NbBundle.getMessage(WsdlUIPanel.class, (String)"TITLE_selectSchema"), true);
        dialogDescriptor.setValid(false);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            string = importSchemaCreator.getSelectedFiles();
            this.schemaTF.setText(string);
            this.schemaTF.firePropertyChange("VALUE_SET", false, true);
        }
        file2 = FileUtil.normalizeFile((File)file2);
        string = FileUtil.toFileObject((File)file2);
        try {
            DataObject.find((FileObject)string).delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cbImportItemStateChanged(ItemEvent itemEvent) {
        if (this.cbImport.isSelected()) {
            this.schemaTF.setEditable(true);
            this.browseButton.setEnabled(true);
        } else {
            this.schemaTF.setEditable(false);
            this.browseButton.setEnabled(false);
        }
    }

    String getNS() {
        return this.nsTF.getText();
    }

    boolean isImport() {
        return this.cbImport.isSelected();
    }

    SchemaInfo[] getSchemas() {
        if (this.cbImport.isSelected()) {
            String string = this.schemaTF.getText();
            String[] stringArray = string.split(",");
            ArrayList<SchemaInfo> arrayList = new ArrayList<SchemaInfo>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() == 0) continue;
                URL uRL = null;
                try {
                    File file = new File(string2);
                    uRL = file.exists() ? file.toURI().toURL() : new URL(string2);
                    arrayList.add(new SchemaInfo(uRL));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        DataFolder dataFolder = this.wizardPanel.getTemplateWizard().getTargetFolder();
                        FileObject fileObject = dataFolder.getPrimaryFile();
                        if (fileObject.getFileObject(string2) == null) continue;
                        String string3 = fileObject.getURL().toExternalForm();
                        arrayList.add(new SchemaInfo(new URL(string3 + string2)));
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return arrayList.toArray(new SchemaInfo[arrayList.size()]);
        }
        return new SchemaInfo[0];
    }

    public void validateSchemas() throws WizardValidationException {
        if (this.cbImport.isSelected()) {
            String string = this.schemaTF.getText();
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() == 0) continue;
                this.createSchemaModel(string2);
            }
        }
    }

    private void createSchemaModel(String string) throws WizardValidationException {
        File file;
        Object object;
        Object object2;
        URL uRL;
        File file2 = new File(string);
        if (!file2.exists()) {
            file2 = null;
        }
        if (file2 == null) {
            block20: {
                uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    block19: {
                        try {
                            object2 = this.wizardPanel.getTemplateWizard().getTargetFolder();
                            object = object2.getPrimaryFile();
                            if (object.getFileObject(string) == null) break block19;
                            String string2 = object.getURL().toExternalForm();
                            try {
                                uRL = new URL(string2 + string);
                            }
                            catch (MalformedURLException malformedURLException2) {
                                throw new WizardValidationException((JComponent)this.schemaTF, malformedURLException2.getMessage(), malformedURLException2.getLocalizedMessage());
                            }
                        }
                        catch (IOException iOException) {
                            throw new WizardValidationException((JComponent)this.schemaTF, iOException.getMessage(), iOException.getLocalizedMessage());
                        }
                    }
                    if (uRL != null) break block20;
                    object = NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string);
                    throw new WizardValidationException((JComponent)this.schemaTF, (String)object, (String)object);
                }
            }
            try {
                file2 = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WizardValidationException((JComponent)this.schemaTF, uRISyntaxException.getMessage(), uRISyntaxException.getLocalizedMessage());
            }
        }
        if (!file2.isFile()) {
            throw new WizardValidationException((JComponent)this.schemaTF, "INVALID_SCHEMA_FILE", NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string));
        }
        try {
            file = FileUtil.normalizeFile((File)file2);
            object2 = FileUtil.toFileObject((File)file);
            if (object2 == null) {
                object = NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string);
                throw new WizardValidationException((JComponent)this.schemaTF, (String)object, (String)object);
            }
            this.checkAccessibleFromThisProject(this.wizardPanel.getProject(), (FileObject)object2, string);
            uRL = Utilities.createModelSource((FileObject)object2, (boolean)false);
        }
        catch (WizardValidationException wizardValidationException) {
            throw wizardValidationException;
        }
        catch (CatalogModelException catalogModelException) {
            throw new WizardValidationException((JComponent)this.schemaTF, catalogModelException.getMessage(), catalogModelException.getLocalizedMessage());
        }
        catch (Throwable throwable) {
            object2 = NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string);
            throw new WizardValidationException((JComponent)this.schemaTF, (String)object2, (String)object2);
        }
        file = null;
        try {
            file = SchemaModelFactory.getDefault().getModel((ModelSource)uRL);
        }
        catch (Throwable throwable) {
            object = NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string);
            throw new WizardValidationException((JComponent)this.schemaTF, (String)object, (String)object);
        }
        if (file == null || file.getState().equals((Object)Model.State.NOT_WELL_FORMED)) {
            object2 = NbBundle.getMessage(WsdlUIPanel.class, (String)"INVALID_SCHEMA_FILE", (Object)string);
            throw new WizardValidationException((JComponent)this.schemaTF, (String)object2, (String)object2);
        }
    }

    private void checkAccessibleFromThisProject(Project project, FileObject fileObject, String string) throws WizardValidationException {
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project2 == null) {
            throw new WizardValidationException((JComponent)this.schemaTF, "INACCESSIBLE_FILE", NbBundle.getMessage(WsdlUIPanel.class, (String)"INACCESSIBLE_FILE", (Object)string));
        }
        if (project == project2) {
            return;
        }
        DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)project.getProjectDirectory());
        for (Object e : defaultProjectCatalogSupport.getProjectReferences()) {
            if (e != project2) continue;
            return;
        }
        throw new WizardValidationException((JComponent)this.schemaTF, "INACCESSIBLE_PROJECT", NbBundle.getMessage(WsdlUIPanel.class, (String)"INACCESSIBLE_PROJECT", (Object)string, (Object)project2.getProjectDirectory().getName()));
    }

    public JTextField getSchemaFileTextField() {
        return this.schemaTF;
    }

    static class SchemaInfo {
        private URL url;

        SchemaInfo(URL uRL) {
            this.url = uRL;
        }

        URL getURL() {
            return this.url;
        }

        String getNamespace() {
            InputSource inputSource = new InputSource(this.url.toExternalForm());
            try {
                return this.parse(inputSource);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return "";
        }

        String getSchemaName() {
            return this.url.toExternalForm();
        }

        private String parse(InputSource inputSource) throws IOException, SAXException {
            NsHandler nsHandler;
            block3: {
                XMLReader xMLReader = XMLUtil.createXMLReader();
                nsHandler = new NsHandler();
                xMLReader.setContentHandler(nsHandler);
                try {
                    xMLReader.parse(inputSource);
                }
                catch (SAXException sAXException) {
                    if ("EXIT".equals(sAXException.getMessage())) break block3;
                    throw sAXException;
                }
            }
            String string = nsHandler.getNs();
            if (string == null) {
                return "";
            }
            return string;
        }

        private static class NsHandler
        extends DefaultHandler {
            private String ns;

            private NsHandler() {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string3.endsWith("schema")) {
                    this.ns = attributes.getValue("targetNamespace");
                    throw new SAXException("EXIT");
                }
            }

            String getNs() {
                return this.ns;
            }
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            if (!WsdlUIPanel.this.hasUserModifiedNamespace) {
                WsdlUIPanel.this.nsTF.getDocument().removeDocumentListener(WsdlUIPanel.this.mListener);
                WsdlUIPanel.this.nsTF.setText(TARGET_URL_PREFIX + WsdlUIPanel.this.fileNameTF.getText());
                WsdlUIPanel.this.nsTF.getDocument().addDocumentListener(WsdlUIPanel.this.mListener);
            }
        }
    }

    private class NamespaceDocListener
    implements DocumentListener {
        private NamespaceDocListener() {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            WsdlUIPanel.this.hasUserModifiedNamespace = true;
        }
    }
}

