/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.GroovyIndex;
import org.netbeans.modules.groovy.editor.Methods;
import org.netbeans.modules.groovy.editor.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.elements.IndexedMethod;
import org.netbeans.modules.groovy.editor.lexer.Call;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyDeclarationFinder
implements DeclarationFinder {
    private final Logger LOG = Logger.getLogger(GroovyDeclarationFinder.class.getName());
    Token<? extends GroovyTokenId> tok;
    Document lastDoc = null;
    int lastOffset = -1;
    OffsetRange lastRange = OffsetRange.NONE;

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (tokenSequence == null) {
            return OffsetRange.NONE;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == tokenSequence.offset();
        OffsetRange offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && tokenSequence.movePrevious()) {
            offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(CompilationInfo compilationInfo, int n) {
        try {
            Document document = compilationInfo.getDocument();
            if (document == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            BaseDocument baseDocument = (BaseDocument)document;
            int n2 = AstUtilities.getAstOffset(compilationInfo, n);
            if (n2 == -1) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            OffsetRange offsetRange = this.getReferenceSpan((Document)baseDocument, n);
            if (offsetRange == OffsetRange.NONE) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean bl = offsetRange.getEnd() <= n;
            ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
            if (moduleNode == null) {
                String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                GroovyIndex groovyIndex = new GroovyIndex(compilationInfo.getIndex("text/x-groovy"));
                if (groovyIndex == null || string.length() == 0) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                if (Character.isUpperCase(string.charAt(0))) {
                    Set<IndexedClass> set = groovyIndex.getClasses(string, NameKind.EXACT_NAME, true, false, false);
                    if (set.size() == 0) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    DeclarationFinder.DeclarationLocation declarationLocation = this.getClassDeclaration(compilationInfo, set, null, null, groovyIndex, baseDocument);
                    if (declarationLocation != null) {
                        return declarationLocation;
                    }
                } else {
                    DeclarationFinder.DeclarationLocation declarationLocation;
                    Set<IndexedMethod> set = groovyIndex.getMethods(string, null, NameKind.EXACT_NAME, GroovyIndex.ALL_SCOPE);
                    if (set.size() == 0) {
                        set = groovyIndex.getMethods(string, null, NameKind.EXACT_NAME);
                    }
                    if ((declarationLocation = this.getMethodDeclaration(compilationInfo, string, set, null, null, groovyIndex, n2, n)) != null) {
                        return declarationLocation;
                    }
                }
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            GroovyIndex groovyIndex = new GroovyIndex(compilationInfo.getIndex("text/x-groovy"));
            int n3 = n;
            if (bl && n3 > 0) {
                --n3;
            }
            AstPath astPath = new AstPath((ASTNode)moduleNode, n2, baseDocument);
            ASTNode aSTNode = astPath.leaf();
            ASTNode aSTNode2 = astPath.leafParent();
            if (aSTNode instanceof ConstantExpression && aSTNode2 instanceof MethodCallExpression) {
                Object object;
                Object object2;
                String string = ((ConstantExpression)aSTNode).getText();
                Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n);
                String string2 = call.getType();
                String string3 = call.getLhs();
                MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode2;
                Expression expression = methodCallExpression.getObjectExpression();
                if (expression instanceof VariableExpression) {
                    object2 = (VariableExpression)expression;
                    object = ((VariableExpression)object2).getType().getName();
                    ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)compilationInfo.getFileObject());
                    DeclarationFinder.DeclarationLocation declarationLocation = GroovyDeclarationFinder.findJavaMethod(classpathInfo, (String)object, methodCallExpression);
                    if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                        return declarationLocation;
                    }
                }
                if (string2 == null && string3 != null && aSTNode != null && call.isSimpleIdentifier()) {
                    assert (moduleNode instanceof ModuleNode);
                    object2 = moduleNode;
                    object = new VariableScopeVisitor(((ModuleNode)object2).getContext(), astPath);
                    ((VariableScopeVisitor)object).collect();
                }
                if (string2 == null) {
                    object2 = AstUtilities.getFqnName(astPath);
                    if (call == Call.LOCAL && object2 != null && ((String)object2).length() == 0) {
                        object2 = "java.lang.Object";
                    }
                    return this.findMethod(string, (String)object2, string2, call, compilationInfo, n2, n, astPath, aSTNode, groovyIndex);
                }
            } else if (aSTNode instanceof VariableExpression) {
                ASTNode aSTNode3;
                VariableExpression variableExpression = (VariableExpression)aSTNode;
                ASTNode aSTNode4 = AstUtilities.getScope(astPath, variableExpression);
                if (aSTNode4 != null && (aSTNode3 = AstUtilities.getVariable(aSTNode4, variableExpression.getName(), astPath)) != null) {
                    int n4 = AstUtilities.getRange(aSTNode3, baseDocument).getStart();
                    return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), n4);
                }
            } else if (aSTNode instanceof ConstantExpression && aSTNode2 instanceof PropertyExpression) {
                PropertyExpression propertyExpression = (PropertyExpression)aSTNode2;
                Expression expression = propertyExpression.getObjectExpression();
                Expression expression2 = propertyExpression.getProperty();
                if (expression instanceof VariableExpression && expression2 instanceof ConstantExpression) {
                    VariableExpression variableExpression = (VariableExpression)expression;
                    if ("this".equals(variableExpression.getName())) {
                        ASTNode aSTNode5;
                        ASTNode aSTNode6 = AstUtilities.getOwningClass(astPath);
                        if (aSTNode6 == null) {
                            aSTNode6 = (ModuleNode)astPath.root();
                        }
                        if ((aSTNode5 = AstUtilities.getVariable(aSTNode6, ((ConstantExpression)expression2).getText(), astPath)) != null) {
                            int n5 = AstUtilities.getOffset(baseDocument, aSTNode5.getLineNumber(), aSTNode5.getColumnNumber());
                            return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), n5);
                        }
                    } else {
                        ClassNode classNode = variableExpression.getType();
                        String string = classNode.getName();
                        String string4 = ((ConstantExpression)aSTNode).getText();
                        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)compilationInfo.getFileObject());
                        DeclarationFinder.DeclarationLocation declarationLocation = GroovyDeclarationFinder.findJavaField(classpathInfo, string, string4);
                        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                            return declarationLocation;
                        }
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == GroovyTokenId.IDENTIFIER && token.length() == 1 && tokenId == GroovyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            assert (false) : "Never planned to be here";
            return OffsetRange.NONE;
        }
        if (tokenId == GroovyTokenId.IDENTIFIER) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    private DeclarationFinder.DeclarationLocation getClassDeclaration(CompilationInfo compilationInfo, Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex, BaseDocument baseDocument) {
        IndexedClass indexedClass = this.findBestClassMatch(set, astPath, aSTNode, groovyIndex);
        if (indexedClass != null) {
            IndexedClass indexedClass2 = indexedClass;
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedClass2);
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(indexedClass2.getFile().getFileObject(), AstUtilities.getOffset(baseDocument, aSTNode2.getLineNumber(), aSTNode2.getColumnNumber()), (ElementHandle)indexedClass2);
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findMethod(String string, String string2, String string3, Call call, CompilationInfo compilationInfo, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        Set<IndexedMethod> set = this.getApplicableMethods(string, string2, string3, call, groovyIndex);
        int n3 = n;
        DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(compilationInfo, string, set, astPath, aSTNode, groovyIndex, n3, n2);
        return declarationLocation;
    }

    private Set<IndexedMethod> getApplicableMethods(String string, String string2, String string3, Call call, GroovyIndex groovyIndex) {
        Set<IndexedMethod> set = new HashSet<IndexedMethod>();
        String string4 = string2;
        if (string3 == null && string2 != null && call.getLhs() == null && call != Call.UNKNOWN) {
            string4 = string2;
            if (set.size() == 0) {
                set = groovyIndex.getMethods(string, string4, NameKind.EXACT_NAME);
            }
            set = groovyIndex.getInheritedMethods(string4, string, NameKind.EXACT_NAME);
        }
        if (string3 != null && set.size() == 0) {
            string4 = string2;
            if (set.size() == 0) {
                set = groovyIndex.getInheritedMethods(string4 + "." + string3, string, NameKind.EXACT_NAME);
            }
            if (set.size() == 0 && (set = groovyIndex.getInheritedMethods(string3, string, NameKind.EXACT_NAME)).size() == 0 && string3.indexOf(".") == -1) {
                Set<IndexedClass> set2 = groovyIndex.getClasses(string3, NameKind.EXACT_NAME, false, false, false);
                HashSet<String> hashSet = new HashSet<String>();
                for (IndexedClass object : set2) {
                    String string5 = object.getFqn();
                    if (string5 == null) continue;
                    hashSet.add(string5);
                }
                for (String string6 : hashSet) {
                    if (string6.equals(string3)) continue;
                    set.addAll(groovyIndex.getInheritedMethods(string6, string, NameKind.EXACT_NAME));
                }
            }
            if (set.size() == 0) {
                int n;
                for (string4 = string2; set.size() == 0 && string4 != null && string4.length() > 0; string4 = string4.substring(0, n)) {
                    set = groovyIndex.getMethods(string, string4 + "." + string3, NameKind.EXACT_NAME);
                    n = string4.lastIndexOf(".");
                    if (n == -1) break;
                }
            }
        }
        if (set.size() == 0 && (set = groovyIndex.getMethods(string, string3, NameKind.EXACT_NAME)).size() == 0 && string3 != null) {
            set = groovyIndex.getMethods(string, null, NameKind.EXACT_NAME);
        }
        return set;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(CompilationInfo compilationInfo, String string, Set<IndexedMethod> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex, int n, int n2) {
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        IndexedMethod indexedMethod = this.findBestMethodMatch(string, set, baseDocument, n, n2, astPath, aSTNode, groovyIndex);
        if (indexedMethod != null) {
            FileObject fileObject = indexedMethod.getFile().getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedMethod);
            int n3 = aSTNode2 != null ? AstUtilities.getOffset(baseDocument, aSTNode2.getLineNumber(), aSTNode2.getColumnNumber()) : 0;
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, n3, (ElementHandle)indexedMethod);
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    IndexedClass findBestClassMatch(Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>(set);
        while (!hashSet.isEmpty()) {
            IndexedClass indexedClass = this.findBestClassMatchHelper(hashSet, astPath, aSTNode, groovyIndex);
            if (indexedClass == null) {
                return null;
            }
            ASTNode aSTNode2 = AstUtilities.getForeignNode(indexedClass);
            if (aSTNode2 != null) {
                return indexedClass;
            }
            if (!hashSet.contains(indexedClass)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedClass);
        }
        return null;
    }

    private IndexedClass findBestClassMatchHelper(Set<IndexedClass> set, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        return null;
    }

    IndexedMethod findBestMethodMatch(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>(set);
        while (!hashSet.isEmpty()) {
            ASTNode aSTNode2;
            IndexedMethod indexedMethod = this.findBestMethodMatchHelper(string, hashSet, baseDocument, n, n2, astPath, aSTNode, groovyIndex);
            ASTNode aSTNode3 = aSTNode2 = indexedMethod == null ? null : AstUtilities.getForeignNode(indexedMethod);
            if (aSTNode2 != null) {
                return indexedMethod;
            }
            if (!hashSet.contains(indexedMethod)) {
                hashSet.remove(hashSet.iterator().next());
                continue;
            }
            hashSet.remove(indexedMethod);
        }
        if (set.size() > 0) {
            return set.iterator().next();
        }
        return null;
    }

    private IndexedMethod findBestMethodMatchHelper(String string, Set<IndexedMethod> set, BaseDocument baseDocument, int n, int n2, AstPath astPath, ASTNode aSTNode, GroovyIndex groovyIndex) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        ASTNode aSTNode2 = astPath.leafParent();
        if (aSTNode instanceof ConstantExpression && aSTNode2 instanceof MethodCallExpression) {
            String string2 = null;
            MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode2;
            Expression expression = methodCallExpression.getObjectExpression();
            if (expression instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)expression;
                string2 = "this".equals(variableExpression.getName()) ? AstUtilities.getFqnName(astPath) : variableExpression.getType().getName();
            }
            if (string2 != null) {
                for (IndexedMethod indexedMethod : set) {
                    if (!string2.equals(indexedMethod.getClz())) continue;
                    hashSet.add(indexedMethod);
                }
            }
        }
        if (hashSet.size() == 1) {
            return (IndexedMethod)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation fix(DeclarationFinder.DeclarationLocation declarationLocation, CompilationInfo compilationInfo) {
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE && declarationLocation.getFileObject() == null && declarationLocation.getUrl() == null) {
            return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), declarationLocation.getOffset(), declarationLocation.getElement());
        }
        return declarationLocation;
    }

    private static DeclarationFinder.DeclarationLocation findJavaField(ClasspathInfo classpathInfo, final String string, final String string2) {
        final org.netbeans.api.java.source.ElementHandle[] elementHandleArray = new org.netbeans.api.java.source.ElementHandle[1];
        final int[] nArray = new int[1];
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            FileObject fileObject;
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                            if (!variableElement.getSimpleName().contentEquals(string2)) continue;
                            elementHandleArray[0] = org.netbeans.api.java.source.ElementHandle.create((Element)variableElement);
                        }
                    }
                }
            }, true);
            if (elementHandleArray[0] != null && (fileObject = SourceUtils.getFile((org.netbeans.api.java.source.ElementHandle)elementHandleArray[0], (ClasspathInfo)classpathInfo)) != null) {
                javaSource = JavaSource.forFileObject((FileObject)fileObject);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element element = elementHandleArray[0].resolve((org.netbeans.api.java.source.CompilationInfo)compilationController);
                        Trees trees = compilationController.getTrees();
                        Tree tree = trees.getTree(element);
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        nArray[0] = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                    }
                }, true);
                return new DeclarationFinder.DeclarationLocation(fileObject, nArray[0]);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static DeclarationFinder.DeclarationLocation findJavaMethod(ClasspathInfo classpathInfo, final String string, final MethodCallExpression methodCallExpression) {
        final org.netbeans.api.java.source.ElementHandle[] elementHandleArray = new org.netbeans.api.java.source.ElementHandle[1];
        final int[] nArray = new int[1];
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            FileObject fileObject;
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                            if (!Methods.isSameMethod(executableElement, methodCallExpression)) continue;
                            elementHandleArray[0] = org.netbeans.api.java.source.ElementHandle.create((Element)executableElement);
                        }
                    }
                }
            }, true);
            if (elementHandleArray[0] != null && (fileObject = SourceUtils.getFile((org.netbeans.api.java.source.ElementHandle)elementHandleArray[0], (ClasspathInfo)classpathInfo)) != null) {
                javaSource = JavaSource.forFileObject((FileObject)fileObject);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element element = elementHandleArray[0].resolve((org.netbeans.api.java.source.CompilationInfo)compilationController);
                        Trees trees = compilationController.getTrees();
                        Tree tree = trees.getTree(element);
                        SourcePositions sourcePositions = trees.getSourcePositions();
                        nArray[0] = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                    }
                }, true);
                return new DeclarationFinder.DeclarationLocation(fileObject, nArray[0]);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }
}

