/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.groovy.editor.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.elements.IndexedMethod;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroovyIndex {
    public static final Set<Index.SearchScope> ALL_SCOPE = EnumSet.allOf(Index.SearchScope.class);
    public static final Set<Index.SearchScope> SOURCE_SCOPE = EnumSet.of(Index.SearchScope.SOURCE);
    private static final String CLUSTER_URL = "cluster:";
    private static String clusterUrl = null;
    private final Index index;

    public GroovyIndex(Index index) {
        this.index = index;
    }

    public Set<IndexedClass> getClasses(String string, NameKind nameKind, boolean bl, boolean bl2, boolean bl3) {
        return this.getClasses(string, nameKind, bl, bl2, bl3, ALL_SCOPE, null);
    }

    public Set<IndexedClass> getClasses(String string, NameKind nameKind, boolean bl, boolean bl2, boolean bl3, Set<Index.SearchScope> set, Set<String> set2) {
        String string2;
        String string3 = null;
        if (string != null && string.endsWith(".")) {
            string3 = string.substring(0, string.length() - 1);
            string = "";
        }
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        switch (nameKind) {
            case EXACT_NAME: 
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                string2 = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                string2 = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        this.search(string2, string, nameKind, hashSet, set);
        if (bl) {
            set2 = null;
        } else if (set2 == null) {
            set2 = new HashSet<String>();
        }
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            String string4;
            String string5 = searchResult.getValue("class");
            if (string5 == null || nameKind == NameKind.PREFIX && !string5.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string5.regionMatches(true, 0, string, 0, string.length())) continue;
            if (string3 != null) {
                if (nameKind == NameKind.CASE_INSENSITIVE_PREFIX || nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                    if (!string3.equalsIgnoreCase(searchResult.getValue("in"))) {
                        continue;
                    }
                } else if (nameKind == NameKind.CAMEL_CASE) {
                    int n2;
                    string4 = searchResult.getValue("in");
                    if (string4 == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    n = 0;
                    do {
                        int n3 = -1;
                        for (int i = n + 1; i < string3.length(); ++i) {
                            if (!Character.isUpperCase(string3.charAt(i))) continue;
                            n3 = i;
                            break;
                        }
                        String string6 = string3.substring(n, (n2 = n3) == -1 ? string3.length() : n2);
                        stringBuilder.append(string6);
                        stringBuilder.append(n2 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                        n = n2;
                    } while (n2 != -1);
                    Pattern pattern = Pattern.compile(stringBuilder.toString());
                    if (!pattern.matcher(string4).matches()) {
                        continue;
                    }
                } else if (!string3.equals(searchResult.getValue("in"))) continue;
            }
            string4 = searchResult.getValue("attrs");
            boolean bl4 = true;
            if (string4 != null) {
                n = IndexedElement.stringToFlag(string4, 0);
                boolean bl5 = bl4 = (n & 0x40) == 0;
            }
            if (bl2 && bl4 || bl3 && !bl4) continue;
            String string7 = searchResult.getValue("fqn");
            if (!bl && !set2.contains(string7)) {
                set2.add(string7);
            }
            hashSet2.add(this.createClass(string7, string5, searchResult));
        }
        return hashSet2;
    }

    Set<IndexedMethod> getMethods(String string, String string2, NameKind nameKind) {
        return this.getMethods(string, string2, nameKind, ALL_SCOPE);
    }

    public Set<IndexedMethod> getMethods(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set) {
        boolean bl = string2 == null;
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string3 = "method";
        NameKind nameKind2 = nameKind;
        if (nameKind == NameKind.EXACT_NAME) {
            nameKind = NameKind.PREFIX;
        }
        this.search(string3, string, nameKind, hashSet, set);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            if (string2 != null && !string2.equals(stringArray2 = searchResult.getValue("fqn"))) continue;
            stringArray2 = searchResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string4;
                    block12: {
                        string4 = stringArray[n];
                        if ((string == null || string.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || nameKind == NameKind.PREFIX && !string4.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
                        if (nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                            int n3 = string4.length();
                            int n4 = string4.indexOf(40);
                            if (n4 == -1 && (n4 = string4.indexOf(59)) == -1) {
                                n4 = n3;
                            }
                            String string5 = n4 != n3 ? string4.substring(0, n4) : string4;
                            try {
                                if (!string5.matches(string)) {
                                    continue;
                                }
                                break block12;
                            }
                            catch (Exception exception) {
                                break block12;
                            }
                        }
                        if (nameKind2 == NameKind.EXACT_NAME && string4.length() > string.length() && string4.charAt(string.length()) != '(' && string4.charAt(string.length()) != ';') continue;
                    }
                    assert (searchResult != null);
                    hashSet2.add(this.createMethod(string4, searchResult, bl));
                }
            }
            if ((stringArray = searchResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string6 = stringArray3[i];
                if ((string == null || string.length() == 0) && !Character.isLowerCase(string6.charAt(0)) || nameKind == NameKind.PREFIX && !string6.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string6.regionMatches(true, 0, string, 0, string.length()) || nameKind == NameKind.CASE_INSENSITIVE_REGEXP && !string6.matches(string) || nameKind2 == NameKind.EXACT_NAME && string6.length() > string.length() && string6.charAt(string.length()) != ';') continue;
                assert (searchResult != null);
                hashSet2.add(this.createMethod(string6, searchResult, bl));
            }
        }
        return hashSet2;
    }

    public Set<IndexedMethod> getInheritedMethods(String string, String string2, NameKind nameKind) {
        boolean bl = false;
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string2 == null) {
            string2 = "";
        }
        this.addMethodsFromClass(string2, nameKind, string, hashSet, hashSet3, hashSet2, bl, false);
        return hashSet;
    }

    private boolean addMethodsFromClass(String string, NameKind nameKind, String string2, Set<IndexedMethod> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2) {
        boolean bl3;
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        String string3 = "fqn";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string3, string2, NameKind.EXACT_NAME, hashSet);
        boolean bl4 = bl3 = hashSet.size() > 0;
        if (!bl3) {
            return bl3;
        }
        String string4 = null;
        String string5 = null;
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string5 = string2.substring(0, n);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            Object object2;
            int n2;
            String[] stringArray;
            Index.SearchResult searchResult = (Index.SearchResult)object.next();
            assert (searchResult != null);
            String[] stringArray2 = searchResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string6 = stringArray[n2];
                    if (string.length() == 0 && !Character.isLowerCase(string6.charAt(0)) || set2.contains(string6) || !string6.startsWith(string)) continue;
                    if (nameKind == NameKind.EXACT_NAME) {
                        if (string6.length() > string.length() && string6.charAt(string.length()) != '(' && string6.charAt(string.length()) != ';') {
                            continue;
                        }
                    } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                    set2.add(string6);
                    object2 = this.createMethod(string6, searchResult, bl2);
                    ((IndexedMethod)object2).setSmart(!bl);
                    set.add((IndexedMethod)object2);
                }
            }
            if ((stringArray = searchResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n2 = stringArray3.length;
            for (int i = 0; i < n2; ++i) {
                object2 = stringArray3[i];
                if (string.length() == 0 && !Character.isLowerCase(((String)object2).charAt(0)) || set2.contains(object2) || !((String)object2).startsWith(string)) continue;
                if (nameKind == NameKind.EXACT_NAME) {
                    if (((String)object2).length() > string.length() && ((String)object2).charAt(string.length()) != '(' && ((String)object2).charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                set2.add((String)object2);
                IndexedMethod indexedMethod = this.createMethod((String)object2, searchResult, bl2);
                indexedMethod.setSmart(!bl);
                indexedMethod.setMethodType(IndexedMethod.MethodType.ATTRIBUTE);
                set.add(indexedMethod);
            }
        }
        if (string4 == null) {
            this.addMethodsFromClass(string, nameKind, "java.lang.Object", set, set2, set3, true, true);
        } else if (!this.addMethodsFromClass(string, nameKind, string4, set, set2, set3, bl, true)) {
            int n4;
            for (object = string5; object != null && !this.addMethodsFromClass(string, nameKind, (String)object + "." + string4, set, set2, set3, bl, true) && (n4 = ((String)object).lastIndexOf(".")) != -1; object = ((String)object).substring(0, n4)) {
            }
        }
        return bl3;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = GroovyIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private IndexedClass createClass(String string, String string2, Index.SearchResult searchResult) {
        String string3 = searchResult.getPersistentUrl();
        if (string2 == null) {
            string2 = searchResult.getValue("class");
        }
        String string4 = searchResult.getValue("attrs");
        int n = 0;
        if (string4 != null) {
            n = IndexedElement.stringToFlag(string4, 0);
        }
        IndexedClass indexedClass = IndexedClass.create(this, string2, string, string3, string4, n);
        return indexedClass;
    }

    private IndexedMethod createMethod(String string, Index.SearchResult searchResult, boolean bl) {
        String string2 = searchResult.getValue("class");
        String string3 = searchResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "." + string2;
        }
        String string4 = searchResult.getPersistentUrl();
        String string5 = searchResult.getValue("fqn");
        int n = string.indexOf(59);
        String string6 = null;
        int n2 = 0;
        if (n != -1) {
            n2 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string6 = string.substring(n + 1, string.length());
            }
            string = string.substring(0, n);
        }
        IndexedMethod indexedMethod = IndexedMethod.create(this, string, string5, string2, string4, string6, n2);
        indexedMethod.setInherited(bl);
        return indexedMethod;
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set) {
        try {
            this.index.search(string, string2, nameKind, ALL_SCOPE, set, null);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set, Set<Index.SearchScope> set2) {
        try {
            this.index.search(string, string2, nameKind, set2, set, null);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = GroovyIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-groovy-editor.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }
}

