/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.GroovyIndex;
import org.netbeans.modules.groovy.editor.StructureAnalyzer;
import org.netbeans.modules.groovy.editor.elements.AstClassElement;
import org.netbeans.modules.groovy.editor.elements.AstElement;
import org.netbeans.modules.groovy.editor.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyIndexer
implements Indexer {
    static final String FQN_NAME = "fqn";
    static final String CLASS_NAME = "class";
    static final String CASE_INSENSITIVE_CLASS_NAME = "class-ig";
    static final String IN = "in";
    static final String CLASS_ATTRS = "attrs";
    static final String METHOD_NAME = "method";
    static final String FIELD_NAME = "field";
    static final String ATTRIBUTE_NAME = "attribute";
    private static FileObject preindexedDb;

    public boolean isIndexable(ParserFile parserFile) {
        String string = parserFile.getExtension();
        return string.equals("groovy");
    }

    public List<IndexDocument> index(ParserResult parserResult, IndexDocumentFactory indexDocumentFactory) throws IOException {
        GroovyParserResult groovyParserResult = (GroovyParserResult)parserResult;
        ModuleNode moduleNode = AstUtilities.getRoot(groovyParserResult);
        if (moduleNode == null) {
            return null;
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(groovyParserResult, indexDocumentFactory);
        treeAnalyzer.analyze();
        return treeAnalyzer.getDocuments();
    }

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return GroovyIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    public String getIndexVersion() {
        return "0.6";
    }

    public String getIndexerName() {
        return "groovy";
    }

    public FileObject getPreindexedDb() {
        if (preindexedDb == null) {
            File file = InstalledFileLocator.getDefault().locate("preindexed-groovy", "org.netbeans.modules.groovy.editor", false);
            if (file == null || !file.isDirectory()) {
                throw new RuntimeException("Can't locate preindexed directory. Installation might be damaged");
            }
            preindexedDb = FileUtil.toFileObject((File)file);
        }
        return preindexedDb;
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    private static int getFieldModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 8 : 0;
        if (set.contains(Modifier.PUBLIC)) {
            n |= 1;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 4;
        }
        return n;
    }

    private static int getMethodModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 8 : 0;
        if (set.contains(Modifier.PRIVATE)) {
            n |= 2;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 4;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final ParserFile file;
        private String url;
        private final GroovyParserResult result;
        private BaseDocument doc;
        private IndexDocumentFactory factory;
        private List<IndexDocument> documents = new ArrayList<IndexDocument>();

        private TreeAnalyzer(GroovyParserResult groovyParserResult, IndexDocumentFactory indexDocumentFactory) {
            this.result = groovyParserResult;
            this.file = groovyParserResult.getFile();
            this.factory = indexDocumentFactory;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() throws IOException {
            FileObject fileObject = this.file.getFileObject();
            if (this.result.getInfo() != null) {
                this.doc = AstUtilities.getBaseDocument(fileObject, true);
            } else {
                if (fileObject.getSize() > 0x100000L) {
                    return;
                }
                this.doc = AstUtilities.getBaseDocument(fileObject, true);
            }
            try {
                this.url = fileObject.getURL().toExternalForm();
                this.url = GroovyIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            StructureAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            List<? extends AstElement> list = analysisResult.getElements();
            if (list == null || list.size() == 0) {
                return;
            }
            for (AstElement astElement : list) {
                switch (astElement.getKind()) {
                    case CLASS: {
                        this.analyzeClass((AstClassElement)astElement);
                    }
                }
            }
        }

        private void analyzeClass(AstClassElement astClassElement) {
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            this.indexClass(astClassElement, indexDocument);
            for (AstElement astElement : astClassElement.getChildren()) {
                switch (astElement.getKind()) {
                    case METHOD: {
                        this.indexMethod(astElement, indexDocument);
                        break;
                    }
                    case FIELD: {
                        this.indexField(astElement, indexDocument);
                    }
                }
            }
        }

        private void indexClass(AstClassElement astClassElement, IndexDocument indexDocument) {
            String string = astClassElement.getName();
            indexDocument.addPair(GroovyIndexer.FQN_NAME, astClassElement.getFqn(), true);
            indexDocument.addPair(GroovyIndexer.CLASS_NAME, string, true);
            indexDocument.addPair(GroovyIndexer.CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true);
        }

        private void indexField(AstElement astElement, IndexDocument indexDocument) {
            String string = astElement.getName();
            int n = GroovyIndexer.getFieldModifiersFlag(astElement.getModifiers());
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            indexDocument.addPair(GroovyIndexer.FIELD_NAME, string, true);
        }

        private void indexMethod(AstElement astElement, IndexDocument indexDocument) {
            MethodNode methodNode = (MethodNode)astElement.getNode();
            String string = AstUtilities.getDefSignature(methodNode);
            Set<Modifier> set = astElement.getModifiers();
            int n = GroovyIndexer.getMethodModifiersFlag(set);
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            indexDocument.addPair(GroovyIndexer.METHOD_NAME, string, true);
        }
    }
}

