/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.groovy.editor.NbUtilities;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.completion.GroovyCompletionItem;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaMethodItem
extends GroovyCompletionItem {
    private final Element javaElement;

    JavaMethodItem(Element element, int n, CodeCompleter.CompletionRequest completionRequest) {
        super(null, n, completionRequest);
        this.javaElement = element;
    }

    @Override
    public String getName() {
        return this.javaElement.getSimpleName().toString() + "()";
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.METHOD;
    }

    @Override
    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        String string = "";
        if (this.javaElement instanceof ExecutableElement) {
            string = CodeCompleter.getParameterListForMethod((ExecutableElement)this.javaElement);
        }
        return this.javaElement.getSimpleName().toString() + "(" + string + ")";
    }

    @Override
    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        String string = ((ExecutableElement)this.javaElement).getReturnType().getClass().toString();
        string = NbUtilities.stripPackage(string);
        htmlFormatter.appendHtml(string);
        return htmlFormatter.getText();
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)ElementIcons.getElementIcon((javax.lang.model.element.ElementKind)javax.lang.model.element.ElementKind.METHOD, null);
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public ElementHandle getElement() {
        return null;
    }
}

