/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.openide.filesystems.FileObject;

public class GroovyParserManager {
    private static GroovyParserManager INSTANCE;
    private Map<FileObject, GroovyParserResult> parsedFiles = new HashMap<FileObject, GroovyParserResult>();

    public GroovyParserManager() {
        INSTANCE = this;
    }

    public static synchronized GroovyParserManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GroovyParserManager();
        }
        return INSTANCE;
    }

    public void registerParsing(FileObject fileObject, GroovyParserResult groovyParserResult) {
        assert (fileObject != null);
        assert (groovyParserResult != null);
        if (this.isRegistered(fileObject)) {
            this.parsedFiles.remove(fileObject);
        }
        this.parsedFiles.put(fileObject, groovyParserResult);
    }

    public GroovyParserResult getParsingResultByFileObject(FileObject fileObject) {
        return this.parsedFiles.get(fileObject);
    }

    public boolean isRegistered(FileObject fileObject) {
        return this.parsedFiles.containsKey(fileObject);
    }
}

