/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.ResolveVisitor;
import org.netbeans.modules.groovy.editor.elements.AstRootElement;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.parser.SourceUtils;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.java.preprocessorbridge.spi.VirtualSourceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyVirtualSourceProvider
implements VirtualSourceProvider {
    public Set<String> getSupportedExtensions() {
        return Collections.singleton("groovy");
    }

    public void translate(Iterable<File> iterable, File file, VirtualSourceProvider.Result result) {
        JavaStubGenerator javaStubGenerator = new JavaStubGenerator();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        for (File file2 : iterable) {
            String string;
            CharSequence charSequence;
            List<ClassNode> list = GroovyVirtualSourceProvider.getClassNodes(file2);
            if (list.isEmpty()) {
                FileObject fileObject2 = FileUtil.toFileObject((File)file2);
                String string2 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2.getParent());
                if (string2 == null) continue;
                String string3 = string2.replace('/', '.');
                charSequence = new StringBuilder();
                if (!string3.equals("")) {
                    ((StringBuilder)charSequence).append("package " + string3 + ";");
                }
                string = fileObject2.getName();
                ((StringBuilder)charSequence).append("public class " + string + "{}");
                result.add(file2, string3, string, (CharSequence)((StringBuilder)charSequence).toString());
                continue;
            }
            for (ClassNode classNode : list) {
                try {
                    charSequence = javaStubGenerator.generateClass(classNode);
                    string = classNode.getPackageName();
                    if (string == null) {
                        string = "";
                    }
                    result.add(file2, string, classNode.getNameWithoutPackage(), charSequence);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Exceptions.printStackTrace((Throwable)fileNotFoundException);
                }
            }
        }
    }

    static List<ClassNode> getClassNodes(File file) {
        final ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            SourceUtils.runUserActionTask(fileObject, new CancellableTask<GroovyParserResult>(){

                public void run(GroovyParserResult groovyParserResult) throws Exception {
                    ModuleNode moduleNode;
                    AstRootElement astRootElement = groovyParserResult.getRootElement();
                    if (astRootElement != null && (moduleNode = astRootElement.getModuleNode()) != null) {
                        arrayList.addAll(moduleNode.getClasses());
                    }
                }

                public void cancel() {
                }
            }, false);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return arrayList;
    }

    public boolean index() {
        return false;
    }

    static final class JavaStubGenerator {
        private boolean java5 = false;
        private boolean requireSuperResolved = false;
        private List toCompile = new ArrayList();

        private JavaStubGenerator(boolean bl, boolean bl2) {
            this.requireSuperResolved = bl;
            this.java5 = bl2;
        }

        public JavaStubGenerator() {
            this(false, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSequence generateClass(ClassNode classNode) throws FileNotFoundException {
            if (this.requireSuperResolved && !classNode.getSuperClass().isResolved()) {
                return null;
            }
            String string = classNode.getName().replace('.', '/');
            this.toCompile.add(string);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                ClassNode[] classNodeArray;
                String string2 = classNode.getPackageName();
                if (string2 != null) {
                    printWriter.println("package " + string2 + ";\n");
                }
                this.genImports(classNode, printWriter);
                boolean bl = classNode.isInterface();
                boolean bl2 = (classNode.getModifiers() & 0x4000) != 0;
                this.printModifiers(printWriter, classNode.getModifiers() & ~(bl ? 1024 : 0));
                if (bl) {
                    printWriter.print("interface ");
                } else if (bl2) {
                    printWriter.print("enum ");
                } else {
                    printWriter.print("class ");
                }
                printWriter.println(classNode.getNameWithoutPackage());
                this.writeGenericsBounds(printWriter, classNode, true);
                ClassNode classNode2 = classNode.getUnresolvedSuperClass(false);
                if (!bl && !bl2) {
                    printWriter.print("  extends ");
                    this.printType(classNode2, printWriter);
                }
                if ((classNodeArray = classNode.getInterfaces()) != null && classNodeArray.length > 0) {
                    if (bl) {
                        printWriter.println("  extends");
                    } else {
                        printWriter.println("  implements");
                    }
                    for (int i = 0; i < classNodeArray.length - 1; ++i) {
                        printWriter.print("    ");
                        this.printType(classNodeArray[i], printWriter);
                        printWriter.print(",");
                    }
                    printWriter.print("    ");
                    this.printType(classNodeArray[classNodeArray.length - 1], printWriter);
                }
                printWriter.println(" {");
                this.genFields(classNode, printWriter, bl2);
                this.genMethods(classNode, printWriter, bl2);
                this.genProps(classNode, printWriter);
                printWriter.println("}");
            }
            finally {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
                try {
                    stringWriter.close();
                }
                catch (IOException iOException) {}
            }
            return stringWriter.toString();
        }

        private void genMethods(ClassNode classNode, PrintWriter printWriter, boolean bl) {
            Parameter[] parameterArray;
            Object object;
            Object object22;
            List list;
            if (!bl) {
                this.getConstructors(classNode, printWriter);
            }
            if ((list = classNode.getMethods()) != null) {
                for (Object object22 : list) {
                    if (bl && ((AnnotatedNode)object22).isSynthetic()) {
                        object = ((MethodNode)object22).getName();
                        parameterArray = ((MethodNode)object22).getParameters();
                        if (((String)object).equals("values") && parameterArray.length == 0 || ((String)object).equals("valueOf") && parameterArray.length == 1 && parameterArray[0].getType().equals(ClassHelper.STRING_TYPE)) continue;
                    }
                    this.genMethod(classNode, (MethodNode)object22, printWriter);
                }
            }
            List list2 = classNode.getProperties();
            object22 = list2.iterator();
            while (object22.hasNext()) {
                MethodNode methodNode;
                object = object22.next();
                parameterArray = (Parameter[])object;
                if (parameterArray.isSynthetic()) continue;
                String string = parameterArray.getName();
                string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
                MethodNode methodNode2 = classNode.getGetterMethod("get" + string);
                if (methodNode2 != null) {
                    this.genMethod(classNode, methodNode2, printWriter, false);
                }
                if ((methodNode = classNode.getSetterMethod("set" + string)) == null) continue;
                this.genMethod(classNode, methodNode, printWriter, false);
            }
        }

        private void getConstructors(ClassNode classNode, PrintWriter printWriter) {
            List list = classNode.getDeclaredConstructors();
            if (list != null) {
                for (ConstructorNode constructorNode : list) {
                    this.genConstructor(classNode, constructorNode, printWriter);
                }
            }
        }

        private void genFields(ClassNode classNode, PrintWriter printWriter, boolean bl) {
            List list = classNode.getFields();
            if (list == null) {
                return;
            }
            ArrayList<FieldNode> arrayList = new ArrayList<FieldNode>(list.size());
            ArrayList<FieldNode> arrayList2 = new ArrayList<FieldNode>(list.size());
            for (FieldNode fieldNode : list) {
                boolean bl2;
                boolean bl3 = (fieldNode.getModifiers() & 0x4000) != 0;
                boolean bl4 = bl2 = (fieldNode.getModifiers() & 0x1000) != 0;
                if (bl3) {
                    arrayList.add(fieldNode);
                    continue;
                }
                if (bl2) continue;
                arrayList2.add(fieldNode);
            }
            this.genEnumFields(arrayList, printWriter);
            for (FieldNode fieldNode : arrayList2) {
                this.genField(fieldNode, printWriter);
            }
        }

        private void genProps(ClassNode classNode, PrintWriter printWriter) {
            List list = classNode.getProperties();
            if (list != null) {
                for (PropertyNode propertyNode : list) {
                    this.genProp(propertyNode, printWriter);
                }
            }
        }

        private void genProp(PropertyNode propertyNode, PrintWriter printWriter) {
            String string = propertyNode.getName().substring(0, 1).toUpperCase() + propertyNode.getName().substring(1);
            String string2 = "get" + string;
            boolean bl = false;
            List list = propertyNode.getField().getOwner().getMethods(string2);
            if (list != null) {
                for (MethodNode methodNode : list) {
                    if (methodNode.getParameters().length != 0) continue;
                    bl = true;
                }
            }
            if (!bl) {
                this.printModifiers(printWriter, propertyNode.getModifiers());
                this.printType(propertyNode.getType(), printWriter);
                printWriter.print(" ");
                printWriter.print(string2);
                printWriter.print("() { ");
                this.printReturn(printWriter, propertyNode.getType());
                printWriter.println(" }");
            }
            String string3 = "set" + string;
            boolean bl2 = false;
            List list2 = propertyNode.getField().getOwner().getMethods(string3);
            if (list2 != null) {
                for (MethodNode methodNode : list2) {
                    if (methodNode.getParameters().length != 1) continue;
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.printModifiers(printWriter, propertyNode.getModifiers());
                printWriter.print("void ");
                printWriter.print(string3);
                printWriter.print("(");
                this.printType(propertyNode.getType(), printWriter);
                printWriter.println(" value) {}");
            }
        }

        private void genEnumFields(List list, PrintWriter printWriter) {
            if (list.size() == 0) {
                return;
            }
            boolean bl = true;
            for (FieldNode fieldNode : list) {
                if (!bl) {
                    printWriter.print(", ");
                } else {
                    bl = false;
                }
                printWriter.print(fieldNode.getName());
            }
            printWriter.println(";");
        }

        private void genField(FieldNode fieldNode, PrintWriter printWriter) {
            if (fieldNode.isSynthetic() || "metaClass".equals(fieldNode.getName())) {
                return;
            }
            if ((fieldNode.getModifiers() & 2) != 0) {
                return;
            }
            this.printModifiers(printWriter, fieldNode.getModifiers());
            this.printType(fieldNode.getType(), printWriter);
            printWriter.print(" ");
            printWriter.print(fieldNode.getName());
            printWriter.println(";");
        }

        private ConstructorCallExpression getConstructorCallExpression(ConstructorNode constructorNode) {
            Statement statement = constructorNode.getCode();
            if (!(statement instanceof BlockStatement)) {
                return null;
            }
            BlockStatement blockStatement = (BlockStatement)statement;
            List list = blockStatement.getStatements();
            if (list == null || list.size() == 0) {
                return null;
            }
            Statement statement2 = (Statement)list.get(0);
            if (!(statement2 instanceof ExpressionStatement)) {
                return null;
            }
            Expression expression = ((ExpressionStatement)statement2).getExpression();
            if (!(expression instanceof ConstructorCallExpression)) {
                return null;
            }
            return (ConstructorCallExpression)expression;
        }

        private void genConstructor(ClassNode classNode, ConstructorNode constructorNode, PrintWriter printWriter) {
            if (constructorNode.isSynthetic()) {
                return;
            }
            printWriter.print("public ");
            printWriter.print(classNode.getNameWithoutPackage());
            this.printParams(constructorNode, printWriter);
            ConstructorCallExpression constructorCallExpression = this.getConstructorCallExpression(constructorNode);
            if (constructorCallExpression == null || !constructorCallExpression.isSpecialCall()) {
                printWriter.println(" {}");
            } else {
                printWriter.println(" {");
                this.genSpecialConstructorArgs(printWriter, constructorNode, constructorCallExpression);
                printWriter.println("}");
            }
        }

        private Parameter[] selectAccessibleConstructorFromSuper(ConstructorNode constructorNode) {
            ClassNode classNode = constructorNode.getDeclaringClass();
            ClassNode classNode2 = classNode.getSuperClass();
            boolean bl = false;
            for (ConstructorNode constructorNode2 : classNode2.getDeclaredConstructors()) {
                if (!constructorNode2.isPublic() && !constructorNode2.isProtected()) continue;
                return constructorNode2.getParameters();
            }
            if (classNode2.isPrimaryClassNode()) {
                return Parameter.EMPTY_ARRAY;
            }
            return null;
        }

        private void genSpecialConstructorArgs(PrintWriter printWriter, ConstructorNode constructorNode, ConstructorCallExpression constructorCallExpression) {
            Parameter[] parameterArray = this.selectAccessibleConstructorFromSuper(constructorNode);
            if (parameterArray != null) {
                printWriter.print("super (");
                for (int i = 0; i < parameterArray.length; ++i) {
                    this.printDefaultValue(printWriter, parameterArray[i].getType());
                    if (i + 1 >= parameterArray.length) continue;
                    printWriter.print(", ");
                }
                printWriter.println(");");
                return;
            }
            Expression expression = constructorCallExpression.getArguments();
            if (constructorCallExpression.isSuperCall()) {
                printWriter.print("super(");
            } else {
                printWriter.print("this(");
            }
            if (expression instanceof ArgumentListExpression) {
                ArgumentListExpression argumentListExpression = (ArgumentListExpression)expression;
                List list = argumentListExpression.getExpressions();
                for (Expression expression2 : list) {
                    if (expression2 instanceof ConstantExpression) {
                        ConstantExpression constantExpression = (ConstantExpression)expression2;
                        Object object = constantExpression.getValue();
                        if (object instanceof String) {
                            printWriter.print("(String)null");
                        } else {
                            printWriter.print(constantExpression.getText());
                        }
                    } else {
                        this.printDefaultValue(printWriter, expression2.getType());
                    }
                    if (expression2 == list.get(list.size() - 1)) continue;
                    printWriter.print(", ");
                }
            }
            printWriter.println(");");
        }

        private void genMethod(ClassNode classNode, MethodNode methodNode, PrintWriter printWriter) {
            this.genMethod(classNode, methodNode, printWriter, true);
        }

        private void genMethod(ClassNode classNode, MethodNode methodNode, PrintWriter printWriter, boolean bl) {
            String string = methodNode.getName();
            if (bl && methodNode.isSynthetic() || string.startsWith("super$")) {
                return;
            }
            if (methodNode.getName().equals("<clinit>")) {
                return;
            }
            if (!classNode.isInterface()) {
                this.printModifiers(printWriter, methodNode.getModifiers());
            }
            this.printType(methodNode.getReturnType(), printWriter);
            printWriter.print(" ");
            printWriter.print(methodNode.getName());
            this.printParams(methodNode, printWriter);
            if ((methodNode.getModifiers() & 0x400) != 0) {
                printWriter.println(";");
            } else {
                printWriter.print(" { ");
                ClassNode classNode2 = methodNode.getReturnType();
                this.printReturn(printWriter, classNode2);
                printWriter.println("}");
            }
        }

        private void printReturn(PrintWriter printWriter, ClassNode classNode) {
            String string = classNode.getName();
            if (!string.equals("void")) {
                printWriter.print("return ");
                this.printDefaultValue(printWriter, classNode);
                printWriter.print(";");
            }
        }

        private void printDefaultValue(PrintWriter printWriter, ClassNode classNode) {
            if (classNode.redirect() != ClassHelper.OBJECT_TYPE) {
                printWriter.print("(");
                this.printType(classNode, printWriter);
                printWriter.print(")");
            }
            if (ClassHelper.isPrimitiveType(classNode)) {
                if (classNode == ClassHelper.boolean_TYPE) {
                    printWriter.print("false");
                } else {
                    printWriter.print("0");
                }
            } else {
                printWriter.print("null");
            }
        }

        private void printType(ClassNode classNode, PrintWriter printWriter) {
            if (classNode.isArray()) {
                this.printType(classNode.getComponentType(), printWriter);
                printWriter.print("[]");
            } else {
                this.writeGenericsBounds(printWriter, classNode, false);
            }
        }

        private void printTypeName(ClassNode classNode, PrintWriter printWriter) {
            if (ClassHelper.isPrimitiveType(classNode)) {
                if (classNode == ClassHelper.boolean_TYPE) {
                    printWriter.print("boolean");
                } else if (classNode == ClassHelper.char_TYPE) {
                    printWriter.print("char");
                } else if (classNode == ClassHelper.int_TYPE) {
                    printWriter.print("int");
                } else if (classNode == ClassHelper.short_TYPE) {
                    printWriter.print("short");
                } else if (classNode == ClassHelper.long_TYPE) {
                    printWriter.print("long");
                } else if (classNode == ClassHelper.float_TYPE) {
                    printWriter.print("float");
                } else if (classNode == ClassHelper.double_TYPE) {
                    printWriter.print("double");
                } else if (classNode == ClassHelper.byte_TYPE) {
                    printWriter.print("byte");
                } else {
                    printWriter.print("void");
                }
            } else {
                printWriter.print(classNode.redirect().getName().replace('$', '.'));
            }
        }

        private void writeGenericsBounds(PrintWriter printWriter, ClassNode classNode, boolean bl) {
            if (!bl) {
                this.printTypeName(classNode, printWriter);
            }
            if (this.java5 && !classNode.isGenericsPlaceHolder()) {
                this.writeGenericsBounds(printWriter, classNode.getGenericsTypes());
            }
        }

        private void writeGenericsBounds(PrintWriter printWriter, GenericsType[] genericsTypeArray) {
            if (genericsTypeArray == null || genericsTypeArray.length == 0) {
                return;
            }
            printWriter.print('<');
            for (int i = 0; i < genericsTypeArray.length; ++i) {
                if (i != 0) {
                    printWriter.print(", ");
                }
                this.writeGenericsBounds(printWriter, genericsTypeArray[i]);
            }
            printWriter.print('>');
        }

        private void writeGenericsBounds(PrintWriter printWriter, GenericsType genericsType) {
            if (genericsType.isPlaceholder()) {
                printWriter.print(genericsType.getName());
            } else {
                this.printTypeName(genericsType.getType(), printWriter);
                ClassNode[] classNodeArray = genericsType.getUpperBounds();
                ClassNode classNode = genericsType.getLowerBound();
                if (classNodeArray != null) {
                    printWriter.print(" extends ");
                    for (int i = 0; i < classNodeArray.length; ++i) {
                        this.printType(classNodeArray[i], printWriter);
                        if (i + 1 >= classNodeArray.length) continue;
                        printWriter.print(" & ");
                    }
                } else if (classNode != null) {
                    printWriter.print(" super ");
                    this.printType(classNode, printWriter);
                }
            }
        }

        private void printParams(MethodNode methodNode, PrintWriter printWriter) {
            printWriter.print("(");
            Parameter[] parameterArray = methodNode.getParameters();
            if (parameterArray != null && parameterArray.length != 0) {
                for (int i = 0; i != parameterArray.length; ++i) {
                    this.printType(parameterArray[i].getType(), printWriter);
                    printWriter.print(" ");
                    printWriter.print(parameterArray[i].getName());
                    if (i + 1 >= parameterArray.length) continue;
                    printWriter.print(", ");
                }
            }
            printWriter.print(")");
        }

        private void printModifiers(PrintWriter printWriter, int n) {
            if ((n & 1) != 0) {
                printWriter.print("public ");
            }
            if ((n & 4) != 0) {
                printWriter.print("protected ");
            }
            if ((n & 2) != 0) {
                printWriter.print("private ");
            }
            if ((n & 8) != 0) {
                printWriter.print("static ");
            }
            if ((n & 0x20) != 0) {
                printWriter.print("synchronized ");
            }
            if ((n & 0x400) != 0) {
                printWriter.print("abstract ");
            }
        }

        private void genImports(ClassNode classNode, PrintWriter printWriter) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList(ResolveVisitor.DEFAULT_IMPORTS));
            ModuleNode moduleNode = classNode.getModule();
            Iterator iterator = moduleNode.getImportPackages().iterator();
            while (iterator.hasNext()) {
                hashSet.add((String)iterator.next());
            }
            for (ImportNode object : moduleNode.getImports()) {
                String string = object.getType().getName();
                int n = string.lastIndexOf(46);
                if (n == -1) continue;
                hashSet.add(string.substring(0, n + 1));
            }
            for (String string : hashSet) {
                printWriter.print("import ");
                printWriter.print(string);
                printWriter.println("*;");
            }
            printWriter.println();
        }
    }
}

