/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.security.CodeSource;
import java.util.concurrent.ExecutionException;
import javax.lang.model.element.TypeElement;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.util.Exceptions;

public final class NbCompilationUnit
extends CompilationUnit {
    public NbCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource, GroovyClassLoader groovyClassLoader, JavaSource javaSource, boolean bl) {
        super(compilerConfiguration, codeSource, groovyClassLoader);
        this.ast = new NbCompileUnit(this.classLoader, codeSource, this.configuration, javaSource, bl);
    }

    private static final class NbCompileUnit
    extends CompileUnit {
        private final JavaSource javaSource;
        private final boolean waitScanFinished;

        public NbCompileUnit(GroovyClassLoader groovyClassLoader, CodeSource codeSource, CompilerConfiguration compilerConfiguration, JavaSource javaSource, boolean bl) {
            super(groovyClassLoader, codeSource, compilerConfiguration);
            this.javaSource = javaSource;
            this.waitScanFinished = bl;
        }

        public ClassNode getClass(final String string) {
            final ClassNode[] classNodeArray = new ClassNode[]{super.getClass(string)};
            if (classNodeArray[0] == null) {
                try {
                    Task<CompilationController> task = new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                            if (typeElement != null) {
                                classNodeArray[0] = new ClassNode(string, 0, null);
                            }
                        }
                    };
                    if (this.waitScanFinished) {
                        this.javaSource.runWhenScanFinished((Task)task, true).get();
                    } else {
                        this.javaSource.runUserActionTask((Task)task, true);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
            }
            return classNodeArray[0];
        }
    }
}

