/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity;

import java.util.prefs.Preferences;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DataconnectivitySettings {
    static final long serialVersionUID = 1L;
    public static final String PROP_MAKE_IN_SESSION = "1makeInSession";
    public static final String PROP_CHECK_ROWSET = "2checkRowset";
    public static final String PROP_PROMPT_FOR_NAME = "3checkRowset";
    public static final String PROP_DATAPROVIDER = "4dataprovider";
    public static final String PROP_ROWSET = "5rowset";
    private static final String DEFAULT_ROWSET_SUFFIX = "RowSet";
    private static final String DEFAULT_DATAPROVIDER_SUFFIX = "DataProvider";
    private static final DataconnectivitySettings INSTANCE = new DataconnectivitySettings();

    public static DataconnectivitySettings getInstance() {
        return INSTANCE;
    }

    public void setDataProviderSuffixProp(String string) {
        this.getPreferences().put(PROP_DATAPROVIDER, string);
    }

    public String getDataProviderSuffixProp() {
        return this.getPreferences().get(PROP_DATAPROVIDER, DEFAULT_DATAPROVIDER_SUFFIX);
    }

    public void setRowSetSuffixProp(String string) {
        this.getPreferences().put(PROP_ROWSET, string);
    }

    public String getRowSetSuffixProp() {
        return this.getPreferences().get(PROP_ROWSET, DEFAULT_ROWSET_SUFFIX);
    }

    public static String getRsSuffix() {
        return DataconnectivitySettings.getInstance().getRowSetSuffixProp();
    }

    public static String getDpSuffix() {
        return DataconnectivitySettings.getInstance().getDataProviderSuffixProp();
    }

    public String displayName() {
        return NbBundle.getBundle(DataconnectivitySettings.class).getString("CTL_DataconnectivitySettings");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean getMakeInSession() {
        return this.getPreferences().getBoolean(PROP_MAKE_IN_SESSION, true);
    }

    public void setMakeInSession(boolean bl) {
        this.getPreferences().putBoolean(PROP_MAKE_IN_SESSION, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getCheckRowSetProp() {
        return this.getPreferences().getBoolean(PROP_CHECK_ROWSET, true);
    }

    public void setCheckRowSetProp(boolean bl) {
        this.getPreferences().putBoolean(PROP_CHECK_ROWSET, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getPromptForName() {
        return this.getPreferences().getBoolean(PROP_PROMPT_FOR_NAME, false);
    }

    public void setPromptForName(boolean bl) {
        this.getPreferences().putBoolean(PROP_PROMPT_FOR_NAME, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean canDropAnywhere() {
        return !DataconnectivitySettings.getInstance().getMakeInSession();
    }

    public static boolean checkRowsets() {
        return DataconnectivitySettings.getInstance().getCheckRowSetProp();
    }

    public static boolean promptForName() {
        return DataconnectivitySettings.getInstance().getPromptForName();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(DataconnectivitySettings.class);
    }
}

