/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.customizers;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.sql.rowset.CachedRowSetX;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.visualweb.dataconnectivity.DataconnectivitySettings;
import org.netbeans.modules.visualweb.dataconnectivity.Log;
import org.netbeans.modules.visualweb.dataconnectivity.customizers.RowSetSelectionQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RowSetSelection
extends JPanel {
    private final String tableName;
    private final String bareTableName;
    private final String user;
    private final String url;
    private final String command;
    private final DesignContext curContext;
    private String dataSourceName;
    private String fullDataSourceName;
    private static final String selectText = NbBundle.getMessage(RowSetSelection.class, (String)"RowSelectButton_label");
    private static final String createText = NbBundle.getMessage(RowSetSelection.class, (String)"RowCreateButton_label");
    public DesignBean selectedDesignBean = null;
    public DesignContext createContext = null;
    private static String javacomp = "java:comp/env/jdbc/";
    ArrayList mCommands = new ArrayList();
    ArrayList mTables = new ArrayList();
    ArrayList cBeans_thisPage = new ArrayList();
    ArrayList cBeans_request = new ArrayList();
    ArrayList cBeans_session = new ArrayList();
    ArrayList cBeans_application = new ArrayList();
    ArrayList<DesignBean> alRowSets = new ArrayList();
    Color roBgColor = null;
    private BeanColumnPanel selectedPanel = null;
    private JLabel bottomLabel;
    private JSeparator jSeparator1;
    private JScrollPane rowsetPane;
    private JPanel selectionPanel;
    private ButtonGroup selections;
    private JTextArea titleLabel;
    private static final String SCOPE_PAGE = "page";
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_APPLICATION = "application";
    private JDialog dialog;
    private static JButton okButton = new JButton(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetDialogAcceptButton"));
    private static JButton cancelButton = new JButton(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetDialogCancelButton"));
    private boolean makeStuff = false;
    ArrayList panelTabOrderList = new ArrayList(12);

    public RowSetSelection(DesignContext designContext, String string, String string2, String string3, String string4, String string5) {
        this.curContext = designContext;
        this.tableName = string;
        int n = string.lastIndexOf(46);
        this.bareTableName = n >= 0 ? string.substring(n + 1) : string;
        if (string2 != null && string2.startsWith(javacomp)) {
            string2 = string2.substring(javacomp.length());
        }
        this.dataSourceName = string2;
        this.fullDataSourceName = "java:comp/env/jdbc/" + this.dataSourceName;
        this.user = string3;
        this.url = string4;
        this.command = string5;
        this.findRowSets();
    }

    private DesignContext[] getDesignContexts(DesignContext designContext) {
        DesignProject designProject = designContext.getProject();
        DesignContext[] designContextArray = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{SCOPE_REQUEST, SCOPE_SESSION, SCOPE_APPLICATION}) : new DesignContext[]{};
        DesignContext[] designContextArray2 = new DesignContext[designContextArray.length + 1];
        designContextArray2[0] = designContext;
        System.arraycopy(designContextArray, 0, designContextArray2, 1, designContextArray.length);
        return designContextArray2;
    }

    private void findRowSets() {
        String string = (String)this.curContext.getContextData("scope");
        DesignContext[] designContextArray = this.getDesignContexts(this.curContext);
        for (int i = 0; i < designContextArray.length; ++i) {
            String string2 = (String)designContextArray[i].getContextData("scope");
            Log.log("RSS:  examining " + designContextArray[i].getDisplayName() + " , " + string2);
            if (RowSetSelection.compareScopes(string, string2) < 0 || SCOPE_PAGE.equals(string) && designContextArray[i] != this.curContext) continue;
            if (SCOPE_REQUEST.equals(string) && SCOPE_REQUEST.equals(string2)) {
                if (designContextArray[i] != this.curContext && designContextArray[i].getDisplayName().indexOf("RequestBean") < 0) continue;
                if (designContextArray[i] == this.curContext && designContextArray[i].getDisplayName().indexOf("RequestBean") < 0) {
                    this.cBeans_thisPage.add(this.curContext);
                }
            }
            DesignBean[] designBeanArray = designContextArray[i].getBeansOfType(CachedRowSetX.class);
            for (int j = 0; j < designBeanArray.length; ++j) {
                if (this.alRowSets.contains(designBeanArray[j])) continue;
                this.alRowSets.add(designBeanArray[j]);
                int n = this.compareRowSet(designBeanArray[j]);
                if (Log.isLoggable()) {
                    Log.log("RSS: " + designContextArray[i].getDisplayName() + "." + designBeanArray[j].getInstanceName() + " match=" + n);
                }
                if (n == 1) {
                    this.mTables.add(designBeanArray[j]);
                    continue;
                }
                if (n != 2) continue;
                this.mCommands.add(designBeanArray[j]);
            }
            if (designContextArray[i].getDisplayName().indexOf("RequestBean") >= 0) {
                if (this.cBeans_request.contains(designContextArray[i])) continue;
                this.cBeans_request.add(designContextArray[i]);
                continue;
            }
            if (designContextArray[i].getDisplayName().indexOf("SessionBean") >= 0) {
                if (this.cBeans_session.contains(designContextArray[i])) continue;
                this.cBeans_session.add(designContextArray[i]);
                continue;
            }
            if (designContextArray[i].getDisplayName().indexOf("ApplicationBean") < 0 || this.cBeans_application.contains(designContextArray[i])) continue;
            this.cBeans_application.add(designContextArray[i]);
        }
    }

    public boolean hasMatchingRowSets() {
        boolean bl = this.mCommands.size() == 0 && this.mTables.size() == 0;
        return !bl;
    }

    public Object[] getCreateBeans(String string) {
        if (string == null) {
            string = SCOPE_SESSION;
        }
        if (string.equals(SCOPE_REQUEST)) {
            return this.cBeans_request.toArray();
        }
        if (string.equals(SCOPE_SESSION)) {
            return this.cBeans_session.toArray();
        }
        if (string.equals(SCOPE_APPLICATION)) {
            return this.cBeans_application.toArray();
        }
        throw new IllegalArgumentException("RSS arg eror:  scope is '" + string + "'");
    }

    private void buildSelectionPanel() {
        TextField textField = new TextField();
        textField.setEditable(false);
        this.roBgColor = textField.getBackground();
        this.initComponents();
        this.titleLabel.setBackground(this.roBgColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(-1, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        AbstractButton abstractButton = null;
        BeanColumnPanel beanColumnPanel = null;
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < 7; ++i) {
            ArrayList arrayList = null;
            boolean bl = false;
            boolean bl2 = false;
            switch (i) {
                case 0: {
                    arrayList = this.mCommands;
                    bl = true;
                    break;
                }
                case 1: {
                    arrayList = this.mTables;
                    bl = true;
                    break;
                }
                case 2: {
                    bl2 = true;
                    break;
                }
                case 3: {
                    arrayList = this.cBeans_thisPage;
                    bl = false;
                    break;
                }
                case 4: {
                    arrayList = this.cBeans_request;
                    bl = false;
                    break;
                }
                case 5: {
                    arrayList = this.cBeans_session;
                    bl = false;
                    break;
                }
                case 6: {
                    arrayList = this.cBeans_application;
                    bl = false;
                }
            }
            if (bl2) {
                gridBagConstraints2.gridy = ++n;
                this.selectionPanel.add((Component)new JSeparator(), gridBagConstraints2);
                continue;
            }
            if (arrayList == null) continue;
            int n3 = arrayList.size();
            for (int j = 0; j < n3; ++j) {
                gridBagConstraints.gridy = ++n;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                AbstractButton abstractButton2 = null;
                abstractButton2 = bl ? this.makeButtonColumn(selectText) : this.makeButtonColumn(createText);
                BeanColumnPanel beanColumnPanel2 = null;
                JComponent jComponent = null;
                if (bl) {
                    DesignBean designBean = (DesignBean)arrayList.get(j);
                    beanColumnPanel2 = this.makeBeanColumn(designBean.getDesignContext(), designBean, abstractButton2);
                    try {
                        if (!(designBean.getInstance() instanceof CachedRowSetX)) {
                            throw new RuntimeException("Internal error:  not a CachedRowSetX.");
                        }
                        CachedRowSetX cachedRowSetX = (CachedRowSetX)designBean.getInstance();
                        jComponent = this.makeCommandColumn(cachedRowSetX.getCommand());
                    }
                    catch (Exception exception) {
                        jComponent = this.makeCommandColumn(exception.getLocalizedMessage());
                        abstractButton2.setEnabled(false);
                    }
                } else {
                    beanColumnPanel2 = this.makeBeanColumn((DesignContext)arrayList.get(j), null, abstractButton2);
                    jComponent = this.makeCommandColumn(this.command);
                }
                if (abstractButton2.isEnabled() && abstractButton == null) {
                    abstractButton = abstractButton2;
                    beanColumnPanel = beanColumnPanel2;
                }
                this.selectionPanel.add((Component)abstractButton2, gridBagConstraints);
                this.selectionPanel.add((Component)beanColumnPanel2, gridBagConstraints);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 1;
                this.selectionPanel.add((Component)jComponent, gridBagConstraints);
                ++n2;
                abstractButton2.addActionListener(new SelectionListener(beanColumnPanel2));
            }
        }
        if (n2 < 1) {
            this.selectionPanel.add(new JLabel("No beans with rowsets."));
        } else {
            abstractButton.setSelected(true);
            this.setSelectedBean(beanColumnPanel);
        }
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.selectionPanel.add((Component)new JPanel(), gridBagConstraints);
    }

    private void setSelectedBean(BeanColumnPanel beanColumnPanel) {
        this.selectedPanel = beanColumnPanel;
    }

    public DesignContext getSelectedDesignContext() {
        return this.selectedPanel.context;
    }

    public DesignBean getSelectedRowSetBean() {
        return this.selectedPanel.rowSetBean;
    }

    public String getSelectedRowSetName() {
        return this.selectedPanel.rowsetName.getText();
    }

    private void initComponents() {
        this.selections = new ButtonGroup();
        this.titleLabel = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.rowsetPane = new JScrollPane();
        this.selectionPanel = new JPanel();
        this.bottomLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetDialogTitle"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetDialogTitle"));
        this.titleLabel.setEditable(false);
        this.titleLabel.setLineWrap(true);
        this.titleLabel.setText(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetTitle1_label", (Object[])new Object[]{this.bareTableName}));
        this.titleLabel.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.selectionPanel.setLayout(new GridBagLayout());
        this.rowsetPane.setViewportView(this.selectionPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.rowsetPane, gridBagConstraints);
        this.bottomLabel.setText(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetFooter1_label", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.bottomLabel, gridBagConstraints);
        this.bottomLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RowSetSelection.class, (String)"RowSetFooter1_label"));
    }

    public AbstractButton makeButtonColumn(String string) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setBorder(new EmptyBorder(5, 5, 0, 0));
        jRadioButton.getAccessibleContext().setAccessibleDescription(jRadioButton.getText());
        this.selections.add(jRadioButton);
        this.addToTabOrder(jRadioButton);
        return jRadioButton;
    }

    public BeanColumnPanel makeBeanColumn(DesignContext designContext, DesignBean designBean, AbstractButton abstractButton) {
        BeanColumnPanel beanColumnPanel = new BeanColumnPanel(designContext, designBean);
        JLabel jLabel = new JLabel(designContext.getDisplayName());
        jLabel.getAccessibleContext().setAccessibleDescription(jLabel.getText());
        jLabel.getAccessibleContext().setAccessibleName(jLabel.getText());
        beanColumnPanel.add(jLabel);
        JComponent jComponent = null;
        if (designBean != null) {
            jComponent = new JLabel(designBean.getInstanceName());
            ((Component)jComponent).getAccessibleContext().setAccessibleDescription(designBean.getInstanceName());
            ((Component)jComponent).getAccessibleContext().setAccessibleName(designBean.getInstanceName());
        } else {
            String string = this.getRowSetNameForContext(designContext, null);
            JTextField jTextField = new JTextField(string);
            jTextField.setColumns(15);
            jTextField.getDocument().addDocumentListener(new DocListener(abstractButton, beanColumnPanel));
            jLabel.setLabelFor(jComponent);
            this.addToTabOrder(jTextField);
            jTextField.setName(designContext.getDisplayName());
            jTextField.getAccessibleContext().setAccessibleDescription(designContext.getDisplayName());
            jComponent = jTextField;
            beanColumnPanel.rowsetName = jTextField;
        }
        beanColumnPanel.add(jComponent);
        return beanColumnPanel;
    }

    private String getRowSetNameForContext(DesignContext designContext, String string) {
        DesignBean[] designBeanArray = null;
        if (designContext != null) {
            designBeanArray = designContext.getBeansOfType(CachedRowSetX.class);
        }
        if (string == null) {
            string = this.bareTableName.toLowerCase().replaceAll(" ", "") + DataconnectivitySettings.getRsSuffix();
        }
        String string2 = string;
        if (designBeanArray != null) {
            for (int i = 0; i < 333; ++i) {
                if (i > 0) {
                    string2 = string + Integer.toString(i);
                }
                boolean bl = false;
                for (int j = 0; j < designBeanArray.length; ++j) {
                    if (!string2.equals(designBeanArray[j].getInstanceName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
        }
        return string2;
    }

    public JComponent makeDataSourceColumn(String string, String string2, String string3, String string4) {
        GridLayout gridLayout = new GridLayout(0, 1);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.add(new JLabel(string));
        jPanel.add(new JLabel(string2));
        jPanel.add(new JLabel(string3));
        return jPanel;
    }

    public JComponent makeCommandColumn(String string) {
        return new RowSetSelectionQuery(string);
    }

    private static String getNextScope(String string) {
        if (string.equals(SCOPE_PAGE)) {
            return SCOPE_REQUEST;
        }
        if (string.equals(SCOPE_REQUEST)) {
            return SCOPE_SESSION;
        }
        if (string.equals(SCOPE_SESSION)) {
            return SCOPE_APPLICATION;
        }
        return null;
    }

    private static int compareScopes(String string, String string2) {
        if (string.equals(SCOPE_PAGE)) {
            if (string2.equals(SCOPE_PAGE)) {
                return 0;
            }
            if (string2.equals(SCOPE_REQUEST)) {
                return 1;
            }
            if (string2.equals(SCOPE_SESSION)) {
                return 2;
            }
            if (string2.equals(SCOPE_APPLICATION)) {
                return 3;
            }
            return -99;
        }
        if (string.equals(SCOPE_REQUEST)) {
            if (string2.equals(SCOPE_PAGE)) {
                return -1;
            }
            if (string2.equals(SCOPE_REQUEST)) {
                return 0;
            }
            if (string2.equals(SCOPE_SESSION)) {
                return 1;
            }
            if (string2.equals(SCOPE_APPLICATION)) {
                return 2;
            }
            return -99;
        }
        if (string.equals(SCOPE_SESSION)) {
            if (string2.equals(SCOPE_PAGE)) {
                return -2;
            }
            if (string2.equals(SCOPE_REQUEST)) {
                return -1;
            }
            if (string2.equals(SCOPE_SESSION)) {
                return 0;
            }
            if (string2.equals(SCOPE_APPLICATION)) {
                return 1;
            }
            return -99;
        }
        if (string.equals(SCOPE_APPLICATION)) {
            if (string2.equals(SCOPE_PAGE)) {
                return -3;
            }
            if (string2.equals(SCOPE_REQUEST)) {
                return -2;
            }
            if (string2.equals(SCOPE_SESSION)) {
                return -1;
            }
            if (string2.equals(SCOPE_APPLICATION)) {
                return 0;
            }
            return -99;
        }
        if (string2.equals(SCOPE_PAGE)) {
            return 0;
        }
        if (string2.equals(SCOPE_REQUEST)) {
            return 1;
        }
        if (string2.equals(SCOPE_SESSION)) {
            return 2;
        }
        if (string2.equals(SCOPE_APPLICATION)) {
            return 3;
        }
        return -99;
    }

    private int compareRowSet(DesignBean designBean) {
        if (!DataconnectivitySettings.checkRowsets()) {
            return -3;
        }
        DesignProperty designProperty = designBean.getProperty("dataSourceName");
        if (designProperty == null || this.fullDataSourceName == null) {
            return -2;
        }
        if (!this.fullDataSourceName.equals(designProperty.getValue())) {
            return -2;
        }
        designProperty = designBean.getProperty("command");
        if (designProperty != null && this.command != null) {
            if (this.command.equals(designProperty.getValue())) {
                return 2;
            }
            if (designProperty.getValue() == null) {
                return -2;
            }
            if ("".equals((String)designProperty.getValue())) {
                return -2;
            }
        }
        if ((designProperty = designBean.getProperty("tableName")) != null && this.tableName != null && this.tableName.equals(designProperty.getValue())) {
            return 1;
        }
        if (designProperty != null && this.bareTableName != null && this.bareTableName.equals(designProperty.getValue())) {
            return 1;
        }
        return 0;
    }

    public boolean showDialog() {
        Component component;
        this.buildSelectionPanel();
        okButton.getAccessibleContext().setAccessibleDescription(okButton.getText());
        cancelButton.getAccessibleContext().setAccessibleDescription(cancelButton.getText());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == okButton) {
                    RowSetSelection.this.makeStuff = true;
                } else {
                    RowSetSelection.this.makeStuff = false;
                }
                RowSetSelection.this.dialog.dispose();
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(RowSetSelection.class, (String)"RowSetDialogTitle", (Object)this.bareTableName), true, actionListener);
        dialogDescriptor.setOptions(new Object[]{okButton, cancelButton});
        dialogDescriptor.setHelpCtx(new HelpCtx("projrave_ui_elements_server_nav_add_new_data_provider"));
        dialogDescriptor.setClosingOptions(null);
        this.dialog = (JDialog)DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setResizable(true);
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        if (dimension.getHeight() > 575.0) {
            dimension.setSize(dimension.getWidth(), 575.0);
            this.dialog.setSize(dimension);
        }
        Tabbing tabbing = new Tabbing();
        Component[] componentArray = this.dialog.getContentPane().getComponents();
        if (componentArray.length > 0 && (component = componentArray[1]) instanceof Container) {
            Component[] componentArray2 = ((Container)component).getComponents();
            for (int i = 0; i < componentArray2.length; ++i) {
                if (!(componentArray2[i] instanceof JButton)) continue;
                tabbing.addToTab(componentArray2[i]);
            }
        }
        tabbing.addToTab(this.rowsetPane);
        this.dialog.setFocusTraversalPolicy(tabbing);
        this.dialog.setVisible(true);
        return this.makeStuff;
    }

    protected void addToTabOrder(Component component) {
        this.panelTabOrderList.add(component);
    }

    public class Tabbing
    extends FocusTraversalPolicy {
        ArrayList tabOrderList = new ArrayList(15);

        public Tabbing() {
            this.tabOrderList = (ArrayList)RowSetSelection.this.panelTabOrderList.clone();
        }

        public void addToTab(Component component) {
            this.tabOrderList.add(component);
        }

        public Component getComponentBefore(Container container, Component component) {
            for (int i = 0; i < this.tabOrderList.size(); ++i) {
                if (component != this.tabOrderList.get(i)) continue;
                i = i == 0 ? this.tabOrderList.size() - 1 : --i;
                return (Component)this.tabOrderList.get(i);
            }
            return (Component)this.tabOrderList.get(0);
        }

        public Component getComponentAfter(Container container, Component component) {
            for (int i = 0; i < this.tabOrderList.size(); ++i) {
                if (component != this.tabOrderList.get(i)) continue;
                i = i == this.tabOrderList.size() - 1 ? 0 : ++i;
                return (Component)this.tabOrderList.get(i);
            }
            return (Component)this.tabOrderList.get(this.tabOrderList.size() - 1);
        }

        public Component getLastComponent(Container container) {
            return (Component)this.tabOrderList.get(this.tabOrderList.size() - 1);
        }

        public Component getFirstComponent(Container container) {
            return (Component)this.tabOrderList.get(0);
        }

        public Component getDefaultComponent(Container container) {
            return (Component)this.tabOrderList.get(0);
        }
    }

    public class DocListener
    implements DocumentListener {
        AbstractButton button = null;
        BeanColumnPanel beanPanel = null;

        public DocListener(AbstractButton abstractButton, BeanColumnPanel beanColumnPanel) {
            this.button = abstractButton;
            this.beanPanel = beanColumnPanel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        private void update(DocumentEvent documentEvent) {
            RowSetSelection.this.selections.setSelected(this.button.getModel(), true);
            RowSetSelection.this.setSelectedBean(this.beanPanel);
        }
    }

    public class BeanColumnPanel
    extends JPanel {
        public DesignContext context;
        public DesignBean rowSetBean;
        public JTextField rowsetName;

        public BeanColumnPanel(DesignContext designContext, DesignBean designBean) {
            super(new GridLayout(0, 1));
            this.context = null;
            this.rowSetBean = null;
            this.rowsetName = null;
            this.context = designContext;
            this.rowSetBean = designBean;
            String string = "Bean to Use or Create";
            this.getAccessibleContext().setAccessibleName(string);
            this.getAccessibleContext().setAccessibleDescription(string);
        }
    }

    public class SelectionListener
    implements ActionListener {
        BeanColumnPanel beanpanel;

        public SelectionListener(BeanColumnPanel beanColumnPanel) {
            this.beanpanel = beanColumnPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((AbstractButton)actionEvent.getSource()).isEnabled()) {
                RowSetSelection.this.setSelectedBean(this.beanpanel);
            }
        }
    }
}

