/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.naming;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarFile;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedResource;
import org.netbeans.modules.visualweb.dataconnectivity.datasource.DataSourceResolver;
import org.netbeans.modules.visualweb.dataconnectivity.model.DataSourceInfo;
import org.netbeans.modules.visualweb.dataconnectivity.utils.DriverListUtil;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSettingsImporter {
    private static DatabaseSettingsImporter databaseSettingsImporter;
    public static final String ROOT_CTX_TAG = "rootContext";
    public static final String CTX_TAG = "context";
    public static final String OBJ_TAG = "object";
    public static final String ARG_TAG = "arg";
    public static final String NAME_ATTR = "name";
    public static final String CLASS_ATTR = "class";
    public static final String VALUE_ATTR = "value";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    private File userCtxFile;
    private List<String[]> dataSources;
    List<DataSourceInfo> dataSourcesInfo;
    private List<File> driversList = new ArrayList<File>();
    private static ResourceBundle rb;
    private static String[] destPaths;
    private static final String HACK_WELCOME_FILE = "JSCreator_index.jsp";
    private static SecretKey secretKey;
    private static final char[] secretKeyHex;
    private static final String hexString = "0123456789ABCDEF";

    private DatabaseSettingsImporter() {
        this.dataSources = Collections.synchronizedList(new ArrayList());
        this.dataSourcesInfo = new ArrayList<DataSourceInfo>();
    }

    public static DatabaseSettingsImporter getInstance() {
        if (databaseSettingsImporter == null) {
            databaseSettingsImporter = new DatabaseSettingsImporter();
        }
        return databaseSettingsImporter;
    }

    public boolean locateAndRegisterDrivers() {
        String string = this.locateDrivers();
        if (string.equals("")) {
            return false;
        }
        this.registerDrivers(this.driversToRegister(string));
        return true;
    }

    private String locateDrivers() {
        String string = System.getProperty("netbeans.user") + File.separator + "jdbc-drivers";
        File file = new File(string);
        if (file == null) {
            return "";
        }
        if (file.exists()) {
            return string;
        }
        return "";
    }

    private File[] driversToRegister(String string) {
        File file = new File(string);
        if (file != null) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar") || string.endsWith(".zip");
                }
            });
            return fileArray;
        }
        return null;
    }

    private synchronized JarFile prepareJar(File file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return jarFile;
    }

    private void registerDriver(File file) {
        String[] stringArray = DriverListUtil.getDrivers().toArray(new String[DriverListUtil.getDrivers().size()]);
        try {
            JarFile jarFile = this.prepareJar(file);
            if (jarFile != null) {
                Set set = DriverListUtil.getDrivers();
                for (String string : set) {
                    if (jarFile.getEntry(string.replace('.', '/') + ".class") == null) continue;
                    String string2 = DriverListUtil.getName(string);
                    if (DataSourceResolver.getInstance().findMatchingDriver(DriverListUtil.getDriver(string2)) != null) break;
                    JDBCDriver jDBCDriver = JDBCDriver.create((String)string2, (String)string2, (String)string, (URL[])new URL[]{file.toURI().toURL()});
                    try {
                        JDBCDriverManager.getDefault().addDriver(jDBCDriver);
                    }
                    catch (DatabaseException databaseException) {
                        ErrorManager.getDefault().notify((Throwable)databaseException);
                    }
                }
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void registerDrivers(File[] fileArray) {
        for (File file : fileArray) {
            if (this.driversList.contains(file)) continue;
            this.registerDriver(file);
            this.driversList.add(file);
        }
    }

    public boolean locateAndRegisterConnections(boolean bl) {
        HashSet<File> hashSet = new HashSet<File>();
        if (bl) {
            destPaths = new String[]{"2_0" + File.separator + "context.xml", "2_1" + File.separator + "context.xml", "5_5" + File.separator + "context.xml", "5_5_1" + File.separator + "context.xml"};
            File file = this.retrieveMigratedSettingsAtStartup();
            if (file != null) {
                this.registerConnections(file);
            }
        } else {
            for (int i = 0; i < destPaths.length; ++i) {
                File file = new File(System.getProperty("netbeans.user") + File.separator + "config" + File.separator + destPaths[i]);
                if (!file.exists()) continue;
                hashSet.add(file);
            }
            this.registerConnections(hashSet);
        }
        return true;
    }

    public File retrieveMigratedSettingsAtStartup() {
        File file = new File(System.getProperty("netbeans.user") + File.separator + "config" + File.separator);
        File[] fileArray = null;
        fileArray = file.listFiles();
        File file2 = null;
        block0: for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2 = fileArray[i].listFiles();
            if (fileArray2 == null) {
                return null;
            }
            for (File file3 : fileArray2) {
                String string = file3.getName();
                if (!string.equals("context.xml")) continue;
                file2 = fileArray2[i];
                continue block0;
            }
        }
        return file2;
    }

    public Set<File> locateMigratedSettings() {
        File file = new File(System.getProperty("netbeans.user"));
        File[] fileArray = null;
        HashSet<File> hashSet = new HashSet<File>();
        File file2 = new File(file.getAbsolutePath() + File.separator + "migrated");
        if (file2 == null || !file2.exists() || !file2.isDirectory()) {
            return null;
        }
        for (File file3 : fileArray = file2.listFiles()) {
            hashSet.add(file3);
        }
        return hashSet;
    }

    private void registerConnections(File file) {
        this.dataSourcesInfo = this.createDataSourceInfoFromCtx(file);
        if (this.dataSourcesInfo != null) {
            try {
                Iterator<DataSourceInfo> iterator = this.dataSourcesInfo.iterator();
                DataSourceInfo dataSourceInfo = null;
                DatabaseConnection databaseConnection = null;
                JDBCDriver jDBCDriver = null;
                JDBCDriver[] jDBCDriverArray = null;
                while (iterator.hasNext()) {
                    dataSourceInfo = iterator.next();
                    String string = dataSourceInfo.getUsername();
                    String string2 = dataSourceInfo.getPassword();
                    if (dataSourceInfo.getDriverClassName().equals(DRIVER_CLASS_NET)) {
                        if (dataSourceInfo.getName().equals("Travel") || dataSourceInfo.getName().equals("VIR") || dataSourceInfo.getName().equals("JumpStartCycles")) continue;
                        jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET);
                        databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriverArray[0], (String)dataSourceInfo.getUrl(), (String)string, (String)string.toUpperCase(), (String)string2, (boolean)true);
                        ConnectionManager.getDefault().addConnection(databaseConnection);
                        continue;
                    }
                    jDBCDriver = DataSourceResolver.getInstance().findMatchingDriver(dataSourceInfo.getDriverClassName());
                    if (jDBCDriver == null) continue;
                    databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriver, (String)dataSourceInfo.getUrl(), (String)string, (String)string.toUpperCase(), (String)string2, (boolean)true);
                    ConnectionManager.getDefault().addConnection(databaseConnection);
                }
            }
            catch (DatabaseException databaseException) {
                ErrorManager.getDefault().notify(1, (Throwable)databaseException);
            }
        }
    }

    private void registerConnections(Set<File> set) {
        if (set == null) {
            return;
        }
        Iterator<File> iterator = set.iterator();
        while (iterator.hasNext()) {
            this.dataSourcesInfo = this.createDataSourceInfoFromCtx(iterator.next());
            try {
                Iterator<DataSourceInfo> iterator2 = this.dataSourcesInfo.iterator();
                DataSourceInfo dataSourceInfo = null;
                boolean bl = false;
                DatabaseConnection databaseConnection = null;
                JDBCDriver jDBCDriver = null;
                JDBCDriver[] jDBCDriverArray = null;
                while (iterator2.hasNext()) {
                    dataSourceInfo = iterator2.next();
                    String string = dataSourceInfo.getUsername();
                    String string2 = dataSourceInfo.getPassword();
                    bl = dataSourceInfo.getDriverClassName().equals(DRIVER_CLASS_NET);
                    if (dataSourceInfo.getDriverClassName().equals(DRIVER_CLASS_NET)) {
                        if (dataSourceInfo.getName().equals("Travel") || dataSourceInfo.getName().equals("VIR") || dataSourceInfo.getName().equals("JumpStartCycles")) continue;
                        jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET);
                        databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriverArray[0], (String)dataSourceInfo.getUrl(), (String)string, (String)string.toUpperCase(), (String)string2, (boolean)true);
                        ConnectionManager.getDefault().addConnection(databaseConnection);
                        continue;
                    }
                    jDBCDriver = DataSourceResolver.getInstance().findMatchingDriver(dataSourceInfo.getDriverClassName());
                    if (jDBCDriver != null) {
                        databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriver, (String)dataSourceInfo.getUrl(), (String)string, (String)string.toUpperCase(), (String)string2, (boolean)true);
                        ConnectionManager.getDefault().addConnection(databaseConnection);
                        continue;
                    }
                    if (!dataSourceInfo.getDriverClassName().equals("oracle.jdbc.driver.OracleDriver")) continue;
                    jDBCDriver = DataSourceResolver.getInstance().findMatchingDriver("oracle.jdbc.OracleDriver");
                    databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriver, (String)dataSourceInfo.getUrl(), (String)string, (String)string.toUpperCase(), (String)string2, (boolean)true);
                    ConnectionManager.getDefault().addConnection(databaseConnection);
                }
            }
            catch (DatabaseException databaseException) {
                ErrorManager.getDefault().notify(1, (Throwable)databaseException);
            }
        }
    }

    private static SecretKey getSecretKey() {
        if (secretKey == null) {
            byte[] byArray = new byte[secretKeyHex.length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = DatabaseSettingsImporter.hexToByte(secretKeyHex[i * 2], secretKeyHex[i * 2 + 1]);
            }
            secretKey = new SecretKeySpec(byArray, "DES");
        }
        return secretKey;
    }

    private static byte hexToByte(char c, char c2) {
        return (byte)((hexString.indexOf(c) << 4) + hexString.indexOf(c2));
    }

    private String decryptPassword(String string) {
        if (string == null) {
            return null;
        }
        try {
            char[] cArray = string.toCharArray();
            byte[] byArray = new byte[cArray.length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = DatabaseSettingsImporter.hexToByte(cArray[i * 2], cArray[i * 2 + 1]);
            }
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, DatabaseSettingsImporter.getSecretKey());
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return "";
        }
    }

    private DataSourceInfo createDataSourceInfo(String[] stringArray) {
        int n;
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        string5 = this.decryptPassword(string5);
        if (string2.equals(DRIVER_CLASS_NET) && (n = string3.indexOf(":21527")) != -1) {
            String string6 = string3.substring(0, n);
            String string7 = string3.substring(string3.lastIndexOf(":21527") + 6, string3.length());
            string3 = string6 + ":1527" + string7;
        }
        return new DataSourceInfo(string, string2, string3, "", string4, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DataSourceInfo> createDataSourceInfoFromCtx(File file) {
        ArrayList<DataSourceInfo> arrayList = new ArrayList<DataSourceInfo>();
        try {
            this.userCtxFile = file;
            this.parseContextFile();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        String[] stringArray2 = new String[5];
        List<String[]> list = this.dataSources;
        synchronized (list) {
            for (String[] stringArray2 : this.dataSources) {
                arrayList.add(this.createDataSourceInfo(stringArray2));
            }
        }
        return arrayList;
    }

    private void storeArgs(ArrayList arrayList) {
        String[] stringArray = new String[5];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 6) {
                iterator.next();
            } else {
                stringArray[n++] = (String)iterator.next();
            }
            ++n2;
        }
        this.dataSources.add(stringArray);
    }

    private synchronized void parseContextFile() throws ParserConfigurationException, SAXException, IllegalArgumentException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ArrayList arrayList = new ArrayList();
        sAXParser.parse(this.userCtxFile, new DefaultHandler(){
            private String objectName;
            private String className;
            private int tagCount = 0;
            ArrayList<String> args = new ArrayList();

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if (string3.equals(DatabaseSettingsImporter.OBJ_TAG)) {
                    this.objectName = attributes.getValue(DatabaseSettingsImporter.NAME_ATTR);
                    if (this.objectName != null) {
                        if (!this.args.isEmpty()) {
                            DatabaseSettingsImporter.this.storeArgs(this.args);
                        }
                        this.args.clear();
                        this.args.add(this.objectName);
                    }
                } else if (string3.equals(DatabaseSettingsImporter.ARG_TAG)) {
                    String string4 = attributes.getValue(DatabaseSettingsImporter.VALUE_ATTR);
                    this.args.add(string4);
                }
            }

            public void endDocument() {
                if (!this.args.isEmpty()) {
                    DatabaseSettingsImporter.this.storeArgs(this.args);
                }
            }
        });
    }

    public List<DataSourceInfo> getDataSourcesInfo() {
        return this.dataSourcesInfo;
    }

    private WebApp getWebApp(FileObject fileObject) {
        WebApp webApp = null;
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                if (saveCookie != null) {
                    try {
                        saveCookie.save();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            }
            try {
                webApp = DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return webApp;
    }

    public void updateWebXml(Project project, List<RequestedResource> list) {
        UpdateDataSourceReference updateDataSourceReference = new UpdateDataSourceReference(project, list);
        FileObject fileObject = WebModule.getWebModule((FileObject)project.getProjectDirectory()).getWebInf();
        if (fileObject != null) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                fileSystem.runAtomicAction((FileSystem.AtomicAction)updateDataSourceReference);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    static {
        rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.naming.Bundle", Locale.getDefault());
        destPaths = new String[]{"migrated" + File.separator + "context.xml", "migrated" + File.separator + "2_0" + File.separator + "context.xml", "migrated" + File.separator + "2_1" + File.separator + "context.xml", "migrated" + File.separator + "5_5" + File.separator + "context.xml", "migrated" + File.separator + "5_5_1" + File.separator + "context.xml"};
        secretKey = null;
        secretKeyHex = new char[]{'D', '6', '0', '7', '5', 'E', '2', '9', '8', 'A', '4', '9', '6', '2', '5', '1'};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateDataSourceReference
    implements FileSystem.AtomicAction {
        List<RequestedResource> requestedResource = null;
        Project proj = null;

        public UpdateDataSourceReference(Project project, List<RequestedResource> list) {
            this.requestedResource = list;
            this.proj = project;
        }

        public void run() throws IOException {
            RequestedJdbcResource requestedJdbcResource;
            WebModule webModule = WebModule.getWebModule((FileObject)this.proj.getProjectDirectory());
            FileObject fileObject = webModule.getDeploymentDescriptor();
            WebApp webApp = DatabaseSettingsImporter.this.getWebApp(fileObject);
            boolean bl = false;
            ResourceRef[] resourceRefArray = webApp.getResourceRef();
            LinkedList<RequestedResource> linkedList = new LinkedList<RequestedResource>();
            Iterator<RequestedResource> iterator = this.requestedResource.iterator();
            while (iterator.hasNext()) {
                linkedList.add(iterator.next());
            }
            if (resourceRefArray == null) {
                resourceRefArray = new ResourceRef[]{};
            }
            block6: for (int i = 0; i < resourceRefArray.length; ++i) {
                boolean bl2 = false;
                requestedJdbcResource = linkedList.iterator();
                while (requestedJdbcResource.hasNext()) {
                    RequestedResource requestedResource = (RequestedResource)requestedJdbcResource.next();
                    if (!resourceRefArray[i].getResRefName().equals(requestedResource.getResourceName())) continue;
                    bl2 = true;
                    requestedJdbcResource.remove();
                    continue block6;
                }
            }
            for (RequestedResource requestedResource : linkedList) {
                if (!(requestedResource instanceof RequestedJdbcResource)) continue;
                requestedJdbcResource = (RequestedJdbcResource)requestedResource;
                try {
                    webApp.addBean("ResourceRef", new String[]{"ResRefName", "Description", "ResType", "ResAuth"}, new Object[]{requestedJdbcResource.getResourceName(), "Visual Web generated DataSource Reference", "javax.sql.DataSource", "Container"}, "ResRefName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                }
                catch (NameAlreadyUsedException nameAlreadyUsedException) {
                    ErrorManager.getDefault().notify(1, (Throwable)nameAlreadyUsedException);
                }
                bl = true;
            }
            if (bl) {
                try {
                    webApp.write(fileObject);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

