/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.naming;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogBase {
    private static final String DEFAULT_NAME = "SEVERE";
    private static final Level DEFAULT = Level.SEVERE;
    private static final String OFF_NAME = "OFF";
    private static final Level OFF_LEVEL = Level.OFF;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};
    private Logger logger = null;
    private Level level = DEFAULT;
    private String packageName;
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.visualweb.dataconnectivity.naming.Bundle", Locale.getDefault());

    protected LogBase(String string) {
        this.packageName = string;
    }

    protected Logger getPackageLogger() {
        if (this.logger == null) {
            String string = System.getProperty(this.packageName, DEFAULT_NAME);
            for (int i = 1; i < LEVELS.length; ++i) {
                if (!string.toLowerCase().equals(LEVEL_NAMES[i].toLowerCase())) continue;
                this.level = LEVELS[i];
                break;
            }
            LogManager.getLogManager().addLogger(new Logger(this.packageName, null){});
            this.logger = LogManager.getLogManager().getLogger(this.packageName);
            if (this.logger == null) {
                System.out.println(this.packageName + ": " + rb.getString("CANT_GET_LOGGER"));
                return Logger.getLogger("global");
            }
            this.logger.setLevel(this.level);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(this.level);
            Formatter formatter = new Formatter(){

                public String format(LogRecord logRecord) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[#|");
                    stringBuffer.append(new Date(logRecord.getMillis()));
                    stringBuffer.append('|');
                    stringBuffer.append(logRecord.getSequenceNumber());
                    stringBuffer.append('|');
                    stringBuffer.append(logRecord.getLevel().getLocalizedName());
                    stringBuffer.append('|');
                    stringBuffer.append(logRecord.getThreadID());
                    if (logRecord.getLoggerName() != null) {
                        stringBuffer.append('|');
                        stringBuffer.append(logRecord.getLoggerName());
                    }
                    if (logRecord.getSourceClassName() != null) {
                        stringBuffer.append('|');
                        stringBuffer.append(logRecord.getSourceClassName());
                    }
                    if (logRecord.getSourceMethodName() != null) {
                        stringBuffer.append('|');
                        stringBuffer.append(logRecord.getSourceMethodName());
                        stringBuffer.append('(');
                        Object[] objectArray = logRecord.getParameters();
                        if (objectArray != null) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (i != 0) {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append(objectArray[i]);
                            }
                        }
                        stringBuffer.append(')');
                    }
                    if (logRecord.getThrown() != null) {
                        stringBuffer.append('|');
                        stringBuffer.append(logRecord.getThrown());
                    }
                    if (logRecord.getMessage() != null) {
                        stringBuffer.append('|');
                        stringBuffer.append(logRecord.getMessage());
                    }
                    stringBuffer.append("|#]\n");
                    return stringBuffer.toString();
                }
            };
            consoleHandler.setFormatter(formatter);
            this.logger.addHandler(consoleHandler);
        }
        return this.logger;
    }
}

