/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.dataconnectivity.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SampleDatabaseCreator {
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final String DRIVER_DISP_NAME_NET = "Java DB (Network)";
    private static Logger LOGGER = Logger.getLogger(SampleDatabaseCreator.class.getName());

    public static void createAll(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, int n) {
        try {
            if (DerbyDatabases.isDerbyRegistered()) {
                SampleDatabaseCreator sampleDatabaseCreator = new SampleDatabaseCreator();
                if (DerbyDatabases.databaseExists((String)string)) {
                    sampleDatabaseCreator.registerDatabase(string, string2, string4.toUpperCase(), string3, bl, string6, n);
                    NbPreferences.forModule(SampleDatabaseCreator.class).put("VISUALWEB_SAMPLE_DATABASE_REGISTERED", "true");
                }
            }
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.WARNING, "Sample database error, ", databaseException);
        }
    }

    private void extractSampleDatabase(String string, String string2) throws IOException {
        File file = DerbyDatabases.getSystemHome();
        if (file == null) {
            throw new IllegalStateException("The derby.system.home directory is not set");
        }
        File file2 = InstalledFileLocator.getDefault().locate(string2, null, false);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(SampleDatabaseCreator.class, (String)"MSG_DERBY_SYSTEM_FOLDER_NOT_FOUND"));
        } else {
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder(string);
                SampleDatabaseCreator.extractZip(file2, fileObject2);
            }
        }
    }

    private DatabaseConnection registerDatabase(String string, String string2, String string3, String string4, boolean bl, String string5, int n) throws DatabaseException {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(DRIVER_CLASS_NET);
        if (jDBCDriverArray.length == 0) {
            throw new IllegalStateException("The Java DB (Network) driver was not found");
        }
        DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)jDBCDriverArray[0], (String)("jdbc:derby://" + string5 + ":" + n + "/" + string), (String)string2, (String)string3, (String)string4, (boolean)bl);
        ConnectionManager.getDefault().addConnection(databaseConnection);
        return databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File file, FileObject fileObject) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)string);
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    public static void createDatabase(String string, String string2) {
        try {
            if (DerbyDatabases.isDerbyRegistered()) {
                SampleDatabaseCreator sampleDatabaseCreator = new SampleDatabaseCreator();
                if (!DerbyDatabases.databaseExists((String)string)) {
                    sampleDatabaseCreator.extractSampleDatabase(string, string2);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Sample database error, ", iOException);
        }
    }
}

