/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.ShowLocalHistoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RevertDeletedAction
extends NodeAction {
    public RevertDeletedAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
                Set set = vCSContext.getRootFiles();
                if (set == null || set.size() < 1) {
                    return;
                }
                for (File file : set) {
                    if (VersioningSupport.isFlat((File)file)) {
                        RevertDeletedAction.this.revert(file);
                        continue;
                    }
                    RevertDeletedAction.this.revertRecursively(file);
                }
            }
        });
    }

    private void revertRecursively(File file) {
        File[] fileArray;
        this.revert(file);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory()) continue;
            this.revertRecursively(file2);
        }
    }

    private void revert(File file) {
        StoreEntry[] storeEntryArray;
        for (StoreEntry storeEntry : storeEntryArray = LocalHistory.getInstance().getLocalHistoryStore().getDeletedFiles(file)) {
            RevertDeletedAction.revert(storeEntry);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
        Set set = vCSContext.getRootFiles();
        if (set == null || set.size() < 1) {
            return false;
        }
        for (File file : set) {
            if (file == null || file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowRevertDeleted");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowLocalHistoryAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void revert(StoreEntry storeEntry) {
        File file = storeEntry.getFile();
        if (file.exists()) {
            if (file.isFile()) {
                LocalHistory.LOG.warning("Skipping revert for file " + file.getAbsolutePath() + " which already exists.");
            }
            LocalHistory.getInstance().getLocalHistoryStore().fileCreate(file, file.lastModified());
        }
        File file2 = storeEntry.getStoreFile();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            if (!file2.isFile()) {
                FileUtil.createFolder((File)file);
            } else {
                FileObject fileObject = FileUtil.createData((File)file);
                outputStream = RevertDeletedAction.getOutputStream(fileObject);
                inputStream = storeEntry.getStoreFileInputStream();
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.SEVERE, null, exception);
            return;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static OutputStream getOutputStream(FileObject fileObject) throws FileAlreadyLockedException, IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return fileObject.getOutputStream();
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }
}

