/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api.config;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.config.AppClientVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.ApplicationVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.EjbJarVersion;
import org.netbeans.modules.glassfish.eecommon.api.config.ServletVersion;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class J2eeModuleHelper {
    private static final Map<Object, J2eeModuleHelper> helperMap;
    private final Object moduleType;
    private final String standardDDName;
    private final String webserviceDDName;
    private final String primarySunDDName;
    private final String secondarySunDDName;

    public static final J2eeModuleHelper getJ2eeModuleHelper(Object object) {
        return helperMap.get(object);
    }

    public static final J2eeModuleHelper getWsModuleHelper(String string) {
        return new WebServerDDHelper(string);
    }

    private J2eeModuleHelper(Object object, String string, String string2, String string3, String string4) {
        this.moduleType = object;
        this.standardDDName = string;
        this.webserviceDDName = string2;
        this.primarySunDDName = string3;
        this.secondarySunDDName = string4;
    }

    public Object getJ2eeModule() {
        return this.moduleType;
    }

    public String getStandardDDName() {
        return this.standardDDName;
    }

    public String getWebserviceDDName() {
        return this.webserviceDDName;
    }

    public String getPrimarySunDDName() {
        return this.primarySunDDName;
    }

    public String getSecondarySunDDName() {
        return this.secondarySunDDName;
    }

    public File getPrimarySunDDFile(J2eeModule j2eeModule) {
        return this.primarySunDDName != null ? j2eeModule.getDeploymentConfigurationFile(this.primarySunDDName) : null;
    }

    public File getSecondarySunDDFile(J2eeModule j2eeModule) {
        return this.secondarySunDDName != null ? j2eeModule.getDeploymentConfigurationFile(this.secondarySunDDName) : null;
    }

    public RootInterface getStandardRootDD(J2eeModule j2eeModule) {
        File file;
        RootInterface rootInterface = null;
        if (this.standardDDName != null && (file = j2eeModule.getDeploymentConfigurationFile(this.standardDDName)).exists()) {
            FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            try {
                rootInterface = this.getStandardRootDD(fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return rootInterface;
    }

    public Webservices getWebServicesRootDD(J2eeModule j2eeModule) {
        File file;
        Webservices webservices = null;
        if (this.webserviceDDName != null && (file = j2eeModule.getDeploymentConfigurationFile(this.webserviceDDName)).exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            try {
                webservices = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-eecommon").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return webservices;
    }

    protected abstract RootInterface getStandardRootDD(FileObject var1) throws IOException;

    protected abstract ASDDVersion getMinASVersion(String var1, ASDDVersion var2);

    static {
        HashMap<Object, J2eeModuleHelper> hashMap = new HashMap<Object, J2eeModuleHelper>();
        hashMap.put(J2eeModule.WAR, new WebDDHelper());
        hashMap.put(J2eeModule.EJB, new EjbDDHelper());
        hashMap.put(J2eeModule.EAR, new EarDDHelper());
        hashMap.put(J2eeModule.CLIENT, new ClientDDHelper());
        helperMap = Collections.unmodifiableMap(hashMap);
    }

    public static class ClientDDHelper
    extends J2eeModuleHelper {
        private ClientDDHelper() {
            super(J2eeModule.CLIENT, "application-client.xml", null, "META-INF/sun-application-client.xml", null);
        }

        protected RootInterface getStandardRootDD(FileObject fileObject) throws IOException {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }

        protected ASDDVersion getMinASVersion(String string, ASDDVersion aSDDVersion) {
            ASDDVersion aSDDVersion2 = aSDDVersion;
            AppClientVersion appClientVersion = AppClientVersion.getAppClientVersion(string);
            if (AppClientVersion.APP_CLIENT_1_4.equals(appClientVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (AppClientVersion.APP_CLIENT_5_0.equals(appClientVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_9_0;
            }
            return aSDDVersion2;
        }
    }

    public static class EarDDHelper
    extends J2eeModuleHelper {
        private EarDDHelper() {
            super(J2eeModule.EAR, "application.xml", null, "META-INF/sun-application.xml", null);
        }

        protected RootInterface getStandardRootDD(FileObject fileObject) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(fileObject);
        }

        protected ASDDVersion getMinASVersion(String string, ASDDVersion aSDDVersion) {
            ASDDVersion aSDDVersion2 = aSDDVersion;
            ApplicationVersion applicationVersion = ApplicationVersion.getApplicationVersion(string);
            if (ApplicationVersion.APPLICATION_1_4.equals(applicationVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ApplicationVersion.APPLICATION_5_0.equals(applicationVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_9_0;
            }
            return aSDDVersion2;
        }
    }

    public static class EjbDDHelper
    extends J2eeModuleHelper {
        private EjbDDHelper() {
            super(J2eeModule.EJB, "ejb-jar.xml", "webservices.xml", "META-INF/sun-ejb-jar.xml", "META-INF/sun-cmp-mappings.xml");
        }

        protected RootInterface getStandardRootDD(FileObject fileObject) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getDDRoot(fileObject);
        }

        protected ASDDVersion getMinASVersion(String string, ASDDVersion aSDDVersion) {
            ASDDVersion aSDDVersion2 = aSDDVersion;
            EjbJarVersion ejbJarVersion = EjbJarVersion.getEjbJarVersion(string);
            if (EjbJarVersion.EJBJAR_2_1.equals(ejbJarVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (EjbJarVersion.EJBJAR_3_0.equals(ejbJarVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_9_0;
            }
            return aSDDVersion2;
        }
    }

    public static class WebServerDDHelper
    extends J2eeModuleHelper {
        private WebServerDDHelper(String string) {
            super(J2eeModule.WAR, "WEB-INF/web.xml", "WEB-INF/webservices.xml", string, null);
        }

        protected RootInterface getStandardRootDD(FileObject fileObject) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(fileObject);
        }

        protected ASDDVersion getMinASVersion(String string, ASDDVersion aSDDVersion) {
            ASDDVersion aSDDVersion2 = aSDDVersion;
            ServletVersion servletVersion = ServletVersion.getServletVersion(string);
            if (ServletVersion.SERVLET_2_4.equals(servletVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ServletVersion.SERVLET_2_5.equals(servletVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_9_0;
            }
            return aSDDVersion2;
        }
    }

    public static class WebDDHelper
    extends J2eeModuleHelper {
        private WebDDHelper() {
            super(J2eeModule.WAR, "WEB-INF/web.xml", "WEB-INF/webservices.xml", "WEB-INF/sun-web.xml", null);
        }

        protected RootInterface getStandardRootDD(FileObject fileObject) throws IOException {
            return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(fileObject);
        }

        protected ASDDVersion getMinASVersion(String string, ASDDVersion aSDDVersion) {
            ASDDVersion aSDDVersion2 = aSDDVersion;
            ServletVersion servletVersion = ServletVersion.getServletVersion(string);
            if (ServletVersion.SERVLET_2_4.equals(servletVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_8_1;
            } else if (ServletVersion.SERVLET_2_5.equals(servletVersion)) {
                aSDDVersion2 = ASDDVersion.SUN_APPSERVER_9_0;
            }
            return aSDDVersion2;
        }
    }
}

