/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.GradientShadePanel;
import org.netbeans.modules.xml.schema.abe.InplaceEditableLabel;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.schema.abe.nodes.NamespaceNode;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class NamespacePanel
extends GradientShadePanel {
    protected static final long serialVersionUID = 7526472295622776147L;
    private InplaceEditableLabel namespaceLabel;
    NamespaceNode nsNode;

    public NamespacePanel(InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
        this.selectedTopGradientColor = Color.WHITE;
        this.selectedBottomGradientColor = Color.WHITE;
        this.initialize();
        this.initKeyListener();
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (NamespacePanel.this.context.getFocusTraversalManager().isFocusChangeEvent(keyEvent)) {
                    NamespacePanel.this.context.getFocusTraversalManager().handleEvent(keyEvent, NamespacePanel.this);
                }
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        String string = this.getNamespace();
        this.namespaceLabel = new InplaceEditableLabel(string);
        this.namespaceLabel.setForeground(InstanceDesignConstants.NAMESPACE_COLOR);
        this.namespaceLabel.setWidthMagnificationFactor(1);
        this.initNamespaceEditListener();
        this.initNamespaceChangeListener();
        this.add(Box.createHorizontalStrut(14), "West");
        this.add(Box.createVerticalStrut(5), "North");
        this.add((Component)this.namespaceLabel, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(Box.createVerticalStrut(5), "North");
        JSeparator jSeparator = new JSeparator();
        jSeparator.setForeground(new Color(250, 232, 213));
        jPanel.add((Component)jSeparator, "Center");
        this.add((Component)jPanel, "South");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SELECTED")) {
                    Font font = NamespacePanel.this.namespaceLabel.getFont();
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        NamespacePanel.this.setBorder(new LineBorder(InstanceDesignConstants.XP_ORANGE, 2));
                        NamespacePanel.this.namespaceLabel.setFont(new Font(font.getName(), 1, font.getSize()));
                    } else {
                        NamespacePanel.this.setBorder(new EmptyBorder(1, 1, 1, 1));
                        NamespacePanel.this.namespaceLabel.setFont(new Font(font.getName(), 0, font.getSize()));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NamespacePanel.this.mouseClickedActionHandler(mouseEvent, false);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                NamespacePanel.this.mouseClickedActionHandler(mouseEvent, true);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                NamespacePanel.this.mouseClickedActionHandler(mouseEvent, true);
            }
        });
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespacePanel.class, (String)"LBL_NAMESPACE_PANEL"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_NAMESPACE_PANEL"));
    }

    public void mouseClickedActionHandler(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.getClickCount() == 1) {
            if (mouseEvent.isPopupTrigger()) {
                this.context.getMultiComponentActionManager().showPopupMenu(mouseEvent, (ABEBaseDropPanel)this);
                return;
            }
            if (bl) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                this.context.getComponentSelectionManager().addToSelectedComponents(this);
            } else {
                this.context.getComponentSelectionManager().setSelectedComponent(this);
            }
        }
    }

    public String getNamespace() {
        String string = this.context.getAXIModel().getRoot().getTargetNamespace();
        if (string == null) {
            return NbBundle.getMessage(NamespacePanel.class, (String)"LBL_NO_NAMESPACE");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaceInModel(String string) {
        AXIModel aXIModel = this.context.getAXIModel();
        aXIModel.startTransaction();
        try {
            aXIModel.getRoot().setTargetNamespace(string);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    protected void initNamespaceEditListener() {
        this.namespaceLabel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                NamespacePanel.this.namespaceLabel;
                if (string.equals("PROPERTY_MODE_CHANGE") && propertyChangeEvent.getNewValue() == InplaceEditableLabel.Mode.EDIT) {
                    final JTextField jTextField = new JTextField(NamespacePanel.this.getNamespace());
                    jTextField.select(0, jTextField.getText().length());
                    jTextField.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = jTextField.getText();
                            try {
                                new URI(string);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
                                return;
                            }
                            NamespacePanel.this.setNamespaceInModel(string);
                            NamespacePanel.this.namespaceLabel.setText(NamespacePanel.this.getNamespace());
                        }
                    });
                    NamespacePanel.this.namespaceLabel.setInlineEditorComponent(jTextField);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement() {
        AXIDocument aXIDocument = this.context.getAXIModel().getRoot();
        AXIModel aXIModel = this.context.getAXIModel();
        aXIModel.startTransaction();
        try {
            Element element = aXIModel.getComponentFactory().createElement();
            String string = UIUtilities.getUniqueName("newElement", (AXIComponent)aXIDocument);
            element.setName(string);
            aXIDocument.addElement(element);
        }
        finally {
            this.context.setUserInducedEventMode(true, this);
            aXIModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComplexType() {
        AXIDocument aXIDocument = this.context.getAXIModel().getRoot();
        AXIModel aXIModel = this.context.getAXIModel();
        aXIModel.startTransaction();
        try {
            ContentModel contentModel = aXIModel.getComponentFactory().createComplexType();
            String string = UIUtilities.getUniqueName("newComplexType", (AXIComponent)aXIDocument);
            contentModel.setName(string);
            aXIDocument.addContentModel(contentModel);
        }
        finally {
            this.context.setUserInducedEventMode(true, this);
            aXIModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        super.drop(dropTargetDropEvent);
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDropEvent);
        if (paletteItem != DnDHelper.PaletteItem.ELEMENT) {
            if (paletteItem != DnDHelper.PaletteItem.COMPLEXTYPE) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
        }
        this.context.setUserInducedEventMode(true, this);
        try {
            if (paletteItem == DnDHelper.PaletteItem.ELEMENT) {
                this.addElement();
                return;
            } else {
                if (paletteItem != DnDHelper.PaletteItem.COMPLEXTYPE) return;
                this.addComplexType();
            }
            return;
        }
        finally {
            this.context.setUserInducedEventMode(false);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        super.dragExit(dropTargetEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDragEvent);
        if (paletteItem != DnDHelper.PaletteItem.ELEMENT) {
            if (paletteItem != DnDHelper.PaletteItem.COMPLEXTYPE) {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        super.dragEnter(dropTargetDragEvent);
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDragEvent);
        if (paletteItem != DnDHelper.PaletteItem.ELEMENT) {
            if (paletteItem != DnDHelper.PaletteItem.COMPLEXTYPE) {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    public ABEAbstractNode getNBNode() {
        if (this.nsNode == null) {
            this.nsNode = new NamespaceNode((AXIComponent)this.context.getAXIModel().getRoot(), this.context);
        }
        return this.nsNode;
    }

    public AXIComponent getAXIComponent() {
        return this.context.getAXIModel().getRoot();
    }

    private void initNamespaceChangeListener() {
        this.context.getAXIModel().getRoot().addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, (AXIComponent)this.context.getAXIModel().getRoot()){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("targetNamespace")) {
                    NamespacePanel.this.namespaceLabel.setText(NamespacePanel.this.getNamespace());
                }
            }
        });
    }

    public void accept(UIVisitor uIVisitor) {
        uIVisitor.visit(this);
    }
}

