/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.AttributePanel;
import org.netbeans.modules.xml.schema.abe.ElementPanel;
import org.netbeans.modules.xml.schema.abe.ElementPropertiesPanel;
import org.netbeans.modules.xml.schema.abe.ExpandCollapseButton;
import org.netbeans.modules.xml.schema.abe.InplaceEditableLabel;
import org.netbeans.modules.xml.schema.abe.InputValidator;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.RoundExpandCollapseButton;
import org.netbeans.modules.xml.schema.abe.TagPanel;
import org.netbeans.modules.xml.schema.abe.TweenerListener;
import org.netbeans.modules.xml.schema.abe.TweenerPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.action.AttributeOnElementNewType;
import org.netbeans.modules.xml.schema.abe.action.ElementOnElementNewType;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTagPanel
extends TagPanel {
    protected static final long serialVersionUID = 7526472295622776147L;
    private ExpandCollapseButton expandButton;
    private Font tagNameFont;
    boolean initialized = false;
    SpringLayout startTagPanelLayout;
    Color tagNameLabelColor = InstanceDesignConstants.TAG_NAME_COLOR;
    Component lastNonAtribComponent;
    Component lastAtribComponent;
    Component firstRowLastComp;
    static final String locHidden = NbBundle.getMessage(StartTagPanel.class, (String)"LBL_HIDDEN");
    static final String locAttr = NbBundle.getMessage(StartTagPanel.class, (String)"LBL_ATTRIBUTE");
    static final String locAttrs = NbBundle.getMessage(StartTagPanel.class, (String)"LBL_ATTRIBUTES");
    int TAG_HEIGHT_ADJUSTMENT = 5;
    private InplaceEditableLabel tagNameLabel;
    List<Component> componentList;
    private Component firstTweener;
    private static final int ATTR_HEAD_ROOM_SPACE = 3;
    private static final int LABEL_HEAD_ROOM_SPACE = TagPanel.getTagHeight() / 2 - 9;
    private static final int INTER_PANEL_SPACE = 2;
    private final JLabel endSlash = new JLabel("");
    private JPanel elementPropertiesPanel;
    RoundExpandCollapseButton attributeCollapseButton = new RoundExpandCollapseButton("+", false);
    boolean attributesAreShown = false;
    JLabel attributeCountLabel = new JLabel();
    public static final int NO_OF_FIRST_ROW_ATTRS = 5;
    public static final int NO_OF_ATTRS_PER_ROW = 6;
    int firstAttrPos = this.getA() + 2 + 12;
    JLabel hgap = new JLabel();

    public StartTagPanel(ElementPanel elementPanel, InstanceUIContext instanceUIContext) {
        super(elementPanel, instanceUIContext);
        elementPanel.getAXIContainer().addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, (AXIComponent)elementPanel.getAXIContainer()){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("name")) {
                    StartTagPanel.this.setTagName(StartTagPanel.this.getElementPanel().getAXIContainer().getName());
                    StartTagPanel.this.forceSizeRecalculate();
                    StartTagPanel.this.revalidate();
                    StartTagPanel.this.repaint();
                } else if (string.equals("attribute") || string.equals("attributeRef")) {
                    StartTagPanel.this.updateAttributes();
                    if (propertyChangeEvent.getNewValue() != null && StartTagPanel.this.context.getUserActedComponent() == StartTagPanel.this) {
                        StartTagPanel.this.showAttributes();
                        StartTagPanel.this.showAttributeEditFor((Attribute)propertyChangeEvent.getNewValue());
                        StartTagPanel.this.context.resetUserActedComponent();
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("type")) {
                    StartTagPanel.this.updateAttributes();
                }
            }
        });
        this.initialize();
        this.initKeyListener();
    }

    protected void initKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 113) {
                    StartTagPanel.this.tagNameLabel.showEditor();
                }
                if (StartTagPanel.this.context.getFocusTraversalManager().isFocusChangeEvent(keyEvent)) {
                    StartTagPanel.this.context.getFocusTraversalManager().handleEvent(keyEvent, StartTagPanel.this);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                block7: {
                    block8: {
                        block6: {
                            if (keyEvent.getKeyChar() != ' ') break block6;
                            StartTagPanel.this.tagNameLabel.showEditor();
                            break block7;
                        }
                        if (keyEvent.getKeyChar() != 'E') break block8;
                        for (NewType newType : StartTagPanel.this.getNBNode().getNewTypes()) {
                            if (!(newType instanceof ElementOnElementNewType)) continue;
                            try {
                                newType.create();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                        break block7;
                    }
                    if (keyEvent.getKeyChar() != 'A') break block7;
                    for (NewType newType : StartTagPanel.this.getNBNode().getNewTypes()) {
                        if (!(newType instanceof AttributeOnElementNewType)) continue;
                        try {
                            newType.create();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
        });
    }

    private void initialize() {
        this.initialized = true;
        this.setOpaque(false);
        this.startTagPanelLayout = new SpringLayout();
        this.setLayout(this.startTagPanelLayout);
        this.attributeCollapseButton.setToolTipText(NbBundle.getMessage(StartTagPanel.class, (String)"TTP_ATTR_EXPAND_COLLAPSE_BUTTON"));
        this.attributeCountLabel.setForeground(InstanceDesignConstants.ITEM_COUNT_COLOR);
        this.expandButton = this.getElementPanel().getExpandButton();
        this.add(this.expandButton);
        this.startTagPanelLayout.putConstraint("West", (Component)this.expandButton, this.getA(), "West", (Component)this);
        this.startTagPanelLayout.putConstraint("North", (Component)this.expandButton, LABEL_HEAD_ROOM_SPACE + 5, "North", (Component)this);
        this.tagNameLabel = new InplaceEditableLabel();
        this.tagNameLabel.setToolTipText(NbBundle.getMessage(StartTagPanel.class, (String)"TTP_ELEMENT_NAME_LABEL"));
        this.tagNameLabelColor = InstanceDesignConstants.TAG_NAME_COLOR;
        if (this.getElementPanel().getAXIContainer().isReadOnly() || this.getElementPanel().getAXIContainer() instanceof AnyElement) {
            this.tagNameLabelColor = InstanceDesignConstants.TAG_NAME_READONLY_COLOR;
            this.tagNameLabel.setToolTipText(NbBundle.getMessage(StartTagPanel.class, (String)"TTP_ELEMENT_NAME_LABEL_READONLY"));
        } else if (this.getElementPanel().getAXIContainer().isShared()) {
            this.tagNameLabelColor = InstanceDesignConstants.TAG_NAME_SHARED_COLOR;
            this.tagNameLabel.setToolTipText(NbBundle.getMessage(StartTagPanel.class, (String)"TTP_ELEMENT_NAME_LABEL_SHARED"));
        }
        this.tagNameLabel.setForeground(this.tagNameLabelColor);
        this.getEndSlash().setForeground(this.tagNameLabel.getForeground());
        this.initTagEditListener();
        Component component = Box.createHorizontalStrut(5);
        this.add(component);
        this.startTagPanelLayout.putConstraint("West", component, this.getA() + 2 + 8, "West", (Component)this);
        this.startTagPanelLayout.putConstraint("North", component, LABEL_HEAD_ROOM_SPACE, "North", (Component)this);
        this.add(this.tagNameLabel);
        this.startTagPanelLayout.putConstraint("West", (Component)this.tagNameLabel, 0, "East", component);
        this.startTagPanelLayout.putConstraint("North", (Component)this.tagNameLabel, LABEL_HEAD_ROOM_SPACE, "North", (Component)this);
        component = Box.createHorizontalStrut(5);
        this.add(component);
        this.startTagPanelLayout.putConstraint("West", component, 0, "East", (Component)this.tagNameLabel);
        this.startTagPanelLayout.putConstraint("North", component, LABEL_HEAD_ROOM_SPACE, "North", (Component)this);
        this.firstRowLastComp = component;
        this.updateTagName();
        this.addNonAttributeComponents();
        this.updateAttributes();
        this.addSelectionListener();
    }

    protected void initTagEditListener() {
        this.tagNameLabel.addCtrlClickHandler(new InplaceEditableLabel.CtrlClickHandler(){

            public void handleCtrlClick() {
                StartTagPanel.this.getNBNode().showSuperDefinition();
            }
        });
        this.tagNameLabel.setInputValidator(new InputValidator(){

            public boolean isStringValid(String string) {
                return Utils.isValidNCName((String)string);
            }
        }, NbBundle.getMessage(StartTagPanel.class, (String)"MSG_NOT_A_NCNAME"));
        this.tagNameLabel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                StartTagPanel.this.tagNameLabel;
                if (string.equals("PROPERTY_MODE_CHANGE") && propertyChangeEvent.getNewValue() == InplaceEditableLabel.Mode.EDIT) {
                    String string2;
                    final JTextField jTextField = new JTextField(StartTagPanel.this.getElementPanel().getAXIContainer().getName());
                    jTextField.select(0, jTextField.getText().length());
                    jTextField.addActionListener(new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = jTextField.getText();
                            if (StartTagPanel.this.getElementPanel().getAXIContainer().getName().equals(string)) {
                                return;
                            }
                            if (Utils.isValidNCName((String)string)) {
                                jTextField.setCursor(new Cursor(3));
                                try {
                                    if (StartTagPanel.this.firstTimeRename) {
                                        StartTagPanel.this.getNBNode().setNameInModel(string);
                                    } else {
                                        StartTagPanel.this.setTagNameInModel(string);
                                    }
                                    StartTagPanel.this.firstTimeRename = false;
                                }
                                finally {
                                    jTextField.setCursor(new Cursor(0));
                                }
                            }
                        }
                    });
                    if (StartTagPanel.this.getElementPanel().getAXIContainer().isShared()) {
                        string2 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_SHARED_ELEMENT_EDIT");
                        StartTagPanel.this.tagNameLabel.setEditInfoText(string2, StartTagPanel.this.context);
                    }
                    if (!StartTagPanel.this.getElementPanel().getAXIContainer().isReadOnly()) {
                        if (StartTagPanel.this.getElementPanel().getAXIContainer() instanceof AnyElement) {
                            string2 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ANY_ELEMENT_EDIT");
                            StartTagPanel.this.tagNameLabel.setEditInfoText(string2, StartTagPanel.this.context);
                        } else {
                            StartTagPanel.this.tagNameLabel.setInlineEditorComponent(jTextField);
                        }
                    } else {
                        string2 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_READONLY_ELEMENT_EDIT");
                        StartTagPanel.this.tagNameLabel.setEditInfoText(string2, StartTagPanel.this.context);
                    }
                }
            }
        });
    }

    private void setTagNameInModel(String string) {
        this.getNBNode().setName(string);
    }

    @Override
    public void setTagName(String string) {
        String string2 = string;
        Font font = this.tagNameLabel.getFont();
        font = font.deriveFont(font.getStyle() | 0, font.getSize() + 2);
        this.tagNameLabel.setFont(font);
        this.tagNameLabel.setText(string2);
    }

    public void updateTagName() {
        this.setTagName(this.getElementPanel().getAXIContainer().getName());
    }

    private void showAttributeEditFor(Attribute attribute) {
        if (this.componentList != null) {
            for (Component component : this.componentList) {
                AttributePanel attributePanel;
                if (!(component instanceof AttributePanel) || (attributePanel = (AttributePanel)component).getAttribute() != attribute) continue;
                this.context.getComponentSelectionManager().setSelectedComponent(attributePanel);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UIUtilities.scrollViewTo(attributePanel, StartTagPanel.this.context);
                        attributePanel.showEditorForName(true);
                    }
                });
                return;
            }
        }
    }

    public void updateAttributes() {
        this.updateAttributeCountLabel();
        if (this.componentList != null) {
            for (Component component : this.componentList) {
                if (component == this.firstTweener) continue;
                this.startTagPanelLayout.removeLayoutComponent(component);
                this.remove(component);
            }
        }
        this.componentList = new ArrayList<Component>();
        this.componentList.add(this.firstTweener);
        int n = this.getElementPanel().getAXIContainer().getAttributes().size();
        if (n > 0) {
            if (!this.attributeCollapseButton.isVisible()) {
                this.attributeCollapseButton.setVisible(true);
                this.attributeCountLabel.setVisible(true);
                if (this.context.isUserInducedEventMode()) {
                    this.attributeCollapseButton.setText("-");
                }
            }
        } else if (this.attributeCollapseButton.isVisible()) {
            this.attributeCollapseButton.setVisible(false);
            this.attributeCountLabel.setVisible(false);
        }
        this.lastAtribComponent = this.firstTweener;
        this.firstRowLastComp = null;
        if (this.attributesAreShown) {
            this.addAttributes();
            if (this.firstRowLastComp == null) {
                this.firstRowLastComp = this.getEndSlash();
            }
        } else {
            this.hgap.setPreferredSize(new Dimension(0, 0));
            this.firstRowLastComp = this.getEndSlash();
        }
        this.addEndSlashLabel();
        this.addElementPropertiesPanel();
        this.revalidate();
        this.getElementPanel().repaint();
    }

    protected void addAttributeCountLabel() {
        if (this.attributesAreShown) {
            return;
        }
        int n = this.getElementPanel().getAXIContainer().getAttributes().size();
        if (n > 0) {
            String string = this.attributesAreShown ? "" : " " + locHidden;
            String string2 = "";
            if (!this.attributesAreShown) {
                string2 = n == 1 ? " " + locAttr : " " + locAttrs;
            }
            String string3 = "[" + n + string2 + string + "]";
            String string4 = "[" + n + "]";
            this.attributeCountLabel.setText(string4);
            this.attributeCountLabel.setToolTipText(string3);
            this.add(this.attributeCountLabel);
            this.startTagPanelLayout.putConstraint("West", (Component)this.attributeCountLabel, 0, "East", this.lastAtribComponent);
            this.startTagPanelLayout.putConstraint("North", (Component)this.attributeCountLabel, (this.getRowCount() - 1) * StartTagPanel.getTagHeight() + LABEL_HEAD_ROOM_SPACE, "North", (Component)this);
            this.lastAtribComponent = this.attributeCountLabel;
        }
    }

    private void updateAttributeCountLabel() {
        int n = this.getElementPanel().getAXIContainer().getAttributes().size();
        if (n > 0) {
            String string = this.attributesAreShown ? "" : " " + locHidden;
            String string2 = "";
            if (!this.attributesAreShown) {
                string2 = n == 1 ? " " + locAttr : " " + locAttrs;
            }
            String string3 = "[" + n + string2 + string + "]";
            String string4 = "[" + n + "]";
            this.attributeCountLabel.setText(string4);
            this.attributeCountLabel.setToolTipText(string3);
        } else {
            this.attributeCountLabel.setText("");
            this.attributeCountLabel.setToolTipText("");
        }
    }

    protected void addEndSlashLabel() {
        this.add(this.getEndSlash());
        this.startTagPanelLayout.putConstraint("West", (Component)this.getEndSlash(), 2, "East", this.lastAtribComponent);
        this.startTagPanelLayout.putConstraint("North", (Component)this.getEndSlash(), this.getLastRowComponentsHeadRoom() + 5, "North", (Component)this);
        this.componentList.add(this.getEndSlash());
        this.lastAtribComponent = this.getEndSlash();
    }

    private int getLastRowComponentsHeadRoom() {
        return (this.getRowCount() - 1) * (StartTagPanel.getTagHeight() - this.TAG_HEIGHT_ADJUSTMENT);
    }

    private void addElementPropertiesPanel() {
        if (this.elementPropertiesPanel != null) {
            this.excludePaintComponentList.remove(this.elementPropertiesPanel);
        }
        this.elementPropertiesPanel = this.getNewAXIContainerPropertiesPanel();
        this.add(this.elementPropertiesPanel);
        this.startTagPanelLayout.putConstraint("West", (Component)this.elementPropertiesPanel, this.getA() + 2 + 6, "East", (Component)this.getEndSlash());
        this.startTagPanelLayout.putConstraint("North", (Component)this.elementPropertiesPanel, this.getLastRowComponentsHeadRoom(), "North", (Component)this);
        this.elementPropertiesPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StartTagPanel.this.dispatchEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                StartTagPanel.this.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                StartTagPanel.this.dispatchEvent(mouseEvent);
            }
        });
        this.componentList.add(this.elementPropertiesPanel);
        this.excludePaintComponentList.add(this.elementPropertiesPanel);
    }

    protected void addNonAttributeComponents() {
        this.add(this.attributeCollapseButton);
        this.attributeCollapseButton.setVisible(false);
        this.startTagPanelLayout.putConstraint("West", (Component)this.attributeCollapseButton, 2, "East", this.firstRowLastComp);
        this.startTagPanelLayout.putConstraint("North", (Component)this.attributeCollapseButton, 5, "North", (Component)this);
        this.attributeCollapseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartTagPanel.this.showOrHideAttrs();
            }
        });
        this.lastAtribComponent = this.attributeCollapseButton;
        this.addAttributeCountLabel();
        this.firstTweener = Box.createHorizontalStrut(0);
        this.add(this.firstTweener);
        this.startTagPanelLayout.putConstraint("West", this.firstTweener, 2, "East", this.lastAtribComponent);
        this.startTagPanelLayout.putConstraint("North", this.firstTweener, 3, "North", (Component)this);
    }

    private void showOrHideAttrs() {
        if (this.attributesAreShown) {
            this.hideAttributes();
        } else {
            this.showAttributes();
        }
    }

    public void showAttributes() {
        if (this.attributesAreShown) {
            return;
        }
        this.attributesAreShown = true;
        this.attributeCollapseButton.setText("-");
        this.attributeCountLabel.setVisible(false);
        this.updateAttributes();
    }

    public void hideAttributes() {
        if (!this.attributesAreShown) {
            return;
        }
        this.attributesAreShown = false;
        this.attributeCollapseButton.setText("+");
        this.attributeCountLabel.setVisible(true);
        this.updateAttributes();
    }

    protected void addAttributes() {
        int n = 0;
        int n2 = 0;
        int n3 = StartTagPanel.getTagHeight() - this.TAG_HEIGHT_ADJUSTMENT;
        List list = this.getElementPanel().getAXIContainer().getAttributes();
        for (int i = 0; i < list.size(); ++i) {
            if (i < 5) {
                n = 0;
                n2 = i % 5;
            } else {
                n = (int)Math.ceil((double)(i + 1 - 5) / 6.0);
                n2 = (i + 1 - 5) % 6;
                if (--n2 == -1) {
                    n2 = 5;
                }
            }
            AttributePanel attributePanel = new AttributePanel(this, (AbstractAttribute)list.get(i), this.context);
            this.add(attributePanel);
            this.componentList.add(attributePanel);
            if (n2 != 0 || n == 0) {
                this.startTagPanelLayout.putConstraint("West", (Component)attributePanel, 0, "East", this.lastAtribComponent);
            } else {
                this.startTagPanelLayout.putConstraint("West", (Component)attributePanel, this.firstAttrPos, "West", (Component)this);
            }
            this.startTagPanelLayout.putConstraint("North", (Component)attributePanel, n * n3 + 3 + 1, "North", (Component)this);
            Component component = Box.createHorizontalStrut(10);
            this.add(component);
            this.componentList.add(component);
            this.startTagPanelLayout.putConstraint("West", component, 0, "East", (Component)attributePanel);
            this.startTagPanelLayout.putConstraint("North", component, n * n3 + 3, "North", (Component)this);
            this.lastAtribComponent = component;
            if (i + 1 != 5 || i + 1 == list.size()) continue;
            this.firstRowLastComp = this.lastAtribComponent;
        }
    }

    @Override
    public int getRowCount() {
        boolean bl = false;
        if (!this.attributesAreShown) {
            return 1;
        }
        int n = this.getElementPanel().getAXIContainer().getAttributes().size();
        if (n < 5) {
            return 1;
        }
        return (int)Math.ceil((double)(n -= 5) / 6.0) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewAttributeAt(TweenerPanel tweenerPanel) {
        int n = this.componentList.indexOf(tweenerPanel);
        if (n == -1) {
            return;
        }
        n /= 2;
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        aXIModel.startTransaction();
        try {
            Attribute attribute = aXIModel.getComponentFactory().createAttribute();
            String string = UIUtilities.getUniqueName("newAttribute", (AXIComponent)aXIContainer);
            attribute.setName(string);
            aXIContainer.addChildAtIndex((AXIComponent)attribute, n);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    private void addTweenerListener(final TweenerPanel tweenerPanel) {
        tweenerPanel.addTweenerListener(new TweenerListener(){

            public boolean dragAccept(DnDHelper.PaletteItem paletteItem) {
                if (paletteItem != DnDHelper.PaletteItem.ATTRIBUTE) {
                    String string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ATTRIBUTE_TWEENER_DROP_REJECT");
                    UIUtilities.showErrorMessageFor(string, StartTagPanel.this.context, StartTagPanel.this);
                    return false;
                }
                String string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ATTRIBUTE_TWEENER_DROP_ACCEPT", (Object)StartTagPanel.this.getElementPanel().getAXIContainer().getName());
                UIUtilities.showBulbMessageFor(string, StartTagPanel.this.context, StartTagPanel.this);
                return true;
            }

            public void drop(DnDHelper.PaletteItem paletteItem) {
                UIUtilities.hideGlassMessage();
                StartTagPanel.this.addNewAttributeAt(tweenerPanel);
            }

            public void dragEntered(DnDHelper.PaletteItem paletteItem) {
            }

            public void dragExited() {
                UIUtilities.hideGlassMessage();
            }
        });
    }

    @Override
    public int getInterComponentSpacing() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement() {
        if (this.context.isUserInducedEventMode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StartTagPanel.this.getElementPanel().setExpanded(true);
                }
            });
        }
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        Compositor compositor = aXIContainer.getCompositor();
        boolean bl = false;
        if (compositor == null) {
            compositor = aXIModel.getComponentFactory().createSequence();
            bl = true;
        }
        Element element = aXIModel.getComponentFactory().createElement();
        String string = UIUtilities.getUniqueName("newElement", (AXIComponent)compositor);
        element.setName(string);
        try {
            aXIModel.startTransaction();
            if (bl) {
                aXIContainer.addCompositor(compositor);
            }
            if (compositor.getParent() != null && compositor.getModel() != null) {
                compositor.addElement(element);
            }
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    public void addCompositor(Compositor.CompositorType compositorType) {
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        Compositor compositor = null;
        switch (compositorType) {
            case SEQUENCE: {
                compositor = aXIModel.getComponentFactory().createSequence();
                break;
            }
            case CHOICE: {
                compositor = aXIModel.getComponentFactory().createChoice();
                break;
            }
            case ALL: {
                compositor = aXIModel.getComponentFactory().createAll();
            }
        }
        this.addCompositor(compositor);
    }

    public void addCompositor(DnDHelper.PaletteItem paletteItem) {
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        Compositor compositor = null;
        switch (paletteItem) {
            case SEQUENCE: {
                compositor = aXIModel.getComponentFactory().createSequence();
                break;
            }
            case CHOICE: {
                compositor = aXIModel.getComponentFactory().createChoice();
                break;
            }
            case ALL: {
                compositor = aXIModel.getComponentFactory().createAll();
            }
        }
        this.addCompositor(compositor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompositor(Compositor compositor) {
        if (compositor == null) {
            return;
        }
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        aXIModel.startTransaction();
        try {
            aXIContainer.addCompositor(compositor);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute() {
        AXIContainer aXIContainer = this.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        aXIModel.startTransaction();
        try {
            Attribute attribute = aXIModel.getComponentFactory().createAttribute();
            String string = UIUtilities.getUniqueName("newAttribute", (AXIComponent)aXIContainer);
            attribute.setName(string);
            aXIContainer.addAttribute((AbstractAttribute)attribute);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        UIUtilities.hideGlassMessage();
        if (this.getElementPanel().getAXIContainer().isReadOnly()) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        this.setDragMode(false);
        this.context.setUserInducedEventMode(true, this);
        try {
            super.drop(dropTargetDropEvent);
            if (DnDHelper.getDraggedPaletteItem(dropTargetDropEvent) == DnDHelper.PaletteItem.ELEMENT) {
                this.addElement();
            }
            if (DnDHelper.isCompositor(DnDHelper.getDraggedPaletteItem(dropTargetDropEvent))) {
                if (this.getElementPanel().getAXIContainer().getCompositor() != null) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                this.addCompositor(DnDHelper.getDraggedPaletteItem(dropTargetDropEvent));
            }
            if (DnDHelper.getDraggedPaletteItem(dropTargetDropEvent) == DnDHelper.PaletteItem.ATTRIBUTE) {
                this.addAttribute();
            }
        }
        finally {
            this.context.setUserInducedEventMode(false);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        if (this.getElementPanel().getAXIContainer().isReadOnly()) {
            String string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_READONLY_COMPOSITOR_DROP", (Object)this.getElementPanel().getAXIContainer().getName());
            UIUtilities.showErrorMessageFor(string, this.context, this);
            dropTargetDragEvent.rejectDrag();
            return;
        }
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDragEvent);
        String string = "MSG_ELEMENT_DROP_ACCEPT";
        switch (paletteItem) {
            case ELEMENT: {
                Object[] objectArray;
                if (this.getElementPanel().getAXIContainer() instanceof Element && (objectArray = ((Element)this.getElementPanel().getAXIContainer()).getType()) != null) {
                    string = objectArray instanceof Datatype ? "MSG_SIMPLE2COMPLEX_WARNING" : string;
                }
            }
            case ATTRIBUTE: {
                Object[] objectArray = new String[]{paletteItem.toString().toLowerCase(), this.getElementPanel().getAXIContainer().getName()};
                String string2 = NbBundle.getMessage(StartTagPanel.class, (String)string, (Object[])objectArray);
                UIUtilities.showBulbMessageFor(string2, this.context, this);
                return;
            }
            case SEQUENCE: 
            case CHOICE: 
            case ALL: {
                if (this.getElementPanel().getAXIContainer().getCompositor() != null) {
                    Object[] objectArray = new String[]{this.getElementPanel().getAXIContainer().getCompositor().getType().getName(), this.getElementPanel().getAXIContainer().getName()};
                    String string3 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ELEMENT_COMPOSITOR_DROP_REJECT", (Object[])objectArray);
                    UIUtilities.showErrorMessageFor(string3, this.context, this);
                    dropTargetDragEvent.rejectDrag();
                    return;
                }
                Object[] objectArray = new String[]{paletteItem.toString().toLowerCase(), this.getElementPanel().getAXIContainer().getName()};
                String string4 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ELEMENT_DROP_ACCEPT", (Object[])objectArray);
                UIUtilities.showBulbMessageFor(string4, this.context, this);
                return;
            }
        }
        Object[] objectArray = new String[]{this.getElementPanel().getAXIContainer().getName()};
        String string5 = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ELEMENT_DROP_REJECT", (Object[])objectArray);
        UIUtilities.showErrorMessageFor(string5, this.context, this);
        dropTargetDragEvent.rejectDrag();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        super.dragEnter(dropTargetDragEvent);
        this.setDragMode(true);
        this.dragOver(dropTargetDragEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        super.dragExit(dropTargetEvent);
        this.setDragMode(false);
        UIUtilities.hideGlassMessage();
    }

    private void setDragMode(boolean bl) {
        if (bl) {
            this.tagNameLabel.setForeground(Color.WHITE);
            this.expandButton.setDragMode(true);
            this.attributeCollapseButton.setDragMode(true);
        } else {
            this.tagNameLabel.setForeground(this.tagNameLabelColor);
            this.expandButton.setDragMode(false);
            this.attributeCollapseButton.setDragMode(false);
        }
    }

    @Override
    public JLabel getEndSlash() {
        this.endSlash.setVisible(false);
        return this.endSlash;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        this.chainAttributeGroups(graphics2D);
    }

    public JPanel getNewAXIContainerPropertiesPanel() {
        return new ElementPropertiesPanel((AbstractElement)this.getElementPanel().getAXIContainer(), this.context);
    }

    void showTagNameEditor(boolean bl) {
        this.firstTimeRename = bl;
        if (this.tagNameLabel != null) {
            this.tagNameLabel.showEditor();
        }
    }

    private void addSelectionListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SELECTED")) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        if (StartTagPanel.this.tagNameFont == null) {
                            Font font = StartTagPanel.this.tagNameLabel.getFont();
                            StartTagPanel.this.tagNameFont = font.deriveFont(font.getStyle() | 0, font.getSize());
                            StartTagPanel.this.tagNameLabel.setFont(StartTagPanel.this.tagNameFont);
                        }
                        StartTagPanel.this.getElementPanel().repaint();
                    } else {
                        if (StartTagPanel.this.tagNameFont == null) {
                            Font font = StartTagPanel.this.tagNameLabel.getFont();
                            font = new Font(font.getName(), 0, font.getSize());
                            StartTagPanel.this.tagNameLabel.setFont(font);
                        }
                        StartTagPanel.this.getElementPanel().repaint();
                    }
                    StartTagPanel.this.getEndSlash().setForeground(StartTagPanel.this.tagNameLabel.getForeground());
                    StartTagPanel.this.getEndSlash().setFont(StartTagPanel.this.tagNameLabel.getFont());
                }
            }
        });
    }

    protected void chainAttributeGroups(Graphics2D graphics2D) {
        ArrayList<AttributePanel> arrayList = new ArrayList<AttributePanel>();
        for (Component component : this.componentList) {
            if (!(component instanceof AttributePanel)) continue;
            arrayList.add((AttributePanel)component);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i + 1 >= arrayList.size()) continue;
            this.chainIfNeeded((AttributePanel)arrayList.get(i), (AttributePanel)arrayList.get(i + 1), graphics2D);
        }
    }

    @Override
    public ABEBaseDropPanel getChildUIComponentFor(AXIComponent aXIComponent) {
        if (!(aXIComponent instanceof AbstractAttribute)) {
            return this.getElementPanel().getChildUIComponentFor(aXIComponent);
        }
        if (this.componentList == null) {
            return null;
        }
        this.showAttributes();
        for (Component component : this.componentList) {
            if (!(component instanceof AttributePanel) || ((AttributePanel)component).getUIComponentFor(aXIComponent) == null) continue;
            return (AttributePanel)component;
        }
        return null;
    }

    public List<AttributePanel> getAttributePanels() {
        if (this.componentList == null) {
            return Collections.EMPTY_LIST;
        }
        this.showAttributes();
        ArrayList<AttributePanel> arrayList = new ArrayList<AttributePanel>();
        for (Component component : this.componentList) {
            if (!(component instanceof AttributePanel)) continue;
            arrayList.add((AttributePanel)component);
        }
        return arrayList;
    }

    private void chainIfNeeded(AttributePanel attributePanel, AttributePanel attributePanel2, Graphics2D graphics2D) {
        int n = AttributePanel.getAttributePanelHeight();
        AbstractAttribute abstractAttribute = (AbstractAttribute)attributePanel.getAXIComponent();
        AbstractAttribute abstractAttribute2 = (AbstractAttribute)attributePanel2.getAXIComponent();
        if (abstractAttribute.getContentModel() != abstractAttribute2.getContentModel()) {
            return;
        }
        if (abstractAttribute.getContentModel() == null) {
            return;
        }
        if (!abstractAttribute.isShared()) {
            return;
        }
        Color color = InstanceDesignConstants.ATTR_BG_SHARED_COLOR;
        if (abstractAttribute.isReadOnly()) {
            color = InstanceDesignConstants.ATTR_BG_READONLY_COLOR;
        }
        Rectangle rectangle = attributePanel.getBounds();
        Rectangle rectangle2 = attributePanel2.getBounds();
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        if (rectangle.y == rectangle2.y) {
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y + (rectangle.height - n) / 2;
            int n4 = rectangle2.x - n2;
            int n5 = n;
            graphics2D.fillRect(n2, n3, n4, n5);
        } else {
            int n6 = 8;
            Point point = new Point(rectangle.x + rectangle.width + n6, rectangle.y);
            List<Point> list = UIUtilities.getBrokenTapePoints(point, rectangle.y + rectangle.height - 1, 5, 4, true);
            Polygon polygon = new Polygon();
            for (Point object : list) {
                polygon.addPoint(object.x, object.y);
            }
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
            graphics2D.draw(polygon);
            graphics2D.fill(polygon);
            point = new Point(rectangle2.x - (n6 -= 3), rectangle2.y);
            list = UIUtilities.getBrokenTapePoints(point, rectangle2.y + rectangle2.height - 1, 5, 4, false);
            Polygon polygon2 = new Polygon();
            for (Point point2 : list) {
                polygon2.addPoint(point2.x, point2.y);
            }
            polygon2.addPoint(rectangle2.x, rectangle2.y + rectangle2.height - 1);
            polygon2.addPoint(rectangle2.x, rectangle2.y);
            graphics2D.draw(polygon2);
            graphics2D.fill(polygon2);
        }
        graphics2D.setColor(color2);
    }

    @Override
    public void accept(UIVisitor uIVisitor) {
        uIVisitor.visit(this);
    }
}

