/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.NBGlassPaneAccessSupport;
import org.netbeans.modules.xml.schema.abe.StartTagPanel;
import org.netbeans.modules.xml.schema.abe.TranslucentLabel;
import org.netbeans.modules.xml.schema.abe.TweenerListener;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;

public class TweenerPanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    private TranslucentLabel dropInfoLabel = new TranslucentLabel(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/schema/abe/resources/bulb.png")));
    private static final int HBAR_NOMINAL_WIDTH = 500;
    private static final int HBAR_MAX_HEIGHT = 2;
    private static final int VBAR_MAX_WIDTH = 10;
    private static final int VBAR_NOMINAL_HEIGHT = StartTagPanel.getTagHeight();
    private static final int PADDING = 3;
    private static final int EXPAND_FACTOR = 3;
    List<TweenerListener> tweenerListeners = new ArrayList<TweenerListener>();
    private int orientation;
    private boolean active;
    private String dropInfoText;

    public TweenerPanel(int n, InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
        this.orientation = n;
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        if (this.getOrientation() == 0) {
            this._setSize(500, 2);
        } else {
            this._setSize(10, VBAR_NOMINAL_HEIGHT);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void _setSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
        this.setMinimumSize(new Dimension(n, n2));
        this.setMaximumSize(new Dimension(n, n2));
        this.revalidate();
    }

    protected void handleActive(boolean bl) {
        boolean bl2 = this.active;
        if (bl2 != bl) {
            this.active = bl;
            if (!this.active) {
                this.removeDropInfoLabel();
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics2D);
        if (this.isActive()) {
            if (this.getOrientation() == 0) {
                boolean bl = false;
                int n = this.getHeight() / 2 - 1;
                int n2 = this.getVisibleRect().width;
                graphics2D.setColor(Color.BLACK);
                int n3 = 3;
                int n4 = n2 - 3;
                graphics2D.drawLine(n3, n - 2, n3, n + 3);
                graphics2D.drawLine(n3 + 1, n - 1, n3 + 1, n + 2);
                graphics2D.drawLine(n4, n - 2, n4, n + 3);
                graphics2D.drawLine(n4 - 1, n - 1, n4 - 1, n + 2);
                graphics2D.drawLine(n3, n, n4, n);
                graphics2D.drawLine(n3, n + 1, n4, n + 1);
            } else {
                int n = this.getWidth() / 2 - 1;
                int n5 = this.getHeight();
                graphics2D.setColor(Color.BLACK);
                int n6 = 3;
                int n7 = n5 - 12;
                graphics2D.drawLine(n - 2, n6, n + 3, n6);
                graphics2D.drawLine(n - 1, n6 + 1, n + 2, n6 + 1);
                graphics2D.drawLine(n - 2, n7, n + 3, n7);
                graphics2D.drawLine(n - 1, n7 - 1, n + 2, n7 - 1);
                graphics2D.drawLine(n, n6, n, n7);
                graphics2D.drawLine(n + 1, n6, n + 1, n7);
            }
        }
    }

    public void addTweenerListener(TweenerListener tweenerListener) {
        this.tweenerListeners.add(tweenerListener);
    }

    private void showExpanded() {
        Dimension dimension = new Dimension(500, 6);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.revalidate();
    }

    private void showCollapsed() {
        Dimension dimension = new Dimension(500, 2);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.context.setUserInducedEventMode(true);
        try {
            for (TweenerListener tweenerListener : this.tweenerListeners) {
                if (tweenerListener.dragAccept(DnDHelper.getDraggedPaletteItem(dropTargetDropEvent))) continue;
                dropTargetDropEvent.rejectDrop();
                return;
            }
            for (TweenerListener tweenerListener : this.tweenerListeners) {
                tweenerListener.drop(DnDHelper.getDraggedPaletteItem(dropTargetDropEvent));
            }
            if (this.orientation == 0) {
                this.showCollapsed();
                for (TweenerListener tweenerListener : this.tweenerListeners) {
                    tweenerListener.dragExited();
                }
            }
        }
        finally {
            this.context.setUserInducedEventMode(false);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.orientation == 0) {
            this.showCollapsed();
        }
        for (TweenerListener tweenerListener : this.tweenerListeners) {
            tweenerListener.dragExited();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.orientation == 0) {
            this.showExpanded();
        }
        for (TweenerListener tweenerListener : this.tweenerListeners) {
            if (tweenerListener.dragAccept(DnDHelper.getDraggedPaletteItem(dropTargetDragEvent))) continue;
            dropTargetDragEvent.rejectDrag();
            return;
        }
        for (TweenerListener tweenerListener : this.tweenerListeners) {
            tweenerListener.dragEntered(DnDHelper.getDraggedPaletteItem(dropTargetDragEvent));
        }
        this.addDropInfoLabel();
    }

    private void addDropInfoLabel() {
        String string = this.getDropInfoText();
        if (string != null) {
            UIUtilities.showBulbMessageFor(string, this.context, this);
        }
    }

    private void removeDropInfoLabel() {
        NBGlassPaneAccessSupport.disposeNBGlassPane();
    }

    public String getDropInfoText() {
        return this.dropInfoText;
    }

    public void setDropInfoText(String string) {
        this.dropInfoText = string;
    }

    public void accept(UIVisitor uIVisitor) {
    }
}

