/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.wizard;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.schema.abe.wizard.SchemaTransformPatternSelectionUI;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTransformPatternSelection
implements WizardDescriptor.Panel,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final long file_size_warning = 524288L;
    SchemaGenerator.Pattern inferedPattern;
    RequestProcessor.Task transformTask = null;
    HashMap<SchemaGenerator.Pattern, SchemaGeneratorFactory.TransformHint> hintMap = new HashMap();
    List<Element> ges = null;
    private SchemaTransformPatternSelectionUI component;
    private WizardDescriptor wizard = null;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SchemaTransformPatternSelection(SchemaGenerator.Pattern pattern) {
        this.inferedPattern = pattern;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new SchemaTransformPatternSelectionUI(this.inferedPattern);
            this.component.addChangeListener(this);
            this.transformTask = RequestProcessor.getDefault().create(new Runnable(){

                public void run() {
                    try {
                        SchemaTransformPatternSelection.this.isValid();
                    }
                    catch (Throwable throwable) {
                        SchemaTransformPatternSelection.this.transformTask.schedule(300);
                    }
                }
            });
            this.transformTask.schedule(200);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SchemaTransformPatternSelection.class);
    }

    public boolean isValid() {
        SchemaModel schemaModel = (SchemaModel)this.wizard.getProperty("schemaModelKey");
        SchemaGenerator.Pattern pattern = (SchemaGenerator.Pattern)this.wizard.getProperty("inferedDesignPatternKey");
        SchemaGenerator.Pattern pattern2 = (SchemaGenerator.Pattern)this.wizard.getProperty("selectedDesignPatternKey");
        if (pattern != null && pattern2 != null) {
            SchemaGeneratorFactory.TransformHint transformHint = SchemaGeneratorFactory.TransformHint.OK;
            try {
                if (this.ges == null) {
                    this.ges = SchemaGeneratorFactory.getDefault().findMasterGlobalElements(AXIModelFactory.getDefault().getModel(schemaModel));
                }
                transformHint = this.canTransformSchema(schemaModel, pattern, pattern2, this.ges);
            }
            catch (Throwable throwable) {
                transformHint = SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA;
            }
            if (transformHint != SchemaGeneratorFactory.TransformHint.OK) {
                if (pattern == pattern2 || transformHint == SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA || transformHint == SchemaGeneratorFactory.TransformHint.NO_GLOBAL_ELEMENTS || transformHint == SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS || transformHint == SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ATTRIBUTES || transformHint == SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS_AND_ATTRIBUTES || transformHint == SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_GRAND_CHILDREN) {
                    this.setErrorMessage("MSG_SchemaTransform_Error_" + transformHint.toString(), new Object[]{NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + pattern2.toString()))});
                    return false;
                }
                if (transformHint == SchemaGeneratorFactory.TransformHint.CANNOT_REMOVE_GLOBAL_ELEMENTS) {
                    SchemaGenerator.Pattern pattern3 = SchemaGenerator.Pattern.SALAMI_SLICE;
                    if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
                        pattern3 = SchemaGenerator.Pattern.GARDEN_OF_EDEN;
                    }
                    this.setErrorMessage("MSG_SchemaTransform_Error_" + transformHint.toString(), new Object[]{NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + pattern2.toString())), NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + pattern3.toString()))});
                    return false;
                }
                String string = "";
                if (this.canAddPerformanceWarning()) {
                    string = NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)"MSG_SchemaTransform_Warning_BIG_SCHEMA");
                }
                String string2 = "MSG_SchemaTransform_Warning_" + transformHint.toString();
                this.setErrorMessage(string2, new Object[]{NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + pattern2.toString())), string});
                return true;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private SchemaGeneratorFactory.TransformHint canTransformSchema(SchemaModel schemaModel, SchemaGenerator.Pattern pattern, SchemaGenerator.Pattern pattern2, List<Element> list) {
        SchemaGeneratorFactory.TransformHint transformHint = this.hintMap.get(pattern2);
        if (transformHint == null) {
            transformHint = SchemaGeneratorFactory.getDefault().canTransformSchema(schemaModel, pattern, pattern2, list);
            this.hintMap.put(pattern2, transformHint);
        }
        return transformHint;
    }

    private void setErrorMessage(String string) {
        if (string == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(SchemaTransformPatternSelection.class, (String)string));
        }
    }

    private void setErrorMessage(String string, Object[] objectArray) {
        if (string == null) {
            this.setLocalizedErrorMessage("");
        } else {
            this.setLocalizedErrorMessage(NbBundle.getMessage(SchemaTransformPatternSelection.class, (String)string, (Object[])objectArray));
        }
    }

    private boolean canAddPerformanceWarning() {
        SchemaGenerator.Pattern pattern = (SchemaGenerator.Pattern)this.wizard.getProperty("selectedDesignPatternKey");
        if (pattern != SchemaGenerator.Pattern.SALAMI_SLICE) {
            return false;
        }
        SchemaModel schemaModel = (SchemaModel)this.wizard.getProperty("schemaModelKey");
        FileObject fileObject = (FileObject)schemaModel.getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return file.length() > 524288L;
    }

    private void setLocalizedErrorMessage(String string) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        Boolean bl;
        this.wizard = (WizardDescriptor)object;
        Boolean bl2 = (Boolean)this.wizard.getProperty("singleGlobalElementKey");
        if (bl2 != null) {
            this.component.setSingleGlobalElementSelected(bl2);
        }
        if ((bl = (Boolean)this.wizard.getProperty("typeReuseKey")) != null) {
            this.component.setTypeReuseSelected(bl);
        }
    }

    public void storeSettings(Object object) {
        this.wizard = (WizardDescriptor)object;
        this.wizard.putProperty("singleGlobalElementKey", (Object)this.component.isSingleGlobalElementSelected());
        this.wizard.putProperty("typeReuseKey", (Object)this.component.isTypeReuseSelected());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizard != null) {
            this.wizard.putProperty("selectedDesignPatternKey", (Object)this.component.getSelectedDesignPattern());
        }
        this.fireChangeEvent();
    }
}

