/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.schema.abe.wizard.SchemaTransformPatternSelection;
import org.netbeans.modules.xml.schema.abe.wizard.SchemaTransformProgressPanel;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SchemaTransformWizard
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final String SINGLE_GLOBAL_ELEMENT_KEY = "singleGlobalElementKey";
    public static final String TYPE_REUSE_KEY = "typeReuseKey";
    public static final String INFERED_DESIGN_PATTERN_KEY = "inferedDesignPatternKey";
    public static final String SELECTED_DESIGN_PATTERN_KEY = "selectedDesignPatternKey";
    public static final String SCHEMA_MODEL_KEY = "schemaModelKey";
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wizard;
    private RequestProcessor.Task transformTask;
    private SchemaTransformProgressPanel progressPanel = new SchemaTransformProgressPanel();
    private SchemaModel sm;
    private String fileName;
    private boolean isCancelled;
    private boolean finishTransform;

    public SchemaTransformWizard(SchemaModel schemaModel) {
        this.sm = schemaModel;
        FileObject fileObject = (FileObject)schemaModel.getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.fileName = fileObject.getNameExt();
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            SchemaGenerator.Pattern pattern = this.inferSchemaDesignPattern();
            this.panels = new WizardDescriptor.Panel[]{new SchemaTransformPatternSelection(pattern)};
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public SchemaGenerator.Pattern show() {
        boolean bl;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        this.initialize(wizardDescriptor);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(SchemaTransformWizard.class, (String)"TITLE_SchemaTransform"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaTransformWizard.class, (String)"TITLE_SchemaTransform"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaTransformWizard.class, (String)"HINT_SchemaTransform"));
        dialog.setVisible(true);
        dialog.toFront();
        final SchemaGenerator.Pattern pattern = (SchemaGenerator.Pattern)this.wizard.getProperty(SELECTED_DESIGN_PATTERN_KEY);
        this.isCancelled = bl = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            this.transformTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SchemaGeneratorFactory.getDefault().transformSchema(SchemaTransformWizard.this.sm, pattern);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    finally {
                        SchemaTransformWizard.this.finishTransform = true;
                        SchemaTransformWizard.this.finishProgress();
                    }
                }
            });
            this.transformTask.schedule(50);
            this.finishTransform = false;
            this.startProgress(NbBundle.getMessage(SchemaTransformWizard.class, (String)"MSG_SchemaTransform_ProgressMessage", (Object)this.fileName));
        }
        return pattern;
    }

    private void startProgress(String string) {
        DialogDescriptor dialogDescriptor = null;
        while (!this.finishTransform) {
            this.progressPanel.hideDialog();
            dialogDescriptor = this.progressPanel.createDialog(this.fileName);
            this.progressPanel.showDialog(this.fileName);
        }
    }

    private void finishProgress() {
        this.progressPanel.hideDialog();
    }

    private SchemaGenerator.Pattern inferSchemaDesignPattern() {
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(this.sm);
        SchemaGenerator.Pattern pattern = SchemaGeneratorFactory.getDefault().inferDesignPattern(aXIModel);
        if (pattern == null) {
            pattern = SchemaGenerator.DEFAULT_DESIGN_PATTERN;
        }
        return pattern;
    }

    private void selectInitialDesignPattern(WizardDescriptor wizardDescriptor, SchemaGenerator.Pattern pattern) {
        if (pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            wizardDescriptor.putProperty(SINGLE_GLOBAL_ELEMENT_KEY, (Object)true);
            wizardDescriptor.putProperty(TYPE_REUSE_KEY, (Object)false);
        } else if (pattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            wizardDescriptor.putProperty(SINGLE_GLOBAL_ELEMENT_KEY, (Object)true);
            wizardDescriptor.putProperty(TYPE_REUSE_KEY, (Object)true);
        } else if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            wizardDescriptor.putProperty(SINGLE_GLOBAL_ELEMENT_KEY, (Object)false);
            wizardDescriptor.putProperty(TYPE_REUSE_KEY, (Object)false);
        } else if (pattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            wizardDescriptor.putProperty(SINGLE_GLOBAL_ELEMENT_KEY, (Object)false);
            wizardDescriptor.putProperty(TYPE_REUSE_KEY, (Object)true);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Set instantiate() throws IOException {
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        SchemaGenerator.Pattern pattern = this.inferSchemaDesignPattern();
        wizardDescriptor.putProperty(SCHEMA_MODEL_KEY, (Object)this.sm);
        wizardDescriptor.putProperty(SELECTED_DESIGN_PATTERN_KEY, (Object)pattern);
        wizardDescriptor.putProperty(INFERED_DESIGN_PATTERN_KEY, (Object)pattern);
        this.selectInitialDesignPattern(wizardDescriptor, pattern);
        this.wizard = wizardDescriptor;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

