/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.netbeans.modules.java.debug.TreeNavigatorJavaSourceFactory;
import org.netbeans.modules.java.debug.TreeNode;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TreeNavigatorProviderImpl
implements NavigatorPanel {
    private JComponent panel;
    private final ExplorerManager manager = new ExplorerManager();
    private static final AttributeSet HIGHLIGHT = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(224, 224, 224)});
    private static final AttributeSet HIGHLIGHT_PREF = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, new Color(30, 255, 0)});

    public TreeNavigatorProviderImpl() {
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    TreeNavigatorProviderImpl.setHighlights(TreeNavigatorJavaSourceFactory.getInstance().getFile(), TreeNavigatorProviderImpl.this.manager);
                }
            }
        });
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TreeNavigatorProviderImpl.class, (String)"NM_Trees");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(TreeNavigatorProviderImpl.class, (String)"SD_Trees");
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            final BeanTreeView beanTreeView = new BeanTreeView();
            beanTreeView.setRootVisible(true);
            beanTreeView.setSelectionMode(0);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                private final Lookup lookup;

                Panel() {
                    this.lookup = ExplorerUtils.createLookup((ExplorerManager)TreeNavigatorProviderImpl.this.manager, (ActionMap)new ActionMap());
                    this.setLayout(new BorderLayout());
                    this.add((Component)beanTreeView, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return TreeNavigatorProviderImpl.this.manager;
                }

                public Lookup getLookup() {
                    return this.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public Lookup getLookup() {
        return null;
    }

    public void panelActivated(Lookup lookup) {
        TreeNavigatorJavaSourceFactory.getInstance().setLookup(lookup, new TaskImpl());
    }

    public void panelDeactivated() {
        TreeNavigatorJavaSourceFactory.getInstance().setLookup(Lookup.EMPTY, null);
    }

    static OffsetsBag getBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(TreeNavigatorProviderImpl.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(TreeNavigatorProviderImpl.class, offsetsBag);
        }
        return offsetsBag;
    }

    static void setHighlights(FileObject fileObject, ExplorerManager explorerManager) {
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                return;
            }
            OffsetsBag offsetsBag = new OffsetsBag((Document)styledDocument, true);
            for (Node node : explorerManager.getSelectedNodes()) {
                if (!(node instanceof OffsetProvider)) continue;
                OffsetProvider offsetProvider = (OffsetProvider)node;
                int n = offsetProvider.getStart();
                int n2 = offsetProvider.getEnd();
                int n3 = offsetProvider.getPreferredPosition();
                if (n >= 0 && n2 >= 0) {
                    offsetsBag.addHighlight(n, n2, HIGHLIGHT);
                }
                if (n3 < 0) continue;
                offsetsBag.addHighlight(n3, n3 + 1, HIGHLIGHT_PREF);
            }
            TreeNavigatorProviderImpl.getBag(styledDocument).setHighlights(offsetsBag);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(TreeNavigatorProviderImpl.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TaskImpl
    implements CancellableTask<CompilationInfo> {
        private TaskImpl() {
        }

        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) {
            TreeNavigatorProviderImpl.this.manager.setRootContext(TreeNode.getTree(compilationInfo, new TreePath(compilationInfo.getCompilationUnit())));
        }
    }
}

