/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.spi.SaasClientCodeGenerationProvider;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SaasClientCodeGenerator
implements SaasClientCodeGenerationProvider {
    public static final String REST_CONNECTION = "RestConnection";
    public static final String REST_RESPONSE = "RestResponse";
    public static final String REST_CONNECTION_PACKAGE = "org.netbeans.saas";
    public static final String SAAS_SERVICES = "SaaSServices";
    public static final String TEMPLATES_SAAS = "Templates/SaaSServices/";
    public static final String REST_CONNECTION_TEMPLATE = "Templates/SaaSServices/RestConnection.java";
    public static final String REST_RESPONSE_TEMPLATE = "Templates/SaaSServices/RestResponse.java";
    public static final String COMMENT_END_OF_HTTP_MEHTOD_GET = "TODO return proper representation object";
    public static final String GENERIC_REF_CONVERTER_TEMPLATE = "Templates/SaaSServices/RefConverter.java";
    public static final String GENERIC_REF_CONVERTER = "GenericRefConverter";
    public static final String CONVERTER_SUFFIX = "Converter";
    public static final String CONVERTER_FOLDER = "converter";
    public static final String RESOURCE_SUFFIX = "Resource";
    private FileObject targetFile;
    private FileObject destDir;
    private Project project;
    private SaasBean bean;
    private Document targetDocument;
    private int start = 0;
    private int end = 0;
    private ProgressHandle pHandle;
    private int totalWorkUnits;
    private int workUnits;
    private Constants.DropFileType dropFileType;
    private int precedence;

    protected Document getTargetDocument() {
        return this.targetDocument;
    }

    protected FileObject getTargetFile() {
        return this.targetFile;
    }

    protected FileObject getTargetFolder() {
        return this.destDir;
    }

    protected Project getProject() {
        return this.project;
    }

    public int getStartPosition() {
        return this.start;
    }

    public void setStartPosition(int n) {
        this.start = n;
    }

    public int getEndPosition() {
        return this.end;
    }

    public void setEndPosition(int n) {
        this.end = n;
    }

    public Constants.DropFileType getDropFileType() {
        return this.dropFileType;
    }

    public void setDropFileType(Constants.DropFileType dropFileType) {
        this.dropFileType = dropFileType;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    public void initProgressReporting(ProgressHandle progressHandle) {
        this.initProgressReporting(progressHandle, true);
    }

    public void initProgressReporting(ProgressHandle progressHandle, boolean bl) {
        this.pHandle = progressHandle;
        this.totalWorkUnits = this.getTotalWorkUnits();
        this.workUnits = 0;
        if (progressHandle != null && bl) {
            if (this.totalWorkUnits > 0) {
                progressHandle.start(this.totalWorkUnits);
            } else {
                progressHandle.start();
            }
        }
    }

    public void reportProgress(String string) {
        if (this.pHandle != null) {
            if (this.totalWorkUnits > 0) {
                this.pHandle.progress(string, ++this.workUnits);
            } else {
                this.pHandle.progress(string);
            }
        }
    }

    public void finishProgressReporting() {
        if (this.pHandle != null) {
            this.pHandle.finish();
        }
    }

    public int getTotalWorkUnits() {
        return 0;
    }

    protected ProgressHandle getProgressHandle() {
        return this.pHandle;
    }

    @Override
    public abstract boolean canAccept(SaasMethod var1, Document var2);

    @Override
    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        FileObject[] fileObjectArray = new FileObject[]{this.getTargetFile()};
        this.finishProgressReporting();
        return new HashSet<FileObject>(Arrays.asList(fileObjectArray));
    }

    @Override
    public void init(SaasMethod saasMethod, Document document) throws IOException {
        if (document == null) {
            throw new IOException("Cannot generate, target document is null.");
        }
        this.targetDocument = document;
        this.targetFile = NbEditorUtilities.getFileObject((Document)this.targetDocument);
        this.destDir = this.targetFile.getParent();
        this.project = FileOwnerQuery.getOwner((FileObject)this.targetFile);
        if (this.project == null) {
            throw new IllegalArgumentException(this.targetFile.getPath() + " is not part of a project.");
        }
    }

    protected void preGenerate() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String string, File file) throws IOException {
        String string2 = string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = this.getClass().getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected abstract String getCustomMethodBody() throws IOException;

    public SaasBean getBean() {
        return this.bean;
    }

    public void setBean(SaasBean saasBean) {
        this.bean = saasBean;
    }

    private String getParamList() {
        List<ParameterInfo> list = this.bean.filterParametersByAuth(this.bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            ParameterInfo parameterInfo = list.get(i);
            string = i == 0 ? string + this.getParameterName(parameterInfo, true, true, true) : string + ", " + this.getParameterName(parameterInfo, true, true, true);
        }
        return string;
    }

    protected void insert(String string, boolean bl) throws BadLocationException {
        Document document = this.getTargetDocument();
        if (document == null) {
            return;
        }
        if (string == null) {
            return;
        }
        this.insert(string, this.getStartPosition(), this.getEndPosition(), document);
    }

    protected int insert(String string, int n, int n2, Document document) throws BadLocationException {
        try {
            document.remove(n, n2 - n);
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }

    protected boolean isInBlock(Document document) {
        return true;
    }

    protected String[] getGetParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.getParamNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getGetParamTypes(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.getParamTypeNames(list)));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getParamNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(this.getParameterName(parameterInfo, true, true, true));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String[] getParamTypeNames(List<ParameterInfo> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : list) {
            arrayList.add(parameterInfo.getTypeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String getParameterName(ParameterInfo parameterInfo) {
        return Util.getParameterName(parameterInfo);
    }

    protected String getParameterName(ParameterInfo parameterInfo, boolean bl, boolean bl2) {
        return Util.getParameterName(parameterInfo, bl, bl2, false);
    }

    protected String getParameterName(ParameterInfo parameterInfo, boolean bl, boolean bl2, boolean bl3) {
        return Util.getParameterName(parameterInfo, bl, bl2, bl3);
    }

    protected String getVariableName(String string) {
        return Util.getVariableName(string, true, true, true);
    }

    protected String getVariableName(String string, boolean bl, boolean bl2, boolean bl3) {
        return Util.getVariableName(string, bl, bl2, bl3);
    }

    protected Object[] getParamValues(List<ParameterInfo> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ParameterInfo parameterInfo : list) {
            Object object = null;
            if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.QUERY) {
                object = parameterInfo.getDefaultValue();
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public void setDropLocation(JTextComponent jTextComponent) {
        Caret caret = jTextComponent.getCaret();
        this.setStartPosition(Math.min(caret.getDot(), caret.getMark()));
        this.setEndPosition(Math.max(caret.getDot(), caret.getMark()));
    }
}

