/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Authenticator;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.Params;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.Sign;
import org.netbeans.modules.websvc.saas.model.jaxb.UseGenerator;
import org.netbeans.modules.websvc.saas.model.jaxb.UseTemplates;
import org.netbeans.modules.websvc.saas.util.SaasUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SaasBean
extends GenericResourceBean {
    public static final String RESOURCE_TEMPLATE = "Templates/SaaSServices/WrapperResource.java";
    private String outputWrapperName;
    private String wrapperPackageName;
    private List<ParameterInfo> inputParams;
    private List<ParameterInfo> headerParams;
    private List<ParameterInfo> templateParams;
    private List<ParameterInfo> queryParams;
    private String resourceTemplate;
    private Constants.SaasAuthenticationType authType;
    private SaasAuthentication auth;
    private boolean isDropTargetWeb = false;
    private String groupName;
    private String displayName;
    private Saas saas;

    public SaasBean(Saas saas, String string, String string2, String string3, Constants.MimeType[] mimeTypeArray, String[] stringArray, Constants.HttpMethodType[] httpMethodTypeArray) {
        super(string, string2, string3, mimeTypeArray, stringArray, httpMethodTypeArray);
        this.saas = saas;
        SaasGroup saasGroup = saas.getParentGroup();
        if (saasGroup.getParent() == null) {
            saasGroup = saas.getTopLevelGroup();
        }
        this.groupName = Util.normailizeName(saasGroup.getName());
        this.displayName = Util.normailizeName(saas.getDisplayName());
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSaasName() {
        return this.getGroupName() + this.getDisplayName();
    }

    public String getSaasServiceName() {
        return this.getGroupName() + this.getDisplayName();
    }

    public String getSaasServicePackageName() {
        return "org.netbeans.saas." + SaasUtil.toValidJavaName((String)this.getGroupName()).toLowerCase();
    }

    public String getAuthenticatorClassName() {
        return Util.getAuthenticatorClassName(this.getSaasName());
    }

    public String getAuthorizationFrameClassName() {
        return Util.getAuthorizationFrameClassName(this.getSaasName());
    }

    public boolean isDropTargetWeb() {
        return this.isDropTargetWeb;
    }

    public void setIsDropTargetWeb(boolean bl) {
        this.isDropTargetWeb = bl;
    }

    protected void setInputParameters(List<ParameterInfo> list) {
        this.inputParams = list;
    }

    @Override
    public List<ParameterInfo> getInputParameters() {
        if (this.inputParams == null) {
            this.inputParams = this.initInputParameters();
        }
        return this.inputParams;
    }

    public List<ParameterInfo> getHeaderParameters() {
        if (this.headerParams == null) {
            this.headerParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo parameterInfo : this.getInputParameters()) {
                if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.HEADER) continue;
                this.headerParams.add(parameterInfo);
            }
        }
        return this.headerParams;
    }

    @Override
    public String[] getUriParams() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterInfo parameterInfo : this.getTemplateParameters()) {
            arrayList.add(parameterInfo.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public List<ParameterInfo> getTemplateParameters() {
        if (this.templateParams == null) {
            this.templateParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo parameterInfo : this.getInputParameters()) {
                if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.TEMPLATE) continue;
                this.templateParams.add(parameterInfo);
            }
        }
        return this.templateParams;
    }

    protected void setTemplateParameters(List<ParameterInfo> list) {
        this.templateParams = list;
    }

    protected abstract List<ParameterInfo> initInputParameters();

    @Override
    public List<ParameterInfo> getQueryParameters() {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<ParameterInfo>();
            for (ParameterInfo parameterInfo : this.getInputParameters()) {
                if (parameterInfo.getStyle() != ParameterInfo.ParamStyle.QUERY) continue;
                this.queryParams.add(parameterInfo);
            }
        }
        return this.queryParams;
    }

    public String getOutputWrapperName() {
        if (this.outputWrapperName == null) {
            this.outputWrapperName = this.getName();
            if (this.outputWrapperName.endsWith("Resource")) {
                this.outputWrapperName = this.outputWrapperName.substring(0, this.outputWrapperName.length() - 8);
            }
            this.outputWrapperName = this.outputWrapperName + "Converter";
        }
        return this.outputWrapperName;
    }

    public void setOutputWrapperName(String string) {
        this.outputWrapperName = string;
    }

    public String getOutputWrapperPackageName() {
        return this.wrapperPackageName;
    }

    public void setOutputWrapperPackageName(String string) {
        this.wrapperPackageName = string;
    }

    @Override
    public String[] getRepresentationTypes() {
        if (this.getMimeTypes().length == 1 && this.getMimeTypes()[0] == Constants.MimeType.HTML) {
            return new String[]{String.class.getName()};
        }
        String string = this.getOutputWrapperPackageName() + "." + this.getOutputWrapperName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Constants.MimeType mimeType : this.getMimeTypes()) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getOutputTypes() {
        String[] stringArray = new String[]{"java.lang.String"};
        return stringArray;
    }

    public String getResourceClassTemplate() {
        return this.resourceTemplate;
    }

    protected void setResourceClassTemplate(String string) {
        this.resourceTemplate = string;
    }

    @Override
    public Constants.SaasAuthenticationType getAuthenticationType() {
        return this.authType;
    }

    public void setAuthenticationType(Constants.SaasAuthenticationType saasAuthenticationType) {
        this.authType = saasAuthenticationType;
    }

    @Override
    public SaasAuthentication getAuthentication() {
        return this.auth;
    }

    public void setAuthentication(SaasAuthentication saasAuthentication) {
        this.auth = saasAuthentication;
    }

    private SaasAuthentication.UseGenerator.Method createSessionKeyUseGeneratorMethod(Method method, SaasAuthentication.UseGenerator useGenerator) {
        if (method != null) {
            SaasAuthentication.UseGenerator.Method method2 = useGenerator.createMethod();
            method2.setId(method.getId());
            method2.setName(method.getName());
            method2.setHref(method.getHref());
            return method2;
        }
        return null;
    }

    private List<ParameterInfo> findSignParameters(Sign sign) {
        Params params;
        if (sign != null && (params = sign.getParams()) != null && params.getParam() != null) {
            ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
            this.findSaasParams(arrayList, params.getParam());
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected Object getSignedUrl(SaasMetadata.Authentication authentication) {
        return null;
    }

    protected Object getSessionKey(SaasMetadata.Authentication authentication) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void findAuthentication(SaasMethod saasMethod) throws IOException {
        SaasMetadata.Authentication authentication = saasMethod.getSaas().getSaasMetadata().getAuthentication();
        if (authentication == null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.PLAIN);
            return;
        }
        if (authentication.getHttpBasic() != null) {
            SaasMetadata.Authentication.HttpBasic httpBasic = authentication.getHttpBasic();
            this.setAuthenticationType(Constants.SaasAuthenticationType.HTTP_BASIC);
            HttpBasicAuthentication httpBasicAuthentication = new HttpBasicAuthentication(httpBasic.getUsername(), httpBasic.getPassword());
            this.setAuthentication(httpBasicAuthentication);
            SaasAuthentication.UseGenerator useGenerator = httpBasicAuthentication.createUseGenerator();
            SaasAuthentication.UseTemplates useTemplates = httpBasicAuthentication.createUseTemplates();
            if (this.findUseGenerator(saasMethod, httpBasic.getAuthenticator(), useGenerator)) {
                httpBasicAuthentication.setUseGenerator(useGenerator);
                return;
            } else {
                if (!this.findUseTemplates(saasMethod, httpBasic.getAuthenticator(), useTemplates)) throw new IOException("authentication element has no use-generator or use-templates children.");
                httpBasicAuthentication.setUseTemplates(useTemplates);
            }
            return;
        } else if (authentication.getCustom() != null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.CUSTOM);
            this.setAuthentication(new CustomAuthentication());
            return;
        } else if (authentication.getApiKey() != null) {
            this.setAuthenticationType(Constants.SaasAuthenticationType.API_KEY);
            this.setAuthentication(new ApiKeyAuthentication(authentication.getApiKey().getId()));
            return;
        } else if (authentication.getSignedUrl() != null && authentication.getSignedUrl().size() > 0) {
            Params params;
            this.setAuthenticationType(Constants.SaasAuthenticationType.SIGNED_URL);
            List list = authentication.getSignedUrl();
            SaasMetadata.Authentication.SignedUrl signedUrl = (SaasMetadata.Authentication.SignedUrl)this.getSignedUrl(authentication);
            if (signedUrl == null) {
                signedUrl = (SaasMetadata.Authentication.SignedUrl)list.get(0);
            }
            SignedUrlAuthentication signedUrlAuthentication = new SignedUrlAuthentication();
            if (signedUrl.getSigId() != null) {
                signedUrlAuthentication.setSigKeyName(signedUrl.getSigId());
            }
            this.setAuthentication(signedUrlAuthentication);
            Sign sign = signedUrl.getSign();
            if (sign == null || (params = sign.getParams()) == null || params.getParam() == null) return;
            ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
            this.findSaasParams(arrayList, params.getParam());
            signedUrlAuthentication.setParameters(arrayList);
            return;
        } else if (authentication.getSessionKey() != null && authentication.getSessionKey().size() > 0) {
            Object object;
            Params params;
            List list = authentication.getSessionKey();
            SaasMetadata.Authentication.SessionKey sessionKey = (SaasMetadata.Authentication.SessionKey)this.getSessionKey(authentication);
            if (sessionKey == null) {
                sessionKey = (SaasMetadata.Authentication.SessionKey)list.get(0);
            }
            this.setAuthenticationType(Constants.SaasAuthenticationType.SESSION_KEY);
            SessionKeyAuthentication sessionKeyAuthentication = new SessionKeyAuthentication(sessionKey.getApiId(), sessionKey.getSessionId(), sessionKey.getSigId());
            this.setAuthentication(sessionKeyAuthentication);
            Sign sign = sessionKey.getSign();
            if (sign != null && (params = sign.getParams()) != null && params.getParam() != null) {
                object = new ArrayList();
                this.findSaasParams((List<ParameterInfo>)object, params.getParam());
                sessionKeyAuthentication.setParameters((List<ParameterInfo>)object);
            }
            SaasAuthentication.UseGenerator useGenerator = sessionKeyAuthentication.createUseGenerator();
            object = sessionKeyAuthentication.createUseTemplates();
            if (this.findUseGenerator(saasMethod, sessionKey.getAuthenticator(), useGenerator)) {
                sessionKeyAuthentication.setUseGenerator(useGenerator);
                return;
            } else {
                if (!this.findUseTemplates(saasMethod, sessionKey.getAuthenticator(), (SaasAuthentication.UseTemplates)object)) throw new IOException("authentication element has no use-generator or use-templates children.");
                sessionKeyAuthentication.setUseTemplates((SaasAuthentication.UseTemplates)object);
            }
            return;
        } else {
            this.setAuthenticationType(Constants.SaasAuthenticationType.PLAIN);
        }
    }

    private boolean findUseGenerator(SaasMethod saasMethod, Authenticator authenticator, SaasAuthentication.UseGenerator useGenerator) throws IOException {
        if (authenticator == null) {
            throw new IOException("No authentication element inside sessionkey element in saas-metadata.");
        }
        if (authenticator.getUseGenerator() != null) {
            Object object;
            SaasAuthentication.UseGenerator.Login login;
            UseGenerator useGenerator2 = authenticator.getUseGenerator();
            Sign sign = null;
            UseGenerator.Login login2 = useGenerator2.getLogin();
            if (login2 != null) {
                login = useGenerator.createLogin();
                useGenerator.setLogin(login);
                sign = login2.getSign();
                if (sign != null) {
                    login.setSignId(sign.getId());
                    login.setParameters(this.findSignParameters(sign));
                }
                login.setMethod(this.createSessionKeyUseGeneratorMethod(login2.getMethod(), useGenerator));
            }
            if ((login = useGenerator2.getToken()) != null) {
                object = useGenerator.createToken(login.getId());
                useGenerator.setToken((SaasAuthentication.UseGenerator.Token)object);
                sign = login.getSign();
                if (sign != null) {
                    ((SaasAuthentication.UseGenerator.Login)object).setSignId(sign.getId());
                    ((SaasAuthentication.UseGenerator.Login)object).setParameters(this.findSignParameters(sign));
                }
                ((SaasAuthentication.UseGenerator.Login)object).setMethod(this.createSessionKeyUseGeneratorMethod(login.getMethod(), useGenerator));
            }
            object = useGenerator2.getLogout();
            return true;
        }
        return false;
    }

    private boolean findUseTemplates(SaasMethod saasMethod, Authenticator authenticator, SaasAuthentication.UseTemplates useTemplates) throws IOException {
        if (authenticator == null) {
            throw new IOException("No authentication element inside sessionkey element in saas-metadata.");
        }
        if (authenticator.getUseTemplates() != null) {
            UseTemplates useTemplates2 = authenticator.getUseTemplates();
            List list = null;
            if (!this.isDropTargetWeb() && useTemplates2.getDesktop() != null && useTemplates2.getDesktop().getTemplate() != null) {
                list = useTemplates2.getDesktop().getTemplate();
            } else if (this.isDropTargetWeb() && useTemplates2.getWeb() != null && useTemplates2.getWeb().getTemplate() != null) {
                list = useTemplates2.getWeb().getTemplate();
            }
            if (list == null || list.isEmpty()) {
                throw new IOException("WARN_UnsupportedDropTarget");
            }
            ArrayList<SaasAuthentication.UseTemplates.Template> arrayList = new ArrayList<SaasAuthentication.UseTemplates.Template>();
            Map<String, Map<String, String>> map = this.getArtifactTemplates(saasMethod);
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                String string = entry.getKey();
                Map<String, String> map2 = entry.getValue();
                for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                    String string2 = entry2.getKey();
                    String[] stringArray = entry2.getValue().split(":");
                    arrayList.add(useTemplates.createTemplate(string, string2, stringArray[0], stringArray[1]));
                }
            }
            useTemplates.setTemplates(arrayList);
            return true;
        }
        return false;
    }

    public boolean isUseTemplates() {
        return this.getAuthenticationType() == Constants.SaasAuthenticationType.SESSION_KEY && ((SessionKeyAuthentication)this.getAuthentication()).getUseTemplates() != null || this.getAuthenticationType() == Constants.SaasAuthenticationType.HTTP_BASIC && ((HttpBasicAuthentication)this.getAuthentication()).getUseTemplates() != null;
    }

    private Map<String, Map<String, String>> getArtifactTemplates(SaasMethod saasMethod) throws IOException {
        List list;
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        SaasMetadata.CodeGen codeGen = saasMethod.getSaas().getSaasMetadata().getCodeGen();
        if (codeGen != null && (list = codeGen.getArtifacts()) != null) {
            for (Artifacts artifacts : list) {
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                String string = artifacts.getTargets();
                List list2 = artifacts.getArtifact();
                if (list2 == null) continue;
                for (Artifact artifact : list2) {
                    String string2 = artifact.getId();
                    String string3 = artifact.getType();
                    if (string3 == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@type value is null.");
                    }
                    String string4 = artifact.getUrl();
                    if (string4 == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@url value is null.");
                    }
                    if (!string3.equals("template")) continue;
                    hashMap2.put(string2, string3 + ":" + string4);
                }
                hashMap.put(string, hashMap2);
            }
        }
        return hashMap;
    }

    public void findSaasParams(List<ParameterInfo> list, List<Params.Param> list2) {
        if (list2 != null) {
            for (Params.Param param : list2) {
                String string = param.getName();
                Class clazz = SaasBean.findJavaType(param.getType());
                ParameterInfo parameterInfo = new ParameterInfo(string, clazz);
                if (param.getId() != null && !param.getId().trim().equals("")) {
                    parameterInfo.setId(param.getId());
                }
                parameterInfo.setIsRequired(param.isRequired() != null ? param.isRequired() : false);
                parameterInfo.setFixed(param.getFixed());
                parameterInfo.setDefaultValue(param.getDefault());
                list.add(parameterInfo);
            }
        }
    }

    public static Class findJavaType(String string) {
        if (string != null) {
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (string.equalsIgnoreCase("string")) {
                return String.class;
            }
            if (string.equalsIgnoreCase("int")) {
                return Integer.class;
            }
            if (string.equalsIgnoreCase("date")) {
                return Date.class;
            }
            if (string.equalsIgnoreCase("time")) {
                return Time.class;
            }
            if (string.equalsIgnoreCase("httpMethod")) {
                return Constants.HttpMethodType.class;
            }
        }
        return String.class;
    }

    public void findSaasMediaType(List<Constants.MimeType> list, Method.Output.Media media) {
        String[] stringArray;
        String string = media.getType();
        for (String string2 : stringArray = string.split(",")) {
            Constants.MimeType mimeType = Constants.MimeType.find(string2);
            if (mimeType == null) continue;
            list.add(mimeType);
        }
    }

    public static boolean canAccept(SaasMethod saasMethod, Class clazz, Constants.DropFileType dropFileType) {
        List list;
        if (clazz == null || dropFileType == null) {
            throw new IllegalArgumentException("Argument classType or type is null");
        }
        if (!clazz.isInstance(saasMethod)) {
            return false;
        }
        SaasMetadata.CodeGen codeGen = saasMethod.getSaas().getSaasMetadata().getCodeGen();
        if (codeGen != null && (list = codeGen.getArtifacts()) != null) {
            for (Artifacts artifacts : list) {
                String[] stringArray;
                String string = artifacts.getTargets();
                if (string == null) continue;
                for (String string2 : stringArray = string.split(",")) {
                    if (!string2.equalsIgnoreCase(dropFileType.prefix())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getProfile(SaasMethod saasMethod, Constants.DropFileType dropFileType) {
        List list;
        SaasMetadata.CodeGen codeGen = saasMethod.getSaas().getSaasMetadata().getCodeGen();
        if (codeGen != null && (list = codeGen.getArtifacts()) != null) {
            for (Artifacts artifacts : list) {
                String[] stringArray;
                String string = artifacts.getTargets();
                if (string == null) continue;
                for (String string2 : stringArray = string.split(",")) {
                    if (!string2.equalsIgnoreCase(dropFileType.prefix())) continue;
                    return artifacts.getProfile();
                }
            }
        }
        return null;
    }

    public class CustomAuthentication
    extends SaasAuthentication {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionKeyAuthentication
    extends SaasAuthentication {
        private String apiId;
        private String sessionId;
        private String sig;
        private List<ParameterInfo> params;
        private SaasAuthentication.UseTemplates useTemplates;
        private SaasAuthentication.UseGenerator useGenerator;

        public SessionKeyAuthentication(String string, String string2, String string3) {
            this.params = Collections.emptyList();
            this.apiId = string;
            this.sessionId = string2;
            this.sig = string3;
        }

        public String getApiKeyName() {
            return this.apiId;
        }

        public String getSessionKeyName() {
            return this.sessionId;
        }

        public String getSigKeyName() {
            return this.sig;
        }

        public List<ParameterInfo> getParameters() {
            return this.params;
        }

        public void setParameters(List<ParameterInfo> list) {
            this.params = list;
        }

        public SaasAuthentication.UseTemplates getUseTemplates() {
            return this.useTemplates;
        }

        public void setUseTemplates(SaasAuthentication.UseTemplates useTemplates) {
            this.useTemplates = useTemplates;
        }

        public SaasAuthentication.UseGenerator getUseGenerator() {
            return this.useGenerator;
        }

        public void setUseGenerator(SaasAuthentication.UseGenerator useGenerator) {
            this.useGenerator = useGenerator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SignedUrlAuthentication
    extends SaasAuthentication {
        private String sig;
        List<ParameterInfo> params;

        public SignedUrlAuthentication() {
            this.params = Collections.emptyList();
        }

        public String getSigKeyName() {
            return this.sig;
        }

        public void setSigKeyName(String string) {
            this.sig = string;
        }

        public List<ParameterInfo> getParameters() {
            return this.params;
        }

        public void setParameters(List<ParameterInfo> list) {
            this.params = list;
        }
    }

    public class ApiKeyAuthentication
    extends SaasAuthentication {
        private String keyName;

        public ApiKeyAuthentication(String string) {
            this.keyName = string;
        }

        public String getApiKeyName() {
            return this.keyName;
        }
    }

    public class HttpBasicAuthentication
    extends SaasAuthentication {
        private String username;
        private String password;
        private SaasAuthentication.UseTemplates useTemplates;
        private SaasAuthentication.UseGenerator useGenerator;

        public HttpBasicAuthentication(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        public String getUserNameId() {
            return this.username;
        }

        public String getPasswordId() {
            return this.password;
        }

        public SaasAuthentication.UseTemplates getUseTemplates() {
            return this.useTemplates;
        }

        public void setUseTemplates(SaasAuthentication.UseTemplates useTemplates) {
            this.useTemplates = useTemplates;
        }

        public SaasAuthentication.UseGenerator getUseGenerator() {
            return this.useGenerator;
        }

        public void setUseGenerator(SaasAuthentication.UseGenerator useGenerator) {
            this.useGenerator = useGenerator;
        }
    }

    public class SaasAuthentication {
        public UseGenerator createUseGenerator() {
            return new UseGenerator();
        }

        public UseTemplates createUseTemplates() {
            return new UseTemplates();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UseTemplates {
            private List<Template> templates = Collections.emptyList();

            public List<Template> getTemplates() {
                return this.templates;
            }

            public void setTemplates(List<Template> list) {
                this.templates = list;
            }

            public Template createTemplate(String string, String string2, String string3, String string4) {
                return new Template(string, string2, string3, string4);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Template {
                private List<String> dropTypeList = new ArrayList<String>();
                private String id;
                private String type;
                private String url;

                public Template(String string, String string2, String string3, String string4) {
                    for (String string5 : string.split(",")) {
                        this.dropTypeList.add(string5);
                    }
                    this.id = string2;
                    this.type = string3;
                    this.url = string4;
                }

                public List<String> getDropTypeList() {
                    return this.dropTypeList;
                }

                public String getId() {
                    return this.id;
                }

                public String getType() {
                    return this.type;
                }

                public String getUrl() {
                    return this.url;
                }
            }
        }

        public class UseGenerator {
            private Login login;
            private Token token;
            private Logout logout;

            public Login getLogin() {
                return this.login;
            }

            public void setLogin(Login login) {
                this.login = login;
            }

            public Token getToken() {
                return this.token;
            }

            public void setToken(Token token) {
                this.token = token;
            }

            public Logout getLogout() {
                return this.logout;
            }

            public void setLogout(Logout logout) {
                this.logout = logout;
            }

            public Login createLogin() {
                return new Login();
            }

            public Token createToken(String string) {
                return new Token(string);
            }

            public Logout createLogout() {
                return new Logout();
            }

            public Method createMethod() {
                return new Method();
            }

            public class Method {
                String id;
                String name;
                String href;

                public String getId() {
                    return this.id;
                }

                public void setId(String string) {
                    this.id = string;
                }

                public String getName() {
                    return this.name;
                }

                public void setName(String string) {
                    this.name = string;
                }

                public String getHref() {
                    return this.href;
                }

                public void setHref(String string) {
                    this.href = string;
                }
            }

            public class Logout
            extends Login {
            }

            public class Token
            extends Login {
                private String id;
                private Prompt prompt;

                public Token(String string) {
                    this.id = string;
                }

                public String getId() {
                    return this.id;
                }

                public Prompt getPrompt() {
                    return this.prompt;
                }

                public void setPrompt(Prompt prompt) {
                    this.prompt = prompt;
                }

                private Prompt createPrompt() {
                    return new Prompt();
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Prompt {
                    private String deskTopUrl;
                    private String webUrl;
                    List<ParameterInfo> params = Collections.emptyList();
                    private String signId;

                    public String getSignId() {
                        return this.signId;
                    }

                    public void setSignId(String string) {
                        this.signId = string;
                    }

                    public List<ParameterInfo> getParameters() {
                        return this.params;
                    }

                    public void setParameters(List<ParameterInfo> list) {
                        this.params = list;
                    }

                    public String getDesktopUrl() {
                        return this.deskTopUrl;
                    }

                    public void setDesktopUrl(String string) {
                        this.deskTopUrl = string;
                    }

                    public String getWebUrl() {
                        return this.webUrl;
                    }

                    public void setWebUrl(String string) {
                        this.webUrl = string;
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Login {
                List<ParameterInfo> params = Collections.emptyList();
                Method method;
                String signId;

                public String getSignId() {
                    return this.signId;
                }

                public void setSignId(String string) {
                    this.signId = string;
                }

                public List<ParameterInfo> getParameters() {
                    return this.params;
                }

                public void setParameters(List<ParameterInfo> list) {
                    this.params = list;
                }

                public Method getMethod() {
                    return this.method;
                }

                public void setMethod(Method method) {
                    this.method = method;
                }
            }
        }
    }

    public class Time {
    }
}

