/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomClientEditorDrop
implements ActiveEditorDrop {
    private CustomSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public CustomClientEditorDrop(CustomSaasMethod customSaasMethod) {
        this.method = customSaasMethod;
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        if (SaasClientCodeGenerationManager.canAccept((SaasMethod)this.method, jTextComponent.getDocument())) {
            return this.doHandleTransfer(jTextComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent jTextComponent) {
        final Document document = jTextComponent.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        final String string = this.method.getName();
        this.targetFO = CustomClientEditorDrop.getTargetFile(jTextComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList arrayList = new ArrayList();
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(CustomClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)string));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SaasClientCodeGenerator saasClientCodeGenerator = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)CustomClientEditorDrop.this.method, document);
                    if (saasClientCodeGenerator == null) {
                        Util.showUnsupportedDropMessage(new Object[]{CustomClientEditorDrop.this.targetFO.getNameExt(), "REST Resource"});
                        return;
                    }
                    saasClientCodeGenerator.init((SaasMethod)CustomClientEditorDrop.this.method, document);
                    saasClientCodeGenerator.setDropLocation(jTextComponent);
                    CustomClientSaasBean customClientSaasBean = (CustomClientSaasBean)saasClientCodeGenerator.getBean();
                    List<ParameterInfo> list = customClientSaasBean.filterParametersByAuth(customClientSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    if (!list.isEmpty()) {
                        boolean bl = Util.isJava(document) || Util.isJsp(document);
                        CodeSetupPanel codeSetupPanel = new CodeSetupPanel(list, bl);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)codeSetupPanel, NbBundle.getMessage(CustomClientEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)string));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object.equals(NotifyDescriptor.CANCEL_OPTION)) {
                            return;
                        }
                    }
                    try {
                        saasClientCodeGenerator.initProgressReporting(progressDialog.getProgressHandle());
                        saasClientCodeGenerator.generate();
                    }
                    catch (IOException iOException) {
                        if (!iOException.getMessage().equals("ScanningInProgress")) {
                            arrayList.add(iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
                finally {
                    progressDialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        progressDialog.open();
        if (arrayList.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)arrayList.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)jTextComponent.getDocument());
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

