/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColorModel {
    private static final Logger LOG = Logger.getLogger(ColorModel.class.getName());
    public static final String ALL_LANGUAGES = NbBundle.getMessage(ColorModel.class, (String)"CTL_All_Languages");
    private static final String[] EMPTY_MIMEPATH = new String[0];
    private Map<String, String> languageToMimeType;
    private Set<AttributeSet> hiddenCategories = new HashSet<AttributeSet>();

    public Set<String> getProfiles() {
        return EditorSettings.getDefault().getFontColorProfiles();
    }

    public String getCurrentProfile() {
        return EditorSettings.getDefault().getCurrentFontColorProfile();
    }

    public boolean isCustomProfile(String string) {
        return EditorSettings.getDefault().isCustomFontColorProfile(string);
    }

    public void setCurrentProfile(String string) {
        EditorSettings.getDefault().setCurrentFontColorProfile(string);
    }

    public Collection<AttributeSet> getAnnotations(String string) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        Iterator iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            AnnotationType annotationType = AnnotationTypes.getTypes().getType(string3);
            if (!annotationType.isVisible() || (string2 = annotationType.getDescription()) == null) continue;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string2);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string2);
            URL uRL = annotationType.getGlyph();
            Image image = null;
            image = uRL.getProtocol().equals("nbresloc") ? org.openide.util.Utilities.loadImage((String)uRL.getPath().substring(1)) : Toolkit.getDefaultToolkit().getImage(uRL);
            if (image != null) {
                simpleAttributeSet.addAttribute("icon", new ImageIcon(image));
            }
            Color color = annotationType.getHighlight();
            if (annotationType.isUseHighlightColor() && color != null) {
                simpleAttributeSet.addAttribute(StyleConstants.Background, color);
            }
            Color color2 = annotationType.getForegroundColor();
            if (!annotationType.isInheritForegroundColor() && color2 != null) {
                simpleAttributeSet.addAttribute(StyleConstants.Foreground, color2);
            }
            Color color3 = annotationType.getWaveUnderlineColor();
            if (annotationType.isUseWaveUnderlineColor() && color3 != null) {
                simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, color3);
            }
            simpleAttributeSet.addAttribute("annotationType", annotationType);
            arrayList.add(simpleAttributeSet);
        }
        return arrayList;
    }

    public void setAnnotations(String string, Collection<AttributeSet> collection) {
        for (AttributeSet attributeSet : collection) {
            AnnotationType annotationType = (AnnotationType)attributeSet.getAttribute("annotationType");
            if (attributeSet.isDefined(StyleConstants.Background)) {
                annotationType.setUseHighlightColor(true);
                annotationType.setHighlight((Color)attributeSet.getAttribute(StyleConstants.Background));
            } else {
                annotationType.setUseHighlightColor(false);
            }
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                annotationType.setInheritForegroundColor(false);
                annotationType.setForegroundColor((Color)attributeSet.getAttribute(StyleConstants.Foreground));
            } else {
                annotationType.setInheritForegroundColor(true);
            }
            if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                annotationType.setUseWaveUnderlineColor(true);
                annotationType.setWaveUnderlineColor((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor));
                continue;
            }
            annotationType.setUseWaveUnderlineColor(false);
        }
    }

    public Collection<AttributeSet> getHighlightings(String string) {
        Map map = EditorSettings.getDefault().getHighlightings(string);
        if (map == null) {
            return null;
        }
        return this.hideDummyCategories(map.values());
    }

    public Collection<AttributeSet> getHighlightingDefaults(String string) {
        Collection<AttributeSet> collection = EditorSettings.getDefault().getHighlightingDefaults(string).values();
        if (collection == null) {
            return null;
        }
        return this.hideDummyCategories(collection);
    }

    public void setHighlightings(String string, Collection<AttributeSet> collection) {
        EditorSettings.getDefault().setHighlightings(string, ColorModel.toMap(collection));
    }

    public Set<String> getLanguages() {
        return this.getLanguageToMimeTypeMap().keySet();
    }

    public Collection<AttributeSet> getCategories(String string, String string2) {
        String[] stringArray = this.getMimePath(string2);
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(stringArray);
        return fontColorSettingsFactory.getAllFontColors(string);
    }

    public Collection<AttributeSet> getDefaults(String string, String string2) {
        String[] stringArray = this.getMimePath(string2);
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(stringArray);
        return fontColorSettingsFactory.getAllFontColorDefaults(string);
    }

    public void setCategories(String string, String string2, Collection<AttributeSet> collection) {
        String[] stringArray = this.getMimePath(string2);
        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(stringArray);
        fontColorSettingsFactory.setAllFontColors(string, collection);
    }

    public Component getSyntaxColoringPreviewComponent(String string) {
        String string2 = this.getMimeType(string);
        return new Preview("test" + this.hashCode(), string2);
    }

    private String getMimeType(String string) {
        if (string.equals(ALL_LANGUAGES)) {
            return "";
        }
        String string2 = this.getLanguageToMimeTypeMap().get(string);
        assert (string2 != null) : "Invalid language '" + string + "'";
        return string2;
    }

    private String[] getMimePath(String string) {
        if (string.equals(ALL_LANGUAGES)) {
            return EMPTY_MIMEPATH;
        }
        String string2 = this.getLanguageToMimeTypeMap().get(string);
        assert (string2 != null) : "Invalid language '" + string + "'";
        return new String[]{string2};
    }

    private Map<String, String> getLanguageToMimeTypeMap() {
        if (this.languageToMimeType == null) {
            this.languageToMimeType = new HashMap<String, String>();
            Set set = EditorSettings.getDefault().getMimeTypes();
            for (String string : set) {
                this.languageToMimeType.put(EditorSettings.getDefault().getLanguageName(string), string);
            }
            this.languageToMimeType.put(ALL_LANGUAGES, "Defaults");
        }
        return this.languageToMimeType;
    }

    private Collection<AttributeSet> hideDummyCategories(Collection<AttributeSet> collection) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            if (this.hiddenCategories.contains(attributeSet.getAttribute(StyleConstants.NameAttribute))) continue;
            arrayList.add(attributeSet);
        }
        return arrayList;
    }

    private static Map<String, AttributeSet> toMap(Collection<AttributeSet> collection) {
        if (collection == null) {
            return null;
        }
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            hashMap.put((String)attributeSet.getAttribute(StyleConstants.NameAttribute), attributeSet);
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Preview
    extends JPanel {
        static final String PROP_CURRENT_ELEMENT = "currentAElement";
        private String testProfileName;
        private String currentMimeType;
        private JEditorPane editorPane;
        private FontColorSettingsFactory fontColorSettings;

        public Preview(String string, final String string2) {
            super(new BorderLayout());
            this.testProfileName = string;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Preview.this.updateMimeType(string2);
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void setParameters(String string, final Collection<AttributeSet> collection, final Collection<AttributeSet> collection2, final Collection<AttributeSet> collection3) {
            final String string2 = ColorModel.this.getMimeType(string);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!string2.equals(Preview.this.currentMimeType)) {
                        Preview.this.updateMimeType(string2);
                    }
                    if (collection != null) {
                        EditorSettings.getDefault().getFontColorSettings(EMPTY_MIMEPATH).setAllFontColors(Preview.this.testProfileName, collection);
                    }
                    if (collection2 != null) {
                        EditorSettings.getDefault().setHighlightings(Preview.this.testProfileName, ColorModel.toMap(collection2));
                    }
                    if (collection3 != null && Preview.this.currentMimeType.length() != 0) {
                        FontColorSettingsFactory fontColorSettingsFactory = EditorSettings.getDefault().getFontColorSettings(new String[]{Preview.this.currentMimeType});
                        fontColorSettingsFactory.setAllFontColors(Preview.this.testProfileName, collection3);
                    }
                }
            });
        }

        private void updateMimeType(String string) {
            this.currentMimeType = string;
            String[] stringArray = this.loadPreviewExample(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = this.hackMimeType(string3);
            this.removeAll();
            this.editorPane = new JEditorPane();
            this.add((Component)this.editorPane, "Center");
            EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string4);
            Document document = editorKit.createDefaultDocument();
            document.putProperty("mimeType", string4);
            this.editorPane.setEditorKit(editorKit);
            this.editorPane.setDocument(document);
            this.editorPane.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    int n = caretEvent.getDot();
                    String string = null;
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)Preview.this.editorPane.getDocument());
                    if (tokenHierarchy != null) {
                        string = this.findLexerElement((TokenHierarchy<Document>)tokenHierarchy, n);
                    } else {
                        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)Preview.this.editorPane);
                        if (syntaxSupport instanceof ExtSyntaxSupport) {
                            string = this.findSyntaxElement((ExtSyntaxSupport)syntaxSupport, n);
                        }
                    }
                    if (string != null) {
                        Preview.this.firePropertyChange(Preview.PROP_CURRENT_ELEMENT, null, string);
                    }
                }

                private String findLexerElement(TokenHierarchy<Document> tokenHierarchy, int n) {
                    String string = null;
                    List list = tokenHierarchy.embeddedTokenSequences(n, false);
                    if (!list.isEmpty()) {
                        TokenSequence tokenSequence = (TokenSequence)list.get(list.size() - 1);
                        tokenSequence.move(n);
                        if (tokenSequence.moveNext() && (string = tokenSequence.token().id().primaryCategory()) == null) {
                            string = tokenSequence.token().id().name();
                        }
                    }
                    return string;
                }

                private String findSyntaxElement(ExtSyntaxSupport extSyntaxSupport, int n) {
                    try {
                        TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
                        if (tokenItem == null) {
                            return null;
                        }
                        String string = tokenItem.getTokenContextPath().getNamePrefix();
                        string = tokenItem.getTokenID().getCategory() != null ? string + tokenItem.getTokenID().getCategory().getName() : string + tokenItem.getTokenID().getName();
                        return string;
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.WARNING, null, badLocationException);
                        return null;
                    }
                }
            });
            this.editorPane.setEnabled(false);
            this.editorPane.setText(string2);
            this.editorPane.setCaretPosition(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] loadPreviewExample(String string) {
            Object object;
            Object object2;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = null;
            String string2 = null;
            if (string == null || string.length() == 0) {
                object2 = fileSystem.findResource("OptionsDialog/PreviewExamples");
                if (object2 != null && object2.isFolder()) {
                    object = object2.getChildren();
                    for (int i = 0; i < ((FileObject[])object).length; ++i) {
                        if (!object[i].isData()) continue;
                        fileObject = object[i];
                        break;
                    }
                }
                if (fileObject != null) {
                    string2 = fileObject.getMIMEType().equals("content/unknown") ? "text/x-java" : fileObject.getMIMEType();
                }
            } else {
                fileObject = fileSystem.findResource("OptionsDialog/PreviewExamples/" + string);
                string2 = string;
            }
            if (fileObject != null) {
                object2 = new StringBuilder((int)fileObject.getSize());
                try {
                    object = new InputStreamReader(fileObject.getInputStream());
                    char[] cArray = new char[1024];
                    try {
                        int n;
                        while (0 < (n = ((InputStreamReader)object).read(cArray, 0, cArray.length))) {
                            ((StringBuilder)object2).append(cArray, 0, n);
                        }
                    }
                    finally {
                        ((InputStreamReader)object).close();
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Can't read font & colors preview example", iOException);
                }
                return new String[]{((StringBuilder)object2).toString(), string2};
            }
            return new String[]{"", "text/plain"};
        }

        private String hackMimeType(String string) {
            return this.testProfileName + "_" + string;
        }
    }
}

