/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.options.indentation.FormattingPanelController;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormattingCustomizerPanel
extends JPanel
implements ActionListener {
    private static final String GLOBAL_OPTIONS_CATEGORY = "Editor/Formating";
    private final FormattingPanelController controller = new FormattingPanelController();
    private final JComponent customizerComponent;
    private final Preferences preferences;
    private JPanel customizerPanel;
    private JButton editGlobalButton;
    private JRadioButton globalButton;
    private ButtonGroup group;
    private JButton loadButton;
    private JRadioButton projectButton;

    private FormattingCustomizerPanel(Lookup lookup) {
        this.customizerComponent = this.controller.getComponent(lookup);
        this.initComponents();
        this.customizerPanel.add((Component)this.customizerComponent, "Center");
        this.controller.update();
        this.preferences = ProjectUtils.getPreferences((Project)((Project)lookup.lookup(Project.class)), IndentUtils.class, (boolean)true).node("CodeStyle");
        String string = this.preferences.get("usedProfile", "default");
        if ("default".equals(string)) {
            this.globalButton.doClick();
        } else {
            this.projectButton.doClick();
        }
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.globalButton = new JRadioButton();
        this.editGlobalButton = new JButton();
        this.projectButton = new JRadioButton();
        this.loadButton = new JButton();
        this.customizerPanel = new JPanel();
        this.group.add(this.globalButton);
        this.globalButton.setText(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_Global"));
        this.globalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.globalButtonActionPerformed(actionEvent);
            }
        });
        this.editGlobalButton.setText(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_EditGlobal"));
        this.editGlobalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.editGlobalButtonActionPerformed(actionEvent);
            }
        });
        this.group.add(this.projectButton);
        this.projectButton.setText(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_Project"));
        this.projectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.projectButtonActionPerformed(actionEvent);
            }
        });
        this.loadButton.setText(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_ForamttingCustomizer_Load"));
        this.loadButton.setHorizontalAlignment(4);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.loadButtonActionPerformed(actionEvent);
            }
        });
        this.customizerPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectButton, -1, 306, Short.MAX_VALUE).add((Component)this.globalButton, -1, 306, Short.MAX_VALUE)).add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.editGlobalButton, -1, -1, Short.MAX_VALUE).add((Component)this.loadButton, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.customizerPanel, -1, 490, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.globalButton).add((Component)this.editGlobalButton)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectButton).add((Component)this.loadButton)).addPreferredGap(1).add((Component)this.customizerPanel, -1, 239, Short.MAX_VALUE)));
    }

    private void globalButtonActionPerformed(ActionEvent actionEvent) {
        this.loadButton.setEnabled(false);
        this.setEnabled(this.customizerComponent, false);
    }

    private void projectButtonActionPerformed(ActionEvent actionEvent) {
        this.loadButton.setEnabled(true);
        this.setEnabled(this.customizerComponent, true);
    }

    private void loadButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        FileObject fileObject;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        if (jFileChooser.showOpenDialog(this) == 0 && (fileObject = FileUtil.toFileObject((File)(file = jFileChooser.getSelectedFile()))) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void editGlobalButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open(GLOBAL_OPTIONS_CATEGORY);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.globalButton.isSelected() ? "default" : "project";
        this.preferences.put("usedProfile", string);
        this.controller.applyChanges();
    }

    private void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.setEnabled(component2, bl);
            }
        }
    }

    public static class Factory
    implements ProjectCustomizer.CompositeCategoryProvider {
        private static final String CATEGORY_FORMATTING = "Formatting";

        public ProjectCustomizer.Category createCategory(Lookup lookup) {
            return lookup.lookup(Project.class) == null ? null : ProjectCustomizer.Category.create((String)CATEGORY_FORMATTING, (String)NbBundle.getMessage(Factory.class, (String)"LBL_CategoryFormatting"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }

        public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
            FormattingCustomizerPanel formattingCustomizerPanel = new FormattingCustomizerPanel(lookup);
            category.setStoreListener((ActionListener)formattingCustomizerPanel);
            return formattingCustomizerPanel;
        }
    }
}

