/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.indentation.FormattingPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattingPanelController
extends OptionsPanelController {
    static final String CODE_STYLE_PROFILE = "CodeStyle";
    static final String DEFAULT_PROFILE = "default";
    static final String PROJECT_PROFILE = "project";
    static final String USED_PROFILE = "usedProfile";
    private static final String FOLDER = "OptionsDialog/Editor/Formatting/";
    private FormattingPanel panel;
    private Map<String, Collection<? extends OptionsPanelController>> mimeType2Controllers;
    private Preferences projectPreferences;
    private Map<String, Preferences> mimeTypePreferences;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private boolean changed;

    public void update() {
        this.changed = false;
        this.panel.load();
    }

    public void applyChanges() {
        this.panel.store();
        try {
            if (this.projectPreferences != null) {
                this.projectPreferences.flush();
            } else {
                for (Preferences preferences : this.mimeTypePreferences.values()) {
                    preferences.flush();
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void cancel() {
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.editor.formatting");
    }

    public synchronized JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.mimeType2Controllers = this.getControllers();
            this.projectPreferences = this.getProjectPreferences((Project)lookup.lookup(Project.class));
            if (this.projectPreferences == null) {
                this.mimeTypePreferences = new HashMap<String, Preferences>();
            }
            this.panel = new FormattingPanel(this);
        }
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    void changed() {
        if (!this.changed) {
            this.changed = true;
            this.pcs.firePropertyChange("changed", false, true);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    Iterable<String> getMimeTypes() {
        return this.mimeType2Controllers.keySet();
    }

    Iterable<? extends OptionsPanelController> getControllers(String string) {
        Set set = (Set)this.mimeType2Controllers.get(string);
        return set != null ? set : Collections.emptySet();
    }

    Lookup getLookup(String string, JEditorPane jEditorPane) {
        Preferences preferences = null;
        if (this.projectPreferences != null) {
            preferences = string.length() > 0 ? this.projectPreferences.node(string) : this.projectPreferences;
        } else {
            preferences = this.mimeTypePreferences.get(string);
            if (preferences == null) {
                preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
                this.mimeTypePreferences.put(string, preferences);
            }
        }
        return preferences != null ? Lookups.fixed((Object[])new Object[]{preferences, jEditorPane}) : Lookups.fixed((Object[])new Object[]{jEditorPane});
    }

    private Map<String, Collection<? extends OptionsPanelController>> getControllers() {
        LinkedHashMap<String, Collection<? extends OptionsPanelController>> linkedHashMap = new LinkedHashMap<String, Collection<? extends OptionsPanelController>>();
        for (String string : EditorSettings.getDefault().getAllMimeTypes()) {
            Lookup lookup = Lookups.forPath((String)(FOLDER + string));
            Collection collection = lookup.lookupAll(OptionsPanelController.class);
            if (collection.isEmpty()) continue;
            linkedHashMap.put(string, collection);
        }
        return linkedHashMap;
    }

    private Preferences getProjectPreferences(Project project) {
        Preferences preferences;
        String string;
        if (project != null && PROJECT_PROFILE.equals(string = (preferences = ProjectUtils.getPreferences((Project)project, IndentUtils.class, (boolean)true).node(CODE_STYLE_PROFILE)).get(USED_PROFILE, DEFAULT_PROFILE))) {
            return preferences.node(PROJECT_PROFILE);
        }
        return null;
    }
}

