/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.io.IOException;
import java.util.Comparator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utilities.OutputParameter;
import org.openide.filesystems.FileObject;

public class MethodNode
extends SelectorNode {
    public static final Comparator<MethodNode> COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode methodNode, MethodNode methodNode2) {
            return methodNode.toString().compareTo(methodNode2.toString());
        }
    };
    private ClientUtils.SourceCodeSelection rootMethod;

    public MethodNode(ClasspathInfo classpathInfo, final ExecutableElement executableElement, MethodsNode methodsNode) {
        super(executableElement.toString(), executableElement.getSimpleName().toString(), MethodNode.getIcon(executableElement), SelectorChildren.LEAF, methodsNode);
        final OutputParameter outputParameter = new OutputParameter((Object)"");
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    outputParameter.setValue((Object)SourceUtils.getVMMethodSignature((ExecutableElement)executableElement, (CompilationInfo)compilationController));
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (outputParameter.getValue() != null) {
            this.rootMethod = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)this.getEnclosingClass(executableElement)), executableElement.getSimpleName().toString(), (String)outputParameter.getValue());
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean isLeaf() {
        return true;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.rootMethod;
    }

    private TypeElement getEnclosingClass(Element element) {
        Element element2 = element.getEnclosingElement();
        if (element2 != null) {
            if (element2.getKind() == ElementKind.CLASS || element2.getKind() == ElementKind.ENUM) {
                return (TypeElement)element2;
            }
            return this.getEnclosingClass(element2);
        }
        return null;
    }

    private static Icon getIcon(ExecutableElement executableElement) {
        ImageIcon imageIcon = executableElement.getModifiers().contains((Object)Modifier.STATIC) ? (executableElement.getModifiers().contains((Object)Modifier.PUBLIC) ? IconResource.METHOD_PUBLIC_STATIC_ICON : (executableElement.getModifiers().contains((Object)Modifier.PROTECTED) ? IconResource.METHOD_PROTECTED_STATIC_ICON : (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) ? IconResource.METHOD_PRIVATE_STATIC_ICON : IconResource.METHOD_PACKAGE_STATIC_ICON))) : (executableElement.getModifiers().contains((Object)Modifier.PUBLIC) ? IconResource.METHOD_PUBLIC_ICON : (executableElement.getModifiers().contains((Object)Modifier.PROTECTED) ? IconResource.METHOD_PROTECTED_ICON : (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) ? IconResource.METHOD_PRIVATE_ICON : IconResource.METHOD_PACKAGE_ICON)));
        return imageIcon;
    }
}

