/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.image.BufferedImage;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;

public class SnapshotFlatProfilePanel
extends FlatProfilePanel
implements ScreenshotProvider {
    private CPUResultsSnapshot snapshot;

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler) {
        this(cPUResUserActionsHandler, null);
    }

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler) {
        super(cPUResUserActionsHandler, cPUSelectionHandler);
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.resTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2) {
        this.snapshot = cPUResultsSnapshot;
        this.currentView = n2;
        this.threadId = n;
        this.flatProfileContainer = null;
        this.collectingTwoTimeStamps = cPUResultsSnapshot.isCollectingTwoTimeStamps();
    }

    public String getDefaultViewName() {
        return "cpu-hotspots";
    }

    public CPUResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    protected String[] getMethodClassNameAndSig(int n, int n2) {
        return this.snapshot.getMethodClassNameAndSig(n, n2);
    }

    protected void obtainResults() {
        if (this.snapshot != null) {
            this.flatProfileContainer = this.snapshot.getFlatProfile(this.threadId, this.currentView);
        }
        if (this.snapshot == null || !this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.setResultsAvailable(true);
    }

    protected void showReverseCallGraph(int n, int n2, int n3, int n4, boolean bl) {
        this.actionsHandler.showReverseCallGraph(this.snapshot, n, n2, n3, n4, bl);
    }

    protected boolean supportsReverseCallGraph() {
        return true;
    }

    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    protected void updateResults() {
        int n;
        if (this.threadId < -1) {
            return;
        }
        int n2 = n = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != n) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }
}

