/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;

public class TreeAttlistDeclAttributeDef
extends TreeNodeDecl.Content
implements TreeNamedObjectMap.NamedObject {
    public static final String PROP_NAME = "name";
    public static final String PROP_TYPE = "type";
    public static final String PROP_ENUMERATED_TYPE = "enumeratedType";
    public static final String PROP_DEFAULT_TYPE = "defaultType";
    public static final String PROP_DEFAULT_VALUE = "defaultValue";
    public static final short TYPE_CDATA = 0;
    public static final short TYPE_ID = 1;
    public static final short TYPE_IDREF = 2;
    public static final short TYPE_IDREFS = 3;
    public static final short TYPE_ENTITY = 4;
    public static final short TYPE_ENTITIES = 5;
    public static final short TYPE_NMTOKEN = 6;
    public static final short TYPE_NMTOKENS = 7;
    public static final short TYPE_ENUMERATED = 8;
    public static final short TYPE_NOTATION = 9;
    public static final short DEFAULT_TYPE_NULL = 0;
    public static final short DEFAULT_TYPE_REQUIRED = 1;
    public static final short DEFAULT_TYPE_IMPLIED = 2;
    public static final short DEFAULT_TYPE_FIXED = 3;
    public static final String[] NAMED_TYPE_LIST = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", null, "NOTATION"};
    public static final String[] NAMED_DEFAULT_TYPE_LIST = new String[]{null, "#REQUIRED", "#IMPLIED", "#FIXED"};
    private String name;
    private short type;
    private String[] enumeratedType;
    private short defaultType;
    private String defaultValue;
    private TreeNamedObjectMap.KeyListener mapKeyListener;

    public TreeAttlistDeclAttributeDef(String string, short s, String[] stringArray, short s2, String string2) throws InvalidArgumentException {
        this.checkName(string);
        this.checkType(s, stringArray);
        this.checkDefaultType(s2, string2);
        this.name = string;
        this.type = s;
        this.enumeratedType = stringArray;
        this.defaultType = s2;
        this.defaultValue = string2;
    }

    protected TreeAttlistDeclAttributeDef(TreeAttlistDeclAttributeDef treeAttlistDeclAttributeDef) {
        super(treeAttlistDeclAttributeDef);
        this.name = treeAttlistDeclAttributeDef.name;
        this.type = treeAttlistDeclAttributeDef.type;
        this.enumeratedType = this.arraycopy(treeAttlistDeclAttributeDef.enumeratedType);
        this.defaultType = treeAttlistDeclAttributeDef.defaultType;
        this.defaultValue = treeAttlistDeclAttributeDef.defaultValue;
    }

    private String[] arraycopy(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public Object clone() {
        return new TreeAttlistDeclAttributeDef(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeAttlistDeclAttributeDef treeAttlistDeclAttributeDef = (TreeAttlistDeclAttributeDef)object;
        if (!Util.equals(this.name, treeAttlistDeclAttributeDef.name)) {
            return false;
        }
        if (this.type != treeAttlistDeclAttributeDef.type) {
            return false;
        }
        if (!Util.equals(this.enumeratedType, treeAttlistDeclAttributeDef.enumeratedType)) {
            return false;
        }
        if (this.defaultType != treeAttlistDeclAttributeDef.defaultType) {
            return false;
        }
        return Util.equals(this.defaultValue, treeAttlistDeclAttributeDef.defaultValue);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeAttlistDeclAttributeDef treeAttlistDeclAttributeDef = (TreeAttlistDeclAttributeDef)treeObject;
        this.setNameImpl(treeAttlistDeclAttributeDef.getName());
        this.setDefaultTypeImpl(treeAttlistDeclAttributeDef.getDefaultType(), treeAttlistDeclAttributeDef.getDefaultValue());
        this.setTypeImpl(treeAttlistDeclAttributeDef.getType(), treeAttlistDeclAttributeDef.getEnumeratedType());
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getOwnerAttlistDecl().removeAttributeDef(this.getName());
        }
    }

    public final TreeAttlistDecl getOwnerAttlistDecl() {
        return (TreeAttlistDecl)this.getNodeDecl();
    }

    public final String getElementName() {
        if (this.getNodeDecl() == null) {
            return null;
        }
        return this.getOwnerAttlistDecl().getElementName();
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String string) {
        String string2 = this.name;
        this.name = string;
        this.fireMapKeyChanged(string2);
    }

    public final void setName(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(string);
        this.setNameImpl(string);
    }

    protected final void checkName(String string) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeName(string);
    }

    public final short getType() {
        return this.type;
    }

    public final String getTypeName() {
        try {
            return NAMED_TYPE_LIST[this.type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public final String[] getEnumeratedType() {
        return this.enumeratedType;
    }

    public final String getEnumeratedTypeString() {
        if (this.enumeratedType == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ").append(this.enumeratedType[0]);
        for (int i = 1; i < this.enumeratedType.length; ++i) {
            stringBuffer.append(" | ").append(this.enumeratedType[i]);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public static final String[] createEnumeratedType(String string) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.createEnumeratedType: enumeratedType = " + string);
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    begin = " + n);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    end   = " + n2);
        }
        if (n == -1 || n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken().trim());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    tokens = " + linkedList);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        String[] stringArray = linkedList.toArray(new String[0]);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    RETURN arrayType = " + stringArray);
        }
        return stringArray;
    }

    private final void setTypeImpl(short s, String[] stringArray) {
        this.type = s;
        this.enumeratedType = stringArray;
    }

    public final void setType(short s, String[] stringArray) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.setType");
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newType           = " + s);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newEnumeratedType = " + (stringArray == null ? null : Arrays.asList(stringArray)));
        }
        boolean bl2 = this.type != s;
        boolean bl3 = bl = !Arrays.equals(this.enumeratedType, stringArray);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    setEnumeratedType = " + bl);
        }
        if (!bl2 && !bl) {
            return;
        }
        this.checkReadOnly();
        this.checkType(s, stringArray);
        this.setTypeImpl(s, stringArray);
    }

    protected final void checkType(short s, String[] stringArray) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeType(s);
        TreeUtilities.checkAttlistDeclAttributeEnumeratedType(stringArray);
    }

    public static final short findType(String string) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef::findType: type = " + string);
        }
        for (short s = 0; s < NAMED_TYPE_LIST.length; s = (short)(s + 1)) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("    test_type = " + NAMED_TYPE_LIST[s]);
            }
            if (!Util.equals(NAMED_TYPE_LIST[s], string)) continue;
            return s;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    type[" + string + "] not found");
        }
        return -1;
    }

    public final short getDefaultType() {
        return this.defaultType;
    }

    public final String getDefaultTypeName() {
        try {
            return NAMED_DEFAULT_TYPE_LIST[this.defaultType];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private final void setDefaultTypeImpl(short s, String string) {
        this.defaultType = s;
        this.defaultValue = string;
    }

    public final void setDefaultType(short s, String string) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttlistDeclAttributeDef.setDefaultType");
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newDefaultType  = " + NAMED_DEFAULT_TYPE_LIST[s]);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    newDefaultValue = " + string);
        }
        boolean bl2 = this.defaultType != s;
        boolean bl3 = bl = !Util.equals(this.defaultValue, string);
        if (!bl2 && !bl) {
            return;
        }
        this.checkReadOnly();
        this.checkDefaultType(s, string);
        this.setDefaultTypeImpl(s, string);
    }

    protected final void checkDefaultType(short s, String string) throws InvalidArgumentException {
        TreeUtilities.checkAttlistDeclAttributeDefaultType(s);
        TreeUtilities.checkAttlistDeclAttributeDefaultValue(string);
    }

    public static final short findDefaultType(String string) {
        for (short s = 0; s < NAMED_DEFAULT_TYPE_LIST.length; s = (short)(s + 1)) {
            if (!Util.equals(NAMED_DEFAULT_TYPE_LIST[s], string)) continue;
            return s;
        }
        return -1;
    }

    public Object mapKey() {
        return this.getName();
    }

    public void setKeyListener(TreeNamedObjectMap.KeyListener keyListener) {
        this.mapKeyListener = keyListener;
    }

    private void fireMapKeyChanged(Object object) {
        if (this.mapKeyListener == null) {
            return;
        }
        this.mapKeyListener.mapKeyChanged(object);
    }
}

