/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class ClassFinalizer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final ClassVisitor extraClassVisitor;
    private final MemberVisitor extraMemberVisitor;
    private final MemberFinder memberFinder = new MemberFinder();

    public ClassFinalizer() {
        this(null, null);
    }

    public ClassFinalizer(ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        this.extraClassVisitor = classVisitor;
        this.extraMemberVisitor = memberVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.u2accessFlags & 0x610) == 0 && !KeepMarker.isKept(programClass) && programClass.subClasses == null) {
            programClass.u2accessFlags |= 0x10;
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
        programClass.methodsAccept(this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        if (!((programMethod.u2accessFlags & 0x41A) != 0 || string.equals("<init>") || (programClass.u2accessFlags & 0x10) == 0 && (KeepMarker.isKept(programMethod) || programClass.subClasses != null && this.memberFinder.isOverriden(programClass, programMethod)))) {
            programMethod.u2accessFlags |= 0x10;
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }
}

