/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmFinderImpl
implements CsmFinder,
SettingsChangeListener {
    private boolean caseSensitive = false;
    private FileObject fo;
    private CsmFile csmFile;
    private Class kitClass;

    public CsmFinderImpl(FileObject fileObject, Class clazz) {
        this();
        this.fo = fileObject;
        this.kitClass = clazz;
        this.caseSensitive = this.getCaseSensitive();
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public CsmFinderImpl(CsmFile csmFile, Class clazz) {
        this();
        this.csmFile = csmFile;
        this.kitClass = clazz;
        this.caseSensitive = this.getCaseSensitive();
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public CsmFinderImpl() {
    }

    @Override
    public CsmFile getCsmFile() {
        return this.csmFile;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent == null || this.kitClass != settingsChangeEvent.getKitClass()) {
            return;
        }
        if ("completion-case-sensitive".equals(settingsChangeEvent.getSettingName())) {
            this.caseSensitive = this.getCaseSensitive();
        }
    }

    private boolean getCaseSensitive() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
    }

    private boolean getNaturalSort() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
    }

    private CsmNamespace resolveNamespace(String string, boolean bl) {
        LinkedList<CsmProject> linkedList = new LinkedList<CsmProject>();
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        linkedList.add(this.csmFile.getProject());
        CsmNamespace csmNamespace = this.resolveNamespaceBfs(linkedList, hashSet, string);
        if (csmNamespace != null) {
            return csmNamespace;
        }
        for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
            if (hashSet.contains(csmProject)) continue;
            linkedList.add(csmProject);
        }
        return this.resolveNamespaceBfs(linkedList, hashSet, string);
    }

    private CsmNamespace resolveNamespaceBfs(Queue<CsmProject> queue, Set<CsmProject> set, String string) {
        while (!queue.isEmpty()) {
            CsmProject csmProject = queue.poll();
            CsmNamespace csmNamespace = csmProject.findNamespace((CharSequence)string);
            if (csmNamespace != null) {
                return csmNamespace;
            }
            set.add(csmProject);
            for (CsmProject csmProject2 : csmProject.getLibraries()) {
                if (set.contains(csmProject2)) continue;
                queue.offer(csmProject2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmNamespace getExactNamespace(String string) {
        CsmNamespace csmNamespace;
        CsmNamespace csmNamespace2 = csmNamespace = this.resolveNamespace(string, true);
        return csmNamespace2;
    }

    @Override
    public CsmClassifier getExactClassifier(String string) {
        CsmClassifier csmClassifier = this.csmFile.getProject().findClassifier((CharSequence)string);
        return csmClassifier;
    }

    public List findNamespaces(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @Override
    public List findNestedNamespaces(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        List<Object> list = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        list = csmProjectContentResolver.getNestedNamespaces(csmNamespace, string, bl);
        return list;
    }

    @Override
    public List findNamespaceElements(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            Collection<CsmClassifier> collection = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace2, string, bl, bl2);
            if (collection != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if ((collection = csmProjectContentResolver.getNamespaceEnumerators(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if ((collection = csmProjectContentResolver.getNamespaceVariables(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if ((collection = csmProjectContentResolver.getNamespaceFunctions(csmNamespace2, string, bl, bl2)) != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if ((collection = csmProjectContentResolver.getFileLocalNamespaceVariables(csmNamespace2, this.csmFile, string, bl)) != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if ((collection = csmProjectContentResolver.getFileLocalNamespaceFunctions(csmNamespace2, this.csmFile, string, bl)) != null) {
                arrayList.addAll(collection);
                if (bl3 && arrayList.size() > 0) {
                    return arrayList;
                }
            }
            if (csmProject.getGlobalNamespace() != csmNamespace2) {
                collection = csmProjectContentResolver.getLibClassesEnums(string, bl);
                if (collection != null) {
                    arrayList.addAll(collection);
                    if (bl3 && arrayList.size() > 0) {
                        return arrayList;
                    }
                }
            } else {
                HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
                for (Object object : arrayList) {
                    if (!CsmKindUtilities.isQualified((CsmObject)((CsmObject)object))) continue;
                    hashSet.add(((CsmQualifiedNamedElement)object).getQualifiedName());
                }
                if (!csmNamespace2.getProject().isArtificial()) {
                    for (CsmProject csmProject2 : csmProject.getLibraries()) {
                        CsmNamespace csmNamespace3 = csmProject2.getGlobalNamespace();
                        collection = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace3, string, bl, bl2);
                        this.merge(hashSet, arrayList, collection);
                        if (bl3 && arrayList.size() > 0) {
                            return arrayList;
                        }
                        collection = csmProjectContentResolver.getNamespaceEnumerators(csmNamespace3, string, bl, bl2);
                        this.merge(hashSet, arrayList, collection);
                        if (bl3 && arrayList.size() > 0) {
                            return arrayList;
                        }
                        collection = csmProjectContentResolver.getNamespaceVariables(csmNamespace3, string, bl, bl2);
                        this.merge(hashSet, arrayList, collection);
                        if (bl3 && arrayList.size() > 0) {
                            return arrayList;
                        }
                        collection = csmProjectContentResolver.getNamespaceFunctions(csmNamespace3, string, bl, bl2);
                        this.merge(hashSet, arrayList, collection);
                        if (!bl3 || arrayList.size() <= 0) continue;
                        return arrayList;
                    }
                }
            }
        }
        return arrayList;
    }

    private void merge(HashSet<CharSequence> hashSet, List list, Collection collection) {
        if (collection != null) {
            for (Object e : collection) {
                if (!CsmKindUtilities.isQualified((CsmObject)((CsmObject)e)) || hashSet.contains(((CsmQualifiedNamedElement)e).getQualifiedName())) continue;
                list.add(e);
                hashSet.add(((CsmQualifiedNamedElement)e).getQualifiedName());
            }
        }
    }

    @Override
    public List findClasses(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            List<CsmClassifier> list = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace2, string, bl, bl2);
            if (list != null) {
                arrayList.addAll(list);
            }
            Collection<CsmClassifier> collection = list = csmProject.getGlobalNamespace() == csmNamespace2 ? null : csmProjectContentResolver.getLibClassesEnums(string, bl);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private void addNestedNamespaces(List list, CsmNamespace csmNamespace) {
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            list.add(csmNamespace2);
            this.addNestedNamespaces(list, csmNamespace2);
        }
    }

    private List getClassListForList(List list) {
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getClassList((CsmClass)iterator.next()));
        }
        return arrayList;
    }

    private List getClassList(CsmClass csmClass) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private List getOuterClasses(CsmClass csmClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(csmClass);
        while (csmClass != null) {
            Collection collection = csmClass.getBaseClasses();
            if (collection == null) continue;
            arrayList.add(collection);
        }
        return arrayList;
    }

    @Override
    public List findFields(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmField> list = csmProjectContentResolver.getFields(csmClass, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    @Override
    public List findEnumerators(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmEnumerator> list = csmProjectContentResolver.getEnumerators(csmClass, csmOffsetableDeclaration, string, bl, bl3, bl4);
        return list;
    }

    @Override
    public List findMethods(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (csmOffsetableDeclaration == null) {
            csmOffsetableDeclaration = csmClass2;
        }
        List<CsmMethod> list = csmProjectContentResolver.getMethods(csmClass2, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    @Override
    public List findNestedClassifiers(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmClassifier> list = csmProjectContentResolver.getNestedClassifiers(csmClass2, csmOffsetableDeclaration, string, bl, bl2);
        return list;
    }

    @Override
    public List findLabel(CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2) {
        ArrayList<CsmLabel> arrayList = new ArrayList<CsmLabel>();
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
            Collection collection = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)csmOffsetableDeclaration, null, CsmLabelResolver.LabelKind.Definiton);
            for (CsmReference csmReference : collection) {
                CsmLabel csmLabel;
                if (!(csmReference.getReferencedObject() instanceof CsmLabel) || !CsmSortUtilities.matchName((CharSequence)(csmLabel = (CsmLabel)csmReference.getReferencedObject()).getLabel(), (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive)) continue;
                arrayList.add(csmLabel);
            }
        }
        return arrayList;
    }
}

