/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmIncludeHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    private static final boolean NEED_TO_TRACE_UNRESOLVED_INCLUDE = CsmIncludeHyperlinkProvider.getBoolean("cnd.modelimpl.trace.failed.include", false);
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    @Override
    protected boolean isValidToken(Token<CppTokenId> token) {
        return CsmIncludeHyperlinkProvider.isSupportedToken(token);
    }

    public static boolean isSupportedToken(Token<CppTokenId> token) {
        if (token != null) {
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void performAction(Document document, JTextComponent jTextComponent, int n) {
        this.goToInclude(document, jTextComponent, n);
    }

    public boolean goToInclude(Document document, JTextComponent jTextComponent, int n) {
        if (!this.preJump(document, jTextComponent, n, "opening-include-element")) {
            return false;
        }
        CsmOffsetable csmOffsetable = this.findTargetObject(document, n);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-include-element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmOffsetable findTargetObject(Document document, int n) {
        IncludeTarget includeTarget;
        CsmInclude csmInclude = this.findInclude(document, n);
        IncludeTarget includeTarget2 = includeTarget = csmInclude == null ? null : new IncludeTarget(csmInclude);
        if (csmInclude != null && NEED_TO_TRACE_UNRESOLVED_INCLUDE && csmInclude.getIncludeFile() == null) {
            System.setProperty("cnd.modelimpl.trace.trace_now", "yes");
            try {
                csmInclude.getIncludeFile();
            }
            finally {
                System.setProperty("cnd.modelimpl.trace.trace_now", "no");
            }
        }
        return includeTarget;
    }

    private CsmInclude findInclude(Document document, int n) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true);
        if (csmFile != null) {
            return ReferencesSupport.findInclude(csmFile, n);
        }
        return null;
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static final class IncludeTarget
    implements CsmOffsetable {
        private CsmInclude include;

        public IncludeTarget(CsmInclude csmInclude) {
            this.include = csmInclude;
        }

        public CsmFile getContainingFile() {
            return this.include.getIncludeFile();
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public String getText() {
            return ((Object)this.include.getIncludeName()).toString();
        }
    }
}

