/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmOffsetUtilities {
    private CsmOffsetUtilities() {
    }

    public static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        if (csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset()) {
            if (n == csmOffsetable.getEndOffset() && CsmKindUtilities.isType((CsmObject)csmObject)) {
                CsmType csmType = (CsmType)csmObject;
                return !csmType.isPointer() && !csmType.isReference() && csmType.getArrayDepth() == 0;
            }
            return true;
        }
        return false;
    }

    public static boolean isBeforeObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return n < csmOffsetable.getStartOffset();
    }

    public static boolean isAfterObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return n > csmOffsetable.getEndOffset();
    }

    public static <T extends CsmObject> T findObject(Collection<T> collection, CsmContext csmContext, int n) {
        assert (collection != null) : "expect not null list";
        for (CsmObject csmObject : collection) {
            assert (csmObject != null) : "can't be null declaration";
            if (!CsmOffsetUtilities.isInObject(csmObject, n)) continue;
            CsmContextUtilities.updateContextObject(csmObject, n, csmContext);
            return (T)csmObject;
        }
        return null;
    }

    public static boolean isInFunctionScope(CsmFunction csmFunction, int n) {
        boolean bl = false;
        if (csmFunction != null) {
            Collection collection;
            bl = true;
            CsmType csmType = csmFunction.getReturnType();
            if (CsmOffsetUtilities.isInObject((CsmObject)csmType, n)) {
                return false;
            }
            Collection collection2 = csmFunction.getParameters();
            if (!collection2.isEmpty()) {
                CsmParameter csmParameter = (CsmParameter)collection2.iterator().next();
                return !CsmOffsetUtilities.isBeforeObject((CsmObject)csmParameter, n);
            }
            if (CsmKindUtilities.isConstructor((CsmObject)csmFunction) && !(collection = ((CsmInitializerListContainer)csmFunction).getInitializerList()).isEmpty()) {
                CsmExpression csmExpression = (CsmExpression)collection.iterator().next();
                return !CsmOffsetUtilities.isBeforeObject((CsmObject)csmExpression, n);
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmFunction) && CsmOffsetUtilities.isBeforeObject((CsmObject)(collection = (CsmFunctionDefinition)csmFunction).getBody(), n)) {
                return false;
            }
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmFunction)) {
                return false;
            }
        }
        return bl;
    }
}

