/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferencesSupport {
    private ReferencesSupport() {
    }

    public static int getDocumentOffset(BaseDocument baseDocument, int n, int n2) {
        return Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1)) + (n2 - 1);
    }

    public static BaseDocument getBaseDocument(String string) throws DataObjectNotFoundException, IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (UserQuestionException userQuestionException) {
            userQuestionException.confirmed();
            styledDocument = editorCookie.openDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    public static CsmObject findReferencedObject(CsmFile csmFile, BaseDocument baseDocument, int n) {
        return ReferencesSupport.findReferencedObject(csmFile, baseDocument, n, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, BaseDocument baseDocument, int n, Token<CppTokenId> token) {
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        return csmObject;
    }

    static CsmObject findReferencedObject(CsmFile csmFile, final BaseDocument baseDocument, final int n, Token<CppTokenId> token) {
        CsmFile csmFile2 = null;
        CsmInclude csmInclude = null;
        if (token == null) {
            final Token[] tokenArray = new Token[]{null};
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    tokenArray[0] = CndTokenUtilities.getOffsetTokenCheckPrev((Document)baseDocument, (int)n);
                }
            });
            token = tokenArray[0];
        }
        if (token != null) {
            switch ((CppTokenId)token.id()) {
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    csmInclude = ReferencesSupport.findInclude(csmFile, n);
                }
            }
        }
        CsmFile csmFile3 = csmFile2 = csmInclude == null ? null : csmInclude.getIncludeFile();
        if (csmFile2 == null) {
            csmFile2 = ReferencesSupport.findDeclaration(csmFile, (Document)baseDocument, token, n);
        }
        return csmFile2;
    }

    public static CsmInclude findInclude(CsmFile csmFile, int n) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, n);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document document, Token token, int n) {
        Collection collection;
        Object object;
        Object object2;
        int[] nArray = null;
        Object object3 = null;
        CsmObject csmObject = CsmOffsetResolver.findObject(csmFile, n);
        if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
            object2 = (CsmEnumerator)csmObject;
            if (object2.getExplicitValue() == null) {
                object3 = object2;
            }
        } else if (CsmKindUtilities.isLabel((CsmObject)csmObject)) {
            object3 = csmObject;
        } else if (CsmKindUtilities.isGotoStatement((CsmObject)csmObject)) {
            object2 = (CsmGotoStatement)csmObject;
            object = object2.getScope();
            while (object != null && CsmKindUtilities.isScopeElement((CsmObject)object) && !CsmKindUtilities.isFunctionDefinition((CsmObject)object)) {
                object = ((CsmScopeElement)object).getScope();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)object) && !(collection = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)object, object2.getLabel(), CsmLabelResolver.LabelKind.Definiton)).isEmpty()) {
                object3 = ((CsmReference)collection.iterator().next()).getReferencedObject();
            }
            if (object3 == null) {
                return null;
            }
        } else if (CsmKindUtilities.isVariable((CsmObject)csmObject) || CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
            boolean bl;
            object2 = CsmKindUtilities.isVariable((CsmObject)csmObject) ? ((CsmVariable)csmObject).getType() : ((CsmTypedef)csmObject).getType();
            object = null;
            do {
                CsmParameter csmParameter;
                bl = false;
                if (CsmOffsetUtilities.isInObject((CsmObject)object2, n)) {
                    object = null;
                    continue;
                }
                if (!CsmKindUtilities.isFunctionPointerType((CsmObject)object2) || (csmParameter = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)object2).getParameters(), null, n)) == null) continue;
                object = csmParameter;
                object2 = csmParameter.getType();
                bl = true;
            } while (bl);
            object3 = object;
        }
        if (object3 == null) {
            try {
                if (document instanceof BaseDocument) {
                    nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)((BaseDocument)document), (int)n);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (nArray != null && nArray.length != 3) {
                object3 = ReferencesSupport.findDeclaration(csmFile, document, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.SMART_QUERY);
            }
        }
        Object object4 = object3 = object3 != null ? object3 : ReferencesSupport.findDeclaration(csmFile, document, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.GLOBAL_QUERY);
        if (object3 == null) {
            object2 = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
            object = object2.iterator();
            while (object.hasNext()) {
                collection = (CsmReference)object.next();
                if (collection.getStartOffset() > n || n > collection.getEndOffset()) continue;
                object3 = collection.getReferencedObject();
                assert (object3 != null) : "must be referenced macro" + collection;
            }
        }
        return object3;
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document document, Token<CppTokenId> csmObject, int n, CsmCompletionQuery.QueryScope queryScope) {
        CsmObject csmObject2;
        assert (csmFile != null);
        if (csmObject == null && document instanceof BaseDocument) {
            csmObject2 = new CsmObject[]{null};
            ((BaseDocument)document).runAtomic(new Runnable((Token[])csmObject2, document, n){
                final /* synthetic */ Token[] val$out;
                final /* synthetic */ Document val$doc;
                final /* synthetic */ int val$offset;
                {
                    this.val$out = tokenArray;
                    this.val$doc = document;
                    this.val$offset = n;
                }

                public void run() {
                    this.val$out[0] = CndTokenUtilities.getOffsetTokenCheckPrev((Document)this.val$doc, (int)this.val$offset);
                }
            });
            csmObject = csmObject2[0];
        }
        if (csmObject == null) {
            return null;
        }
        csmObject2 = null;
        if (csmObject.id() == CppTokenId.OPERATOR) {
            CsmObject csmObject3 = CsmOffsetResolver.findObject(csmFile, n);
            csmObject2 = csmObject3;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject2)) {
                CsmFunction csmFunction = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject2)) {
                    csmFunction = ((CsmFunctionDefinition)csmObject2).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmObject2)) {
                    csmFunction = ((CsmFriendFunction)csmObject2).getReferencedFunction();
                }
                if (csmFunction != null) {
                    csmObject2 = csmFunction;
                }
            } else {
                csmObject2 = null;
            }
        }
        if (csmObject2 == null) {
            csmObject2 = CompletionUtilities.findItemAtCaretPos(null, document, CsmCompletionProvider.getCompletionQuery(csmFile, queryScope), n);
        }
        return csmObject2;
    }

    static ReferenceImpl createReferenceImpl(final CsmFile csmFile, final BaseDocument baseDocument, final int n) {
        final ReferenceImpl[] referenceImplArray = new ReferenceImpl[]{null};
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                Token token = CndTokenUtilities.getOffsetTokenCheckPrev((Document)baseDocument, (int)n);
                ReferenceImpl referenceImpl = null;
                if (ReferencesSupport.isSupportedToken((Token<CppTokenId>)token)) {
                    referenceImpl = ReferencesSupport.createReferenceImpl(csmFile, baseDocument, n, token, null);
                }
                referenceImplArray[0] = referenceImpl;
            }
        });
        return referenceImplArray[0];
    }

    public static ReferenceImpl createReferenceImpl(CsmFile csmFile, BaseDocument baseDocument, int n, Token token, CsmReferenceKind csmReferenceKind) {
        assert (token != null);
        assert (csmFile != null) : "null file for document " + baseDocument + " on offset " + n + " " + token;
        ReferenceImpl referenceImpl = new ReferenceImpl(csmFile, baseDocument, n, token, csmReferenceKind);
        return referenceImpl;
    }

    private static boolean isSupportedToken(Token<CppTokenId> token) {
        return token != null && (CsmIncludeHyperlinkProvider.isSupportedToken(token) || CsmHyperlinkProvider.isSupportedToken(token));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference csmReference) {
        Parameters.notNull((CharSequence)"ref", (Object)csmReference);
        CsmObject csmObject = ReferencesSupport.getTargetIfPossible(csmReference);
        if (csmObject == null) {
            int n = ReferencesSupport.getRefOffset(csmReference);
            BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
            if (baseDocument != null) {
                Token token = ReferencesSupport.getRefTokenIfPossible(csmReference);
                csmObject = ReferencesSupport.findDeclaration(csmReference.getContainingFile(), (Document)baseDocument, (Token<CppTokenId>)token, n, CsmCompletionQuery.QueryScope.LOCAL_QUERY);
                ReferencesSupport.setResolvedInfo(csmReference, csmObject);
            }
        }
        return ReferencesSupport.getTargetScope(csmObject);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject csmObject) {
        if (csmObject == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(csmObject)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getTarget();
        }
        return null;
    }

    private static Token getRefTokenIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getToken();
        }
        return null;
    }

    private static CsmReferenceKind getRefKindIfPossible(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getKindImpl();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference csmReference) {
        if (csmReference instanceof DocOffsetableImpl) {
            return ((DocOffsetableImpl)csmReference).getDocument();
        }
        CsmFile csmFile = csmReference.getContainingFile();
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        StyledDocument styledDocument = null;
        if (cloneableEditorSupport != null) {
            styledDocument = cloneableEditorSupport.getDocument();
        }
        return styledDocument instanceof BaseDocument ? (BaseDocument)styledDocument : null;
    }

    private static int getRefOffset(CsmReference csmReference) {
        if (csmReference instanceof ReferenceImpl) {
            return ((ReferenceImpl)csmReference).getOffset();
        }
        return (csmReference.getStartOffset() + csmReference.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference csmReference, CsmObject csmObject) {
        if (csmObject != null && csmReference instanceof ReferenceImpl) {
            ((ReferenceImpl)csmReference).setTarget(csmObject);
        }
    }

    private static boolean isLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        CsmObject csmObject2 = csmObject;
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject2)) {
            CsmScope csmScope = ((CsmScopeElement)csmObject2).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)csmScope)) break;
            csmObject2 = (CsmScopeElement)csmScope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject csmObject) {
        assert (csmObject != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject));
        }
        return false;
    }

    static BaseDocument getDocument(CsmFile csmFile) {
        BaseDocument baseDocument = null;
        try {
            baseDocument = ReferencesSupport.getBaseDocument(((Object)csmFile.getAbsolutePath()).toString());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        return baseDocument;
    }

    static CsmReferenceKind getReferenceKind(CsmReference csmReference) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.UNKNOWN;
        CsmObject csmObject = csmReference.getOwner();
        if (CsmKindUtilities.isType((CsmObject)csmObject) || CsmKindUtilities.isInheritance((CsmObject)csmObject)) {
            csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
        } else if (CsmKindUtilities.isInclude((CsmObject)csmObject)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else {
            CsmObject csmObject2 = csmReference.getReferencedObject();
            if (csmObject2 == null) {
                csmReferenceKind = ReferencesSupport.getReferenceUsageKind(csmReference);
            } else {
                CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject2, (boolean)true);
                CsmObject csmObject3 = csmObjectArray[0];
                CsmObject csmObject4 = csmObjectArray[1];
                assert (csmObject3 != null);
                csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
                if (csmObject != null) {
                    csmReferenceKind = csmObject.equals(csmObject3) ? CsmReferenceKind.DECLARATION : (csmObject.equals(csmObject4) ? CsmReferenceKind.DEFINITION : ReferencesSupport.getReferenceUsageKind(csmReference));
                }
            }
        }
        return csmReferenceKind;
    }

    static CsmReferenceKind getReferenceUsageKind(final CsmReference csmReference) {
        final CsmReferenceKind[] csmReferenceKindArray = new CsmReferenceKind[]{CsmReferenceKind.DIRECT_USAGE};
        if (csmReference instanceof ReferenceImpl) {
            CsmReferenceKind csmReferenceKind = ReferencesSupport.getRefKindIfPossible(csmReference);
            if (csmReferenceKind != null) {
                return csmReferenceKind;
            }
            final BaseDocument baseDocument = ReferencesSupport.getRefDocument(csmReference);
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    int n = csmReference.getStartOffset();
                    Token token = CndTokenUtilities.shiftToNonWhiteBwd((Document)baseDocument, (int)n);
                    if (token != null) {
                        switch ((CppTokenId)token.id()) {
                            case DOT: 
                            case DOTMBR: 
                            case ARROW: 
                            case ARROWMBR: 
                            case SCOPE: {
                                csmReferenceKindArray[0] = CsmReferenceKind.AFTER_DEREFERENCE_USAGE;
                            }
                        }
                    }
                }
            });
        }
        return csmReferenceKindArray[0];
    }
}

