/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Style;
import org.w3c.tidy.StyleProp;
import org.w3c.tidy.TagTable;

public class Clean {
    private int classNum = 1;
    private TagTable tt;

    public Clean(TagTable tt) {
        this.tt = tt;
    }

    private StyleProp insertProperty(StyleProp props, String name, String value) {
        StyleProp prev = null;
        StyleProp first = props;
        while (props != null) {
            int cmp = props.name.compareTo(name);
            if (cmp == 0) {
                return first;
            }
            if (cmp > 0) {
                StyleProp prop = new StyleProp(name, value, props);
                if (prev != null) {
                    prev.next = prop;
                } else {
                    first = prop;
                }
                return first;
            }
            prev = props;
            props = props.next;
        }
        StyleProp prop = new StyleProp(name, value);
        if (prev != null) {
            prev.next = prop;
        } else {
            first = prop;
        }
        return first;
    }

    private StyleProp createProps(StyleProp prop, String style) {
        int value_start = 0;
        int name_start = 0;
        name_start = 0;
        while (name_start < style.length()) {
            int value_end;
            int name_end;
            while (name_start < style.length() && style.charAt(name_start) == ' ') {
                ++name_start;
            }
            for (name_end = name_start; name_end < style.length(); ++name_end) {
                if (style.charAt(name_end) != ':') continue;
                value_start = name_end + 1;
                break;
            }
            if (name_end >= style.length() || style.charAt(name_end) != ':') break;
            while (value_start < style.length() && style.charAt(value_start) == ' ') {
                ++value_start;
            }
            boolean more = false;
            for (value_end = value_start; value_end < style.length(); ++value_end) {
                if (style.charAt(value_end) != ';') continue;
                more = true;
                break;
            }
            prop = this.insertProperty(prop, style.substring(name_start, name_end), style.substring(value_start, value_end));
            if (!more) break;
            name_start = value_end + 1;
        }
        return prop;
    }

    private String createPropString(StyleProp props) {
        String style = "";
        int len = 0;
        StyleProp prop = props;
        while (prop != null) {
            len += prop.name.length() + 2;
            len += prop.value.length() + 2;
            prop = prop.next;
        }
        prop = props;
        while (prop != null) {
            style = style.concat(prop.name);
            style = style.concat(": ");
            style = style.concat(prop.value);
            if (prop.next == null) break;
            style = style.concat("; ");
            prop = prop.next;
        }
        return style;
    }

    private String addProperty(String style, String property) {
        StyleProp prop = this.createProps(null, style);
        prop = this.createProps(prop, property);
        style = this.createPropString(prop);
        return style;
    }

    private String gensymClass(String tag) {
        String str = "c" + this.classNum;
        ++this.classNum;
        return str;
    }

    private String findStyle(Lexer lexer, String tag, String properties) {
        Style style = lexer.styles;
        while (style != null) {
            if (style.tag.equals(tag) && style.properties.equals(properties)) {
                return style.tagClass;
            }
            style = style.next;
        }
        lexer.styles = style = new Style(tag, this.gensymClass(tag), properties, lexer.styles);
        return style.tagClass;
    }

    private void style2Rule(Lexer lexer, Node node) {
        AttVal styleattr = node.getAttrByName("style");
        if (styleattr != null) {
            String classname = this.findStyle(lexer, node.element, styleattr.value);
            AttVal classattr = node.getAttrByName("class");
            if (classattr != null) {
                classattr.value = classattr.value + " " + classname;
                node.removeAttribute(styleattr);
            } else {
                styleattr.attribute = "class";
                styleattr.value = classname;
            }
        }
    }

    private void addColorRule(Lexer lexer, String selector, String color) {
        if (color != null) {
            lexer.addStringLiteral(selector);
            lexer.addStringLiteral(" { color: ");
            lexer.addStringLiteral(color);
            lexer.addStringLiteral(" }\n");
        }
    }

    private void cleanBodyAttrs(Lexer lexer, Node body) {
        String bgurl = null;
        String bgcolor = null;
        String color = null;
        AttVal attr = body.getAttrByName("background");
        if (attr != null) {
            bgurl = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("bgcolor")) != null) {
            bgcolor = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("text")) != null) {
            color = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if (bgurl != null || bgcolor != null || color != null) {
            lexer.addStringLiteral(" body {\n");
            if (bgurl != null) {
                lexer.addStringLiteral("  background-image: url(");
                lexer.addStringLiteral(bgurl);
                lexer.addStringLiteral(");\n");
            }
            if (bgcolor != null) {
                lexer.addStringLiteral("  background-color: ");
                lexer.addStringLiteral(bgcolor);
                lexer.addStringLiteral(";\n");
            }
            if (color != null) {
                lexer.addStringLiteral("  color: ");
                lexer.addStringLiteral(color);
                lexer.addStringLiteral(";\n");
            }
            lexer.addStringLiteral(" }\n");
        }
        if ((attr = body.getAttrByName("link")) != null) {
            this.addColorRule(lexer, " :link", attr.value);
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("vlink")) != null) {
            this.addColorRule(lexer, " :visited", attr.value);
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("alink")) != null) {
            this.addColorRule(lexer, " :active", attr.value);
            body.removeAttribute(attr);
        }
    }

    private boolean niceBody(Lexer lexer, Node doc) {
        Node body = doc.findBody(lexer.configuration.tt);
        if (body != null && (body.getAttrByName("background") != null || body.getAttrByName("bgcolor") != null || body.getAttrByName("text") != null || body.getAttrByName("link") != null || body.getAttrByName("vlink") != null || body.getAttrByName("alink") != null)) {
            lexer.badLayout = (short)(lexer.badLayout | 0x10);
            return false;
        }
        return true;
    }

    private void createStyleElement(Lexer lexer, Node doc) {
        if (lexer.styles == null && this.niceBody(lexer, doc)) {
            return;
        }
        Node node = lexer.newNode((short)5, null, 0, 0, "style");
        node.implicit = true;
        AttVal av = new AttVal(null, null, 34, "type", "text/css");
        av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
        node.attributes = av;
        Node body = doc.findBody(lexer.configuration.tt);
        lexer.txtstart = lexer.lexsize;
        if (body != null) {
            this.cleanBodyAttrs(lexer, body);
        }
        Style style = lexer.styles;
        while (style != null) {
            lexer.addCharToLexer(32);
            lexer.addStringLiteral(style.tag);
            lexer.addCharToLexer(46);
            lexer.addStringLiteral(style.tagClass);
            lexer.addCharToLexer(32);
            lexer.addCharToLexer(123);
            lexer.addStringLiteral(style.properties);
            lexer.addCharToLexer(125);
            lexer.addCharToLexer(10);
            style = style.next;
        }
        lexer.txtend = lexer.lexsize;
        Node.insertNodeAtEnd(node, lexer.newNode((short)4, lexer.lexbuf, lexer.txtstart, lexer.txtend));
        Node head = doc.findHEAD(lexer.configuration.tt);
        if (head != null) {
            Node.insertNodeAtEnd(head, node);
        }
    }

    private void fixNodeLinks(Node node) {
        if (node.prev != null) {
            node.prev.next = node;
        } else {
            node.parent.content = node;
        }
        if (node.next != null) {
            node.next.prev = node;
        } else {
            node.parent.last = node;
        }
        Node child = node.content;
        while (child != null) {
            child.parent = node;
            child = child.next;
        }
    }

    private void stripOnlyChild(Node node) {
        Node child = node.content;
        node.content = child.content;
        node.last = child.last;
        child.content = null;
        child = node.content;
        while (child != null) {
            child.parent = node;
            child = child.next;
        }
    }

    private void discardContainer(Node element, MutableObject pnode) {
        Node parent = element.parent;
        if (element.content != null) {
            element.last.next = element.next;
            if (element.next != null) {
                element.next.prev = element.last;
                element.last.next = element.next;
            } else {
                parent.last = element.last;
            }
            if (element.prev != null) {
                element.content.prev = element.prev;
                element.prev.next = element.content;
            } else {
                parent.content = element.content;
            }
            Node node = element.content;
            while (node != null) {
                node.parent = parent;
                node = node.next;
            }
            pnode.setObject(element.content);
        } else {
            if (element.next != null) {
                element.next.prev = element.prev;
            } else {
                parent.last = element.prev;
            }
            if (element.prev != null) {
                element.prev.next = element.next;
            } else {
                parent.content = element.next;
            }
            pnode.setObject(element.next);
        }
        element.next = null;
        element.content = null;
    }

    private void addStyleProperty(Node node, String property) {
        AttVal av = node.attributes;
        while (av != null && !av.attribute.equals("style")) {
            av = av.next;
        }
        if (av != null) {
            String s;
            av.value = s = this.addProperty(av.value, property);
        } else {
            av = new AttVal(node.attributes, null, 34, "style", property);
            av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
            node.attributes = av;
        }
    }

    private String mergeProperties(String s1, String s2) {
        StyleProp prop = this.createProps(null, s1);
        prop = this.createProps(prop, s2);
        String s = this.createPropString(prop);
        return s;
    }

    private void mergeStyles(Node node, Node child) {
        String s2 = null;
        AttVal av = child.attributes;
        while (av != null) {
            if (av.attribute.equals("style")) {
                s2 = av.value;
                break;
            }
            av = av.next;
        }
        String s1 = null;
        av = node.attributes;
        while (av != null) {
            if (av.attribute.equals("style")) {
                s1 = av.value;
                break;
            }
            av = av.next;
        }
        if (s1 != null) {
            if (s2 != null) {
                String style;
                av.value = style = this.mergeProperties(s1, s2);
            }
        } else if (s2 != null) {
            av = new AttVal(node.attributes, null, 34, "style", s2);
            av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
            node.attributes = av;
        }
    }

    private String fontSize2Name(String size) {
        String[] sizes = new String[]{"60%", "70%", "80%", null, "120%", "150%", "200%"};
        if (size.length() > 0 && '0' <= size.charAt(0) && size.charAt(0) <= '6') {
            int n = size.charAt(0) - 48;
            return sizes[n];
        }
        if (size.length() > 0 && size.charAt(0) == '-') {
            if (size.length() > 1 && '0' <= size.charAt(1) && size.charAt(1) <= '6') {
                double x = 1.0;
                for (int n = size.charAt(1) - 48; n > 0; --n) {
                    x *= 0.8;
                }
                String buf = "" + (int)(x *= 100.0) + "%";
                return buf;
            }
            return "smaller";
        }
        if (size.length() > 1 && '0' <= size.charAt(1) && size.charAt(1) <= '6') {
            double x = 1.0;
            for (int n = size.charAt(1) - 48; n > 0; --n) {
                x *= 1.2;
            }
            String buf = "" + (int)(x *= 100.0) + "%";
            return buf;
        }
        return "larger";
    }

    private void addFontFace(Node node, String face) {
        this.addStyleProperty(node, "font-family: " + face);
    }

    private void addFontSize(Node node, String size) {
        if (size.equals("6") && node.tag == this.tt.tagP) {
            node.element = "h1";
            this.tt.findTag(node);
            return;
        }
        if (size.equals("5") && node.tag == this.tt.tagP) {
            node.element = "h2";
            this.tt.findTag(node);
            return;
        }
        if (size.equals("4") && node.tag == this.tt.tagP) {
            node.element = "h3";
            this.tt.findTag(node);
            return;
        }
        String value = this.fontSize2Name(size);
        if (value != null) {
            this.addStyleProperty(node, "font-size: " + value);
        }
    }

    private void addFontColor(Node node, String color) {
        this.addStyleProperty(node, "color: " + color);
    }

    private void addAlign(Node node, String align) {
        this.addStyleProperty(node, "text-align: " + align.toLowerCase());
    }

    private void addFontStyles(Node node, AttVal av) {
        while (av != null) {
            if (av.attribute.equals("face")) {
                this.addFontFace(node, av.value);
            } else if (av.attribute.equals("size")) {
                this.addFontSize(node, av.value);
            } else if (av.attribute.equals("color")) {
                this.addFontColor(node, av.value);
            }
            av = av.next;
        }
    }

    private void textAlign(Lexer lexer, Node node) {
        AttVal prev = null;
        AttVal av = node.attributes;
        while (av != null) {
            if (av.attribute.equals("align")) {
                if (prev != null) {
                    prev.next = av.next;
                } else {
                    node.attributes = av.next;
                }
                if (av.value == null) break;
                this.addAlign(node, av.value);
                break;
            }
            prev = av;
            av = av.next;
        }
    }

    private boolean dir2Div(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == this.tt.tagDir || node.tag == this.tt.tagUl || node.tag == this.tt.tagOl) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag != this.tt.tagLi) {
                return false;
            }
            if (!child.implicit) {
                return false;
            }
            node.tag = this.tt.tagDiv;
            node.element = "div";
            this.addStyleProperty(node, "margin-left: 2em");
            this.stripOnlyChild(node);
            return true;
        }
        return false;
    }

    private boolean center2Div(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == this.tt.tagCenter) {
            if (lexer.configuration.DropFontTags) {
                if (node.content != null) {
                    Node last = node.last;
                    Node parent = node.parent;
                    this.discardContainer(node, pnode);
                    node = lexer.inferredTag("br");
                    if (last.next != null) {
                        last.next.prev = node;
                    }
                    node.next = last.next;
                    last.next = node;
                    node.prev = last;
                    if (parent.last == last) {
                        parent.last = node;
                    }
                    node.parent = parent;
                } else {
                    Node prev = node.prev;
                    Node next = node.next;
                    Node parent = node.parent;
                    this.discardContainer(node, pnode);
                    node = lexer.inferredTag("br");
                    node.next = next;
                    node.prev = prev;
                    node.parent = parent;
                    if (next != null) {
                        next.prev = node;
                    } else {
                        parent.last = node;
                    }
                    if (prev != null) {
                        prev.next = node;
                    } else {
                        parent.content = node;
                    }
                }
                return true;
            }
            node.tag = this.tt.tagDiv;
            node.element = "div";
            this.addStyleProperty(node, "text-align: center");
            return true;
        }
        return false;
    }

    private boolean mergeDivs(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag != this.tt.tagDiv) {
            return false;
        }
        Node child = node.content;
        if (child == null) {
            return false;
        }
        if (child.tag != this.tt.tagDiv) {
            return false;
        }
        if (child.next != null) {
            return false;
        }
        this.mergeStyles(node, child);
        this.stripOnlyChild(node);
        return true;
    }

    private boolean nestedList(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == this.tt.tagUl || node.tag == this.tt.tagOl) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            Node list = child.content;
            if (list == null) {
                return false;
            }
            if (list.tag != node.tag) {
                return false;
            }
            pnode.setObject(node.next);
            list.prev = node.prev;
            list.next = node.next;
            list.parent = node.parent;
            this.fixNodeLinks(list);
            child.content = null;
            node.content = null;
            node.next = null;
            if (list.prev != null) {
                node = list;
                list = node.prev;
                if (list.tag == this.tt.tagUl || list.tag == this.tt.tagOl) {
                    list.next = node.next;
                    if (list.next != null) {
                        list.next.prev = list;
                    }
                    node.parent = child = list.last;
                    node.next = null;
                    node.prev = child.last;
                    this.fixNodeLinks(node);
                }
            }
            this.cleanNode(lexer, node);
            return true;
        }
        return false;
    }

    private boolean blockStyle(Lexer lexer, Node node, MutableObject pnode) {
        if ((node.tag.model & 0xE8) != 0 && node.tag != this.tt.tagTable && node.tag != this.tt.tagTr && node.tag != this.tt.tagLi) {
            Node child;
            if (node.tag != this.tt.tagCaption) {
                this.textAlign(lexer, node);
            }
            if ((child = node.content) == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag == this.tt.tagB) {
                this.mergeStyles(node, child);
                this.addStyleProperty(node, "font-weight: bold");
                this.stripOnlyChild(node);
                return true;
            }
            if (child.tag == this.tt.tagI) {
                this.mergeStyles(node, child);
                this.addStyleProperty(node, "font-style: italic");
                this.stripOnlyChild(node);
                return true;
            }
            if (child.tag == this.tt.tagFont) {
                this.mergeStyles(node, child);
                this.addFontStyles(node, child.attributes);
                this.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private boolean inlineStyle(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag != this.tt.tagFont && (node.tag.model & 0x210) != 0) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag == this.tt.tagB && lexer.configuration.LogicalEmphasis) {
                this.mergeStyles(node, child);
                this.addStyleProperty(node, "font-weight: bold");
                this.stripOnlyChild(node);
                return true;
            }
            if (child.tag == this.tt.tagI && lexer.configuration.LogicalEmphasis) {
                this.mergeStyles(node, child);
                this.addStyleProperty(node, "font-style: italic");
                this.stripOnlyChild(node);
                return true;
            }
            if (child.tag == this.tt.tagFont) {
                this.mergeStyles(node, child);
                this.addFontStyles(node, child.attributes);
                this.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private boolean font2Span(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == this.tt.tagFont) {
            if (lexer.configuration.DropFontTags) {
                this.discardContainer(node, pnode);
                return false;
            }
            if (node.parent.content == node && node.next == null) {
                return false;
            }
            this.addFontStyles(node, node.attributes);
            AttVal av = node.attributes;
            AttVal style = null;
            while (av != null) {
                AttVal next = av.next;
                if (av.attribute.equals("style")) {
                    av.next = null;
                    style = av;
                }
                av = next;
            }
            node.attributes = style;
            node.tag = this.tt.tagSpan;
            node.element = "span";
            return true;
        }
        return false;
    }

    private Node cleanNode(Lexer lexer, Node node) {
        Node next = null;
        MutableObject o = new MutableObject();
        boolean b = false;
        next = node;
        while (node.isElement()) {
            o.setObject(next);
            b = this.dir2Div(lexer, node, o);
            next = (Node)o.getObject();
            if (!b) {
                b = this.nestedList(lexer, node, o);
                next = (Node)o.getObject();
                if (!b) {
                    b = this.center2Div(lexer, node, o);
                    next = (Node)o.getObject();
                    if (!b) {
                        b = this.mergeDivs(lexer, node, o);
                        next = (Node)o.getObject();
                        if (!b) {
                            b = this.blockStyle(lexer, node, o);
                            next = (Node)o.getObject();
                            if (!b) {
                                b = this.inlineStyle(lexer, node, o);
                                next = (Node)o.getObject();
                                if (!b) {
                                    b = this.font2Span(lexer, node, o);
                                    next = (Node)o.getObject();
                                    if (!b) break;
                                }
                            }
                        }
                    }
                }
            }
            node = next;
        }
        return next;
    }

    private Node createStyleProperties(Lexer lexer, Node node) {
        if (node.content != null) {
            Node child = node.content;
            while (child != null) {
                child = this.createStyleProperties(lexer, child);
                child = child.next;
            }
        }
        return this.cleanNode(lexer, node);
    }

    private void defineStyleRules(Lexer lexer, Node node) {
        if (node.content != null) {
            Node child = node.content;
            while (child != null) {
                this.defineStyleRules(lexer, child);
                child = child.next;
            }
        }
        this.style2Rule(lexer, node);
    }

    public void cleanTree(Lexer lexer, Node doc) {
        doc = this.createStyleProperties(lexer, doc);
        if (!lexer.configuration.MakeClean) {
            this.defineStyleRules(lexer, doc);
            this.createStyleElement(lexer, doc);
        }
    }

    public void nestedEmphasis(Node node) {
        MutableObject o = new MutableObject();
        while (node != null) {
            Node next = node.next;
            if ((node.tag == this.tt.tagB || node.tag == this.tt.tagI) && node.parent != null && node.parent.tag == node.tag) {
                o.setObject(next);
                this.discardContainer(node, o);
                node = next = (Node)o.getObject();
                continue;
            }
            if (node.content != null) {
                this.nestedEmphasis(node.content);
            }
            node = next;
        }
    }

    public void emFromI(Node node) {
        while (node != null) {
            if (node.tag == this.tt.tagI) {
                node.element = this.tt.tagEm.name;
                node.tag = this.tt.tagEm;
            } else if (node.tag == this.tt.tagB) {
                node.element = this.tt.tagStrong.name;
                node.tag = this.tt.tagStrong;
            }
            if (node.content != null) {
                this.emFromI(node.content);
            }
            node = node.next;
        }
    }

    public void list2BQ(Node node) {
        while (node != null) {
            if (node.content != null) {
                this.list2BQ(node.content);
            }
            if (node.tag != null && node.tag.parser == ParserImpl.getParseList() && node.hasOneChild() && node.content.implicit) {
                this.stripOnlyChild(node);
                node.element = this.tt.tagBlockquote.name;
                node.tag = this.tt.tagBlockquote;
                node.implicit = true;
            }
            node = node.next;
        }
    }

    public void bQ2Div(Node node) {
        while (node != null) {
            if (node.tag == this.tt.tagBlockquote && node.implicit) {
                int indent = 1;
                while (node.hasOneChild() && node.content.tag == this.tt.tagBlockquote && node.implicit) {
                    ++indent;
                    this.stripOnlyChild(node);
                }
                if (node.content != null) {
                    this.bQ2Div(node.content);
                }
                String indent_buf = "margin-left: " + new Integer(2 * indent).toString() + "em";
                node.element = this.tt.tagDiv.name;
                node.tag = this.tt.tagDiv;
                node.addAttribute("style", indent_buf);
            } else if (node.content != null) {
                this.bQ2Div(node.content);
            }
            node = node.next;
        }
    }

    public Node pruneSection(Lexer lexer, Node node) {
        while (true) {
            if ((node = Node.discardElement(node)) == null) {
                return null;
            }
            if (node.type != 9) continue;
            if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                node = this.pruneSection(lexer, node);
                continue;
            }
            if (Lexer.getString(node.textarray, node.start, 5).equals("endif")) break;
        }
        node = Node.discardElement(node);
        return node;
    }

    public void dropSections(Lexer lexer, Node node) {
        while (node != null) {
            if (node.type == 9) {
                if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                    node = this.pruneSection(lexer, node);
                    continue;
                }
                node = Node.discardElement(node);
                continue;
            }
            if (node.content != null) {
                this.dropSections(lexer, node.content);
            }
            node = node.next;
        }
    }

    public void purgeAttributes(Node node) {
        AttVal attr = node.attributes;
        AttVal next = null;
        AttVal prev = null;
        while (attr != null) {
            next = attr.next;
            if (attr.attribute != null && attr.value != null && attr.attribute.equals("class") && attr.value.equals("Code")) {
                prev = attr;
            } else if (attr.attribute != null && (attr.attribute.equals("class") || attr.attribute.equals("style") || attr.attribute.equals("lang") || attr.attribute.startsWith("x:") || (attr.attribute.equals("height") || attr.attribute.equals("width")) && (node.tag == this.tt.tagTd || node.tag == this.tt.tagTr || node.tag == this.tt.tagTh))) {
                if (prev != null) {
                    prev.next = next;
                } else {
                    node.attributes = next;
                }
            } else {
                prev = attr;
            }
            attr = next;
        }
    }

    public Node stripSpan(Lexer lexer, Node span) {
        Node node;
        Node prev = null;
        this.cleanWord2000(lexer, span.content);
        Node content = span.content;
        if (span.prev != null) {
            prev = span.prev;
        } else if (content != null) {
            node = content;
            content = content.next;
            Node.removeNode(node);
            Node.insertNodeBeforeElement(span, node);
            prev = node;
        }
        while (content != null) {
            node = content;
            content = content.next;
            Node.removeNode(node);
            Node.insertNodeAfterElement(prev, node);
            prev = node;
        }
        if (span.next == null) {
            span.parent.last = prev;
        }
        node = span.next;
        span.content = null;
        Node.discardElement(span);
        return node;
    }

    private void normalizeSpaces(Lexer lexer, Node node) {
        while (node != null) {
            if (node.content != null) {
                this.normalizeSpaces(lexer, node.content);
            }
            if (node.type == 4) {
                MutableInteger c = new MutableInteger();
                int p = node.start;
                for (int i = node.start; i < node.end; ++i) {
                    c.value = node.textarray[i];
                    if (c.value > 127) {
                        i += PPrint.getUTF8(node.textarray, i, c);
                    }
                    if (c.value == 160) {
                        c.value = 32;
                    }
                    p = PPrint.putUTF8(node.textarray, p, c.value);
                }
            }
            node = node.next;
        }
    }

    public void cleanWord2000(Lexer lexer, Node node) {
        Node list = null;
        while (node != null) {
            AttVal attr;
            if (node.tag == this.tt.tagStyle || node.tag == this.tt.tagMeta || node.type == 2) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == this.tt.tagSpan) {
                node = this.stripSpan(lexer, node);
                continue;
            }
            if (node.tag == this.tt.tagHtml && node.getAttrByName("xmlns:o") == null) {
                return;
            }
            if (node.tag == this.tt.tagLink && (attr = node.getAttrByName("rel")) != null && attr.value != null && attr.value.equals("File-List")) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.content == null && node.tag == this.tt.tagP) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == this.tt.tagP) {
                attr = node.getAttrByName("class");
                if (attr != null && attr.value != null && attr.value.equals("MsoListBullet")) {
                    Node.coerceNode(lexer, node, this.tt.tagLi);
                    if (list == null || list.tag != this.tt.tagUl) {
                        list = lexer.inferredTag("ul");
                        Node.insertNodeBeforeElement(node, list);
                    }
                    this.purgeAttributes(node);
                    if (node.content != null) {
                        this.cleanWord2000(lexer, node.content);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(list, node);
                    node = list.next;
                } else if (attr != null && attr.value != null && attr.value.equals("Code")) {
                    Node br = lexer.newLineNode();
                    this.normalizeSpaces(lexer, node);
                    if (list == null || list.tag != this.tt.tagPre) {
                        list = lexer.inferredTag("pre");
                        Node.insertNodeBeforeElement(node, list);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(list, node);
                    this.stripSpan(lexer, node);
                    Node.insertNodeAtEnd(list, br);
                    node = list.next;
                } else {
                    list = null;
                }
            } else {
                list = null;
            }
            if (node.type == 5 || node.type == 7) {
                this.purgeAttributes(node);
            }
            if (node.content != null) {
                this.cleanWord2000(lexer, node.content);
            }
            node = node.next;
        }
    }

    public boolean isWord2000(Node root, TagTable tt) {
        Node html = root.findHTML(tt);
        return html != null && html.getAttrByName("xmlns:o") != null;
    }
}

