/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.text;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssValue;
import org.netbeans.modules.visualweb.api.designer.cssengine.StyleData;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.designer.jsf.text.DomPositionImpl;
import org.netbeans.modules.visualweb.designer.jsf.text.DomRangeImpl;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.netbeans.modules.visualweb.xhtml.Br;
import org.netbeans.modules.visualweb.xhtml.Li;
import org.netbeans.modules.visualweb.xhtml.P;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DomDocumentImpl
implements DomProvider.DomDocument {
    private JsfForm jsfForm;
    private final EventListenerList listenerList = new EventListenerList();

    public DomDocumentImpl(JsfForm jsfForm) {
        this.jsfForm = jsfForm;
    }

    public String toString() {
        return super.toString() + "[jsfForm=" + this.jsfForm + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertString(Designer designer, DomProvider.DomRange domRange, String string) {
        if (domRange == null) {
            return false;
        }
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_InsertText"));
        try {
            Object object;
            Node node;
            if (!domRange.isEmpty()) {
                this.deleteRangeContents(domRange);
            }
            DomProvider.DomPosition domPosition = domRange.getDot();
            if (!designer.isInlineEditing() && domPosition != DomProvider.DomPosition.NONE && this.isRenderedNode(domPosition.getNode())) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be not rendered, node=" + domPosition.getNode()));
                boolean bl = false;
                return bl;
            }
            if (domPosition == DomProvider.DomPosition.NONE) {
                boolean bl = false;
                return bl;
            }
            if (domPosition == null || domPosition == DomProvider.DomPosition.NONE) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException("Invalid position, pos=" + domPosition));
                boolean bl = false;
                return bl;
            }
            Element element = this.jsfForm.getHtmlBody();
            if (domPosition.getNode() == element || domPosition.getNode().getParentNode() == element && domPosition.getNode().getNodeType() == 3 && JsfSupportUtilities.onlyWhitespace(domPosition.getNode().getNodeValue())) {
                node = null;
                node = domPosition.getNode() == element ? element.getChildNodes().item(domPosition.getOffset()) : domPosition.getNode().getNextSibling();
                Element element2 = this.createElement(P.class.getName(), element, node);
                this.createElement(Br.class.getName(), element2, null);
                this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(element2, 0, DomProvider.DomPosition.Bias.FORWARD)));
            }
            if (string.equals("\n") || string.equals("\r\n")) {
                this.insertNewline(domPosition.getNode(), domPosition.getOffset());
                boolean bl = true;
                return bl;
            }
            if (string.equals("&") && !DomDocumentImpl.isHtmlNode(this.jsfForm, domPosition.getNode())) {
                string = "&amp;";
            }
            node = domPosition.getNode();
            int n = domPosition.getOffset();
            Object object2 = node;
            int n2 = n;
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                object = (Text)node;
                if (string.length() == 1 && string.charAt(0) == ' ') {
                    this.insertSpace(domPosition.getNode(), domPosition.getOffset());
                    boolean bl = true;
                    return bl;
                }
                object.insertData(n, string);
                object2 = object;
                this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition((Node)object2, n2 += string.length(), domPosition.getBias())));
            } else if (node.getNodeType() == 1 || node.getNodeType() == 11) {
                object = node.getChildNodes();
                int n3 = object.getLength();
                if (n3 == 0 || n >= n3) {
                    Document document = this.jsfForm.getJspDom();
                    Text text = document.createTextNode(string);
                    if (MarkupService.isJspxNode((Node)node)) {
                        MarkupService.markJspxSource((Node)text);
                    }
                    node.appendChild(text);
                    this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(text, string.length(), DomProvider.DomPosition.Bias.FORWARD)));
                    boolean bl = true;
                    return bl;
                }
                if (n < n3) {
                    if (n > 0 && object.item(n - 1) instanceof Text) {
                        CharacterData characterData = (CharacterData)object.item(n - 1);
                        characterData.appendData(string);
                        this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(characterData, characterData.getLength(), domPosition.getBias())));
                        boolean bl = true;
                        return bl;
                    }
                    Document document = this.jsfForm.getJspDom();
                    Text text = document.createTextNode(string);
                    if (MarkupService.isJspxNode((Node)node)) {
                        MarkupService.markJspxSource((Node)text);
                    }
                    Node node2 = object.item(n);
                    node.insertBefore(text, node2);
                    this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(text, string.length(), DomProvider.DomPosition.Bias.FORWARD)));
                    boolean bl = true;
                    return bl;
                }
            } else {
                ErrorManager.getDefault().log("Unexpected node: " + n + ", str=" + string);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    public boolean deleteRangeContents(DomProvider.DomRange domRange) {
        if (domRange instanceof DomRangeImpl) {
            DomRangeImpl domRangeImpl = (DomRangeImpl)domRange;
            DomProvider.DomPosition domPosition = domRangeImpl.getFirstPosition();
            DomProvider.DomPosition domPosition2 = domRangeImpl.getLastPosition();
            if (!this.jsfForm.isInlineEditing() && (this.isRenderedNode(domPosition.getNode()) || this.isRenderedNode(domPosition2.getNode()))) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("It is not inline editing, nor both positions are source ones,\nstartPosition=" + domPosition + "\nendPosition=" + domPosition2));
                return false;
            }
            this.deleteComponents(domPosition, domPosition2);
            return domRangeImpl.deleteRangeContents();
        }
        return false;
    }

    public String getRangeText(DomProvider.DomRange domRange) {
        if (domRange instanceof DomRangeImpl) {
            DomRangeImpl domRangeImpl = (DomRangeImpl)domRange;
            DomProvider.DomPosition domPosition = domRangeImpl.getFirstPosition();
            DomProvider.DomPosition domPosition2 = domRangeImpl.getLastPosition();
            return this.getText(domPosition, domPosition2);
        }
        return "";
    }

    private static boolean isHtmlNode(JsfForm jsfForm, Node node) {
        if (node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        if (node == null || !(node instanceof Element)) {
            return false;
        }
        if (jsfForm.isRenderedNode(node)) {
            return true;
        }
        return jsfForm.isInlineEditing();
    }

    private static boolean haveMoreInlineContent(Node node) {
        while (node != null) {
            if (node instanceof Text) {
                return true;
            }
            if (node instanceof Element) {
                Element element = (Element)node;
                HtmlTag htmlTag = HtmlTag.getTag((String)element.getTagName());
                if (htmlTag == HtmlTag.BR) {
                    return true;
                }
                CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 22);
                if (CssProvider.getValueService().isInlineTag(cssValue, element, htmlTag)) {
                    return true;
                }
            }
            node = node.getNextSibling();
        }
        return false;
    }

    private void insertNewline(Node node, int n) {
        Object object;
        Text text = null;
        Node node2 = null;
        Node node3 = null;
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            text = (Text)node;
            node3 = text.getNextSibling();
            node2 = node.getParentNode();
        } else {
            node2 = node;
            object = node.getChildNodes();
            int n2 = object.getLength();
            if (n2 == 0 || n >= n2) {
                node3 = null;
            } else if (n < n2) {
                node3 = object.item(n);
            }
        }
        object = DomDocumentImpl.getListItemParent(node);
        if (object != null) {
            Element element = this.createElement(Li.class.getName(), object.getParentNode(), object.getNextSibling());
            DocumentRange documentRange = (DocumentRange)((Object)this.jsfForm.getJspDom());
            Range range = documentRange.createRange();
            range.setStart(node, n);
            DomProvider.DomPosition domPosition = this.createNextDomPosition((Node)object, true);
            range.setEnd(domPosition.getNode(), domPosition.getOffset());
            DocumentFragment documentFragment = range.extractContents();
            range.detach();
            NodeList nodeList = documentFragment.getChildNodes();
            if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element && ((Element)nodeList.item(0)).getTagName().equals(HtmlTag.LI.name)) {
                nodeList = nodeList.item(0).getChildNodes();
            }
            int n3 = nodeList.getLength();
            for (int i = 0; i < n3; ++i) {
                Node node4 = nodeList.item(i);
                if (node4 == null || (node4.getNodeType() == 3 || node4.getNodeType() == 4) && JsfSupportUtilities.onlyWhitespace(node4.getNodeValue())) continue;
                element.appendChild(node4);
            }
            if (element.getChildNodes().getLength() == 0) {
                this.createElement(Br.class.getName(), element, null);
            }
            if (node.getChildNodes().getLength() == 0) {
                this.createElement(Br.class.getName(), node, null);
            }
            this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(element, 0, DomProvider.DomPosition.Bias.FORWARD)));
        } else if (text == null || n == text.getLength()) {
            boolean bl = !DomDocumentImpl.haveMoreInlineContent(node3);
            boolean bl2 = true;
            Element element = this.createElement(Br.class.getName(), node2, node3);
            if (bl) {
                element = this.createElement(Br.class.getName(), node2, node3);
                bl2 = false;
            }
            if (node3 instanceof Element) {
                this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createNextDomPosition((Element)node3, false)));
            } else {
                this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createNextDomPosition(element, bl2)));
            }
        } else if (n == 0) {
            Element element = this.createElement(Br.class.getName(), node2, text);
            this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(text, 0, DomProvider.DomPosition.Bias.FORWARD)));
        } else {
            Text text2 = text.splitText(n);
            Element element = this.createElement(Br.class.getName(), text.getParentNode(), text2);
            if (JsfSupportUtilities.onlyWhitespace(text2.getNodeValue())) {
                boolean bl = true;
                if (text2.getNextSibling() != null) {
                    boolean bl3 = bl = !DomDocumentImpl.haveMoreInlineContent(text2.getNextSibling());
                }
                if (bl) {
                    element = this.createElement(Br.class.getName(), text.getParentNode(), text2.getNextSibling());
                    this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createNextDomPosition(element, false)));
                    return;
                }
            }
            this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(text2, 0, DomProvider.DomPosition.Bias.FORWARD)));
        }
    }

    private static Element getListItemParent(Node node) {
        while (node != null) {
            Element element;
            if (node.getNodeType() == 1 && (element = (Element)node).getTagName().equals(HtmlTag.LI.name)) {
                return element;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private void insertSpace(Node node, int n) {
        Text text = null;
        Node node2 = null;
        Node node3 = null;
        String string = " ";
        if (node.getNodeType() != 3 && node.getNodeType() != 4) {
            node2 = node;
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            if (n2 == 0 || n >= n2) {
                node3 = null;
            } else if (n < n2) {
                node3 = nodeList.item(n);
            }
            Document document = this.jsfForm.getJspDom();
            text = document.createTextNode(string);
            if (MarkupService.isJspxNode((Node)node)) {
                MarkupService.markJspxSource((Node)text);
            }
            node2.insertBefore(text, node3);
            this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(text, string.length(), DomProvider.DomPosition.Bias.FORWARD)));
            return;
        }
        text = (Text)node;
        String string2 = text.getData();
        int n3 = text.getLength();
        assert (n <= n3);
        boolean bl = n > 0 && string2.charAt(n - 1) == ' ';
        boolean bl2 = n < n3 && string2.charAt(n) == ' ';
        Node node4 = node;
        int n4 = n;
        if (bl || bl2) {
            if (bl) {
                --n;
            }
            if (!this.jsfForm.isInlineEditing()) {
                String string3 = MarkupService.isJspxNode((Node)node) ? "&nbsp;" : "\u00a0";
                string = string3;
            }
            text.insertData(n, string);
            node4 = text;
            n4 += string.length();
        } else {
            text.insertData(n, string);
            node4 = text;
            n4 += string.length();
        }
        this.fireInsertUpdate(new DefaultDomDocumentEvent(this, this.createDomPosition(node4, n4, DomProvider.DomPosition.Bias.FORWARD)));
    }

    private Element createElement(String string, Node node, Node node2) {
        return this.jsfForm.createComponent(string, node, node2);
    }

    private void deleteComponents(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        Object object;
        Node node;
        if (domPosition2 == DomProvider.DomPosition.NONE) {
            return;
        }
        Node node2 = domPosition.getNode();
        if (node2 instanceof Element && domPosition.getOffset() < node2.getChildNodes().getLength()) {
            node2 = node2.getChildNodes().item(domPosition.getOffset());
        }
        if (domPosition.equals(domPosition2)) {
            node = node2;
        } else if (node instanceof Element) {
            if (domPosition2.getOffset() > 0 && domPosition2.getOffset() <= node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(domPosition2.getOffset() - 1);
            } else if (domPosition2.getOffset() == 0) {
                for (node = domPosition2.getNode(); node != null && node.getPreviousSibling() == null; node = node.getParentNode()) {
                }
                if (node == null) {
                    ErrorManager.getDefault().log("Unexpected second position " + domPosition2);
                    return;
                }
                node = node.getPreviousSibling();
                while ((object = node.getChildNodes()).getLength() > 0) {
                    node = object.item(object.getLength() - 1);
                }
            }
        }
        if (node2 == node && node2 instanceof Text) {
            return;
        }
        object = new ArrayList();
        Document document = this.jsfForm.getJspDom();
        if (!(document instanceof DocumentTraversal)) {
            return;
        }
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(document, -1, null, false);
        Node node3 = node2;
        while (node3 != null) {
            try {
                node3 = nodeIterator.nextNode();
                if (node3 != node2) continue;
                break;
            }
            catch (DOMException dOMException) {
                ErrorManager.getDefault().notify(1, (Throwable)dOMException);
                break;
            }
        }
        Node node4 = node;
        while (node3 != null) {
            Element element;
            Element element2;
            if (node3 instanceof Element && (element2 = MarkupService.getRenderedElementForElement((Element)(element = (Element)node3))) != null && (element.getParentNode() == null || element.getParentNode() instanceof Element && MarkupService.getRenderedElementForElement((Element)((Element)element.getParentNode())) != element2) && !object.contains(element2)) {
                object.add(element2);
            }
            if (node3 == null || node3 == node4) break;
            try {
                node3 = nodeIterator.nextNode();
            }
            catch (DOMException dOMException) {
                ErrorManager.getDefault().notify((Throwable)dOMException);
                break;
            }
        }
        nodeIterator.detach();
        this.deleteComponents(object.toArray(new Element[object.size()]));
    }

    private String getText(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        Object object;
        Node node;
        if (domPosition2 == DomProvider.DomPosition.NONE) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Node node2 = domPosition.getNode();
        if (node2 instanceof Element && domPosition.getOffset() < node2.getChildNodes().getLength()) {
            node2 = node2.getChildNodes().item(domPosition.getOffset());
        }
        if (domPosition.equals(domPosition2)) {
            node = node2;
        } else if (node instanceof Element) {
            if (domPosition2.getOffset() > 0 && domPosition2.getOffset() <= node.getChildNodes().getLength()) {
                node = node.getChildNodes().item(domPosition2.getOffset() - 1);
            } else if (domPosition2.getOffset() == 0) {
                for (node = domPosition2.getNode(); node != null && node.getPreviousSibling() == null; node = node.getParentNode()) {
                }
                if (node == null) {
                    ErrorManager.getDefault().log("Unexpected second position " + domPosition2);
                    return "";
                }
                node = node.getPreviousSibling();
                while ((object = node.getChildNodes()).getLength() > 0) {
                    node = object.item(object.getLength() - 1);
                }
            }
        }
        if (node2 instanceof Text) {
            if (node == node2) {
                object = node2.getNodeValue();
                for (int i = domPosition.getOffset(); i < domPosition2.getOffset(); ++i) {
                    stringBuffer.append(((String)object).charAt(i));
                }
                return stringBuffer.toString();
            }
            object = node2.getNodeValue();
            int n = ((String)object).length();
            for (int i = domPosition.getOffset(); i < n; ++i) {
                stringBuffer.append(((String)object).charAt(i));
            }
        }
        if (!((object = this.jsfForm.getJspDom()) instanceof DocumentTraversal)) {
            return "";
        }
        DocumentTraversal documentTraversal = (DocumentTraversal)object;
        NodeIterator nodeIterator = documentTraversal.createNodeIterator((Node)object, -1, null, false);
        Node node3 = node2;
        while (node3 != null) {
            try {
                node3 = nodeIterator.nextNode();
                if (node3 != node2) continue;
                break;
            }
            catch (DOMException dOMException) {
                ErrorManager.getDefault().notify((Throwable)dOMException);
                break;
            }
        }
        Node node4 = node;
        while (node3 != null) {
            try {
                node3 = nodeIterator.nextNode();
            }
            catch (DOMException dOMException) {
                ErrorManager.getDefault().notify((Throwable)dOMException);
                break;
            }
            if (node3 == null || node3 == node4) break;
            if (!(node3 instanceof Text)) continue;
            stringBuffer.append(node3.getNodeValue());
        }
        nodeIterator.detach();
        if (node instanceof Text) {
            String string = node.getNodeValue();
            for (int i = 0; i < domPosition2.getOffset(); ++i) {
                stringBuffer.append(string.charAt(i));
            }
        }
        return stringBuffer.toString();
    }

    private void fireInsertUpdate(DomProvider.DomDocumentEvent domDocumentEvent) {
        for (DomProvider.DomDocumentListener domDocumentListener : this.getDomDocumentListeners()) {
            domDocumentListener.insertUpdate(domDocumentEvent);
        }
    }

    private void fireComponentMoved(DomProvider.DomDocumentEvent domDocumentEvent) {
        for (DomProvider.DomDocumentListener domDocumentListener : this.getDomDocumentListeners()) {
            domDocumentListener.componentMoved(domDocumentEvent);
        }
    }

    private void fireComponentsMoved(DomProvider.DomDocumentEvent domDocumentEvent) {
        for (DomProvider.DomDocumentListener domDocumentListener : this.getDomDocumentListeners()) {
            domDocumentListener.componentsMoved(domDocumentEvent);
        }
    }

    private void fireComponentMovedTo(DomProvider.DomDocumentEvent domDocumentEvent) {
        for (DomProvider.DomDocumentListener domDocumentListener : this.getDomDocumentListeners()) {
            domDocumentListener.componentMovedTo(domDocumentEvent);
        }
    }

    public void addDomDocumentListener(DomProvider.DomDocumentListener domDocumentListener) {
        this.listenerList.add(DomProvider.DomDocumentListener.class, domDocumentListener);
    }

    public void removeDomDocumentListener(DomProvider.DomDocumentListener domDocumentListener) {
        this.listenerList.remove(DomProvider.DomDocumentListener.class, domDocumentListener);
    }

    private DomProvider.DomDocumentListener[] getDomDocumentListeners() {
        return (DomProvider.DomDocumentListener[])this.listenerList.getListeners(DomProvider.DomDocumentListener.class);
    }

    public DomProvider.DomPosition createDomPosition(Node node, int n, DomProvider.DomPosition.Bias bias) {
        if (node == null) {
            return DomProvider.DomPosition.NONE;
        }
        return DomPositionImpl.create(this, node, n, bias);
    }

    public DomProvider.DomPosition createNextDomPosition(Node node, boolean bl) {
        if (node == null) {
            return DomProvider.DomPosition.NONE;
        }
        return DomPositionImpl.createNext(this, node, bl);
    }

    public DomProvider.DomRange createRange(Node node, int n, Node node2, int n2) {
        return DomRangeImpl.create(this, node, n, node2, n2);
    }

    public int compareBoudaryPoints(Node node, int n, Node node2, int n2) {
        return DomPositionImpl.compareBoundaryPoints(node, n, node2, n2);
    }

    public DomProvider.DomPosition first(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        return DomPositionImpl.first(domPosition, domPosition2);
    }

    public DomProvider.DomPosition last(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        return DomPositionImpl.last(domPosition, domPosition2);
    }

    private boolean reparentComponent(Element element, DomProvider.DomPosition domPosition) {
        Node node;
        if (domPosition == DomProvider.DomPosition.NONE) {
            return false;
        }
        DomProvider.DomPosition domPosition2 = this.createNextDomPosition(element, false);
        if (domPosition.equals(domPosition2)) {
            return true;
        }
        if (this.isRenderedNode(domPosition.getNode())) {
            domPosition = domPosition.getSourcePosition();
        }
        if (domPosition == DomProvider.DomPosition.NONE) {
            return false;
        }
        Node node2 = node = domPosition.getNode();
        while (node2.getParentNode() != null) {
            node2 = node2.getParentNode();
        }
        if (node2 != this.jsfForm.getJspDom()) {
            return false;
        }
        Node node3 = node;
        Node node4 = null;
        if (node instanceof Text) {
            node3 = node.getParentNode();
            if (domPosition.getOffset() == 0) {
                node4 = node;
            } else {
                Text text = (Text)node;
                node4 = domPosition.getOffset() < text.getLength() ? text.splitText(domPosition.getOffset()) : text.getNextSibling();
            }
        } else {
            node4 = node3.getFirstChild();
            int n = domPosition.getOffset();
            for (int n2 = 0; n2 < n && node4 != null; node4 = node4.getNextSibling(), ++n2) {
            }
        }
        if (node4 == element) {
            return true;
        }
        boolean bl = this.jsfForm.moveComponent(element, node3, node4);
        this.fireComponentMoved(new DefaultDomDocumentEvent(this, null));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveComponents(Designer designer, Designer.Box[] boxArray, Point[] pointArray, DomProvider.DomPosition domPosition, int n, int n2, boolean bl) {
        int n3 = boxArray.length;
        String string = n3 > 1 ? NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_MoveComponents") : NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_MoveComponent");
        UndoEvent undoEvent = this.jsfForm.writeLock(string);
        try {
            for (int i = 0; i < n3; ++i) {
                Designer.Box box = boxArray[i];
                Point point = pointArray[i];
                Element element = box.getComponentRootElement();
                int n4 = n + point.x;
                int n5 = n2 + point.y;
                if (bl) {
                    n4 = designer.snapX(n4, box.getPositionedBy());
                    n5 = designer.snapY(n5, box.getPositionedBy());
                }
                Designer.Box box2 = box.getParent();
                try {
                    Object object;
                    Object object2;
                    boolean bl2 = true;
                    if (domPosition != null && domPosition != DomProvider.DomPosition.NONE) {
                        bl2 = this.reparentComponent(element, domPosition);
                    } else if (!this.isAbsolutelyPositioned(element)) {
                        Designer.Box[] boxArray2;
                        Object object3;
                        object2 = null;
                        object = element;
                        Element element2 = MarkupService.getSourceElementForElement((Element)object);
                        if (element2 == null) {
                            object3 = MarkupUnit.getMarkupDesignBeanForElement((Element)object);
                            if (object3 != null) {
                                element2 = object3.getElement();
                            }
                            if (element2 == null) continue;
                        }
                        if (element2.getParentNode() != null && element2.getParentNode().getNodeType() == 1 && element2.getParentNode().getNodeName().equals(HtmlTag.FSUBVIEW.name)) {
                            object2 = (Element)element2.getParentNode();
                        } else {
                            Element element3 = object3 = box2 == null ? null : box2.getComponentRootElement();
                            if (object3 != null && (boxArray2 = MarkupService.getSourceElementForElement((Element)object3)) != null && boxArray2.getTagName().equals(HtmlTag.FORM.name)) {
                                object2 = boxArray2;
                            }
                        }
                        if (object2 == null && (object3 = designer.findBox(n4, n5)) != null) {
                            boxArray2 = object3.getChildren();
                            int n6 = boxArray2.length;
                            for (int j = 0; j < n6; ++j) {
                                Designer.Box box3 = boxArray2[j];
                                HtmlTag htmlTag = box3.getTag();
                                if (htmlTag != HtmlTag.FORM) continue;
                                object2 = box3.getSourceElement();
                                break;
                            }
                            if (object2 == null) {
                                object2 = object3.getSourceElement();
                            }
                        }
                        if (element2.getParentNode() != object2) {
                            bl2 = this.reparentComponent(element, this.createDomPosition((Node)object2, 0, DomProvider.DomPosition.Bias.FORWARD));
                        }
                        if ((object3 = designer.findBoxForSourceElement(object2)) != null) {
                            box2 = object3;
                        }
                    }
                    this.jsfForm.setUpdatesSuspended(element, true);
                    object2 = new ArrayList<StyleData>(3);
                    object = new ArrayList(3);
                    if (domPosition != null && domPosition != DomProvider.DomPosition.NONE) {
                        if (bl2) {
                            object.add(new StyleData(48));
                            object.add(new StyleData(39));
                            object.add(new StyleData(41));
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else if (bl2) {
                        object2.add(new StyleData(48, CssProvider.getValueService().getAbsoluteValue()));
                        object2.add(this.getHorizontalCssSetting(n4, box.getWidth(), box, box2, element));
                        object2.add(this.getVerticalCssSetting(n5, box.getHeight(), box, box2, element));
                    }
                    JsfSupportUtilities.updateLocalStyleValuesForElement(element, object2.toArray(new StyleData[object2.size()]), object.toArray(new StyleData[object.size()]));
                    continue;
                }
                finally {
                    this.jsfForm.setUpdatesSuspended(element, false);
                }
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
        this.fireComponentsMoved(new DefaultDomDocumentEvent(this, null));
    }

    private boolean isAbsolutelyPositioned(Element element) {
        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, 48);
        boolean bl = CssProvider.getValueService().isAbsoluteValue(cssValue) || CssProvider.getValueService().isFixedValue(cssValue);
        return bl;
    }

    private StyleData getHorizontalCssSetting(int n, int n2, Designer.Box box, Designer.Box box2, Element element) {
        int n3 = CssProvider.getValueService().getCssLength(element, 39);
        int n4 = CssProvider.getValueService().getCssLength(element, 40);
        if (n3 == 0x7FFFFFFE && n4 != 0x7FFFFFFE) {
            int n5 = this.translateRight(n4, n, n2, box, box2);
            return new StyleData(40, Integer.toString(n5) + "px");
        }
        int n6 = this.translateLeft(n, box, box2);
        return new StyleData(39, Integer.toString(n6) + "px");
    }

    private int translateRight(int n, int n2, int n3, Designer.Box box, Designer.Box box2) {
        int n4 = n - (n2 - box.getX()) - (n3 - box.getWidth());
        Point point = JsfSupportUtilities.translateCoordinates(box2, n4, 0);
        n4 = point.x;
        return n4 += box.getRightMargin();
    }

    private int translateLeft(int n, Designer.Box box, Designer.Box box2) {
        Point point = JsfSupportUtilities.translateCoordinates(box2, n, 0);
        n = point.x;
        return n -= box.getLeftMargin();
    }

    private StyleData getVerticalCssSetting(int n, int n2, Designer.Box box, Designer.Box box2, Element element) {
        int n3 = CssProvider.getValueService().getCssLength(element, 41);
        int n4 = CssProvider.getValueService().getCssLength(element, 42);
        if (n3 == 0x7FFFFFFE && n4 != 0x7FFFFFFE) {
            int n5 = this.translateBottom(n4, n, n2, box, box2);
            return new StyleData(42, Integer.toString(n5) + "px");
        }
        int n6 = this.translateTop(n, box, box2);
        return new StyleData(41, Integer.toString(n6) + "px");
    }

    private int translateBottom(int n, int n2, int n3, Designer.Box box, Designer.Box box2) {
        int n4 = n - (n2 - box.getY()) - (n3 - box.getHeight());
        Point point = JsfSupportUtilities.translateCoordinates(box2, 0, n4);
        n4 = point.y;
        return n4 += box.getEffectiveTopMargin();
    }

    private int translateTop(int n, Designer.Box box, Designer.Box box2) {
        Point point = JsfSupportUtilities.translateCoordinates(box2, 0, n);
        n = point.y;
        return n -= box.getEffectiveTopMargin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponentTo(Designer.Box box, int n, int n2) {
        Element element = box.getComponentRootElement();
        if (!this.jsfForm.isWriteLocked()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This method has to be called under write lock! It is not."));
        }
        try {
            this.jsfForm.setUpdatesSuspended(element, true);
            Designer.Box box2 = box.getParent();
            ArrayList<StyleData> arrayList = new ArrayList<StyleData>(3);
            arrayList.add(new StyleData(48, CssProvider.getValueService().getAbsoluteValue()));
            arrayList.add(this.getHorizontalCssSetting(n, box.getWidth(), box, box2, element));
            arrayList.add(this.getVerticalCssSetting(n2, box.getHeight(), box, box2, element));
            JsfSupportUtilities.updateLocalStyleValuesForElement(element, arrayList.toArray(new StyleData[arrayList.size()]), null);
        }
        finally {
            this.jsfForm.setUpdatesSuspended(element, false);
        }
        this.fireComponentMovedTo(new DefaultDomDocumentEvent(this, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frontComponents(Designer.Box[] boxArray) {
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_BringToFront"));
        try {
            int n = boxArray.length;
            for (Designer.Box box : boxArray) {
                Element element = box.getComponentRootElement();
                if (element == null) {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("There is no component root element for box=" + box));
                    continue;
                }
                int n2 = 0x7FFFFFFE;
                Designer.Box box2 = box.getParent();
                if (box2 != null) {
                    for (Designer.Box box3 : box2.getChildren()) {
                        if (box3 == box || n2 != 0x7FFFFFFE && (box3.getZ() == 0x7FFFFFFE || box3.getZ() <= n2)) continue;
                        n2 = box3.getZ();
                    }
                }
                n2 = n2 == 0x7FFFFFFE ? 500 : ++n2;
                try {
                    this.jsfForm.setUpdatesSuspended(element, true);
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(new StyleData(59, Integer.toString(n2)));
                    JsfSupportUtilities.updateLocalStyleValuesForElement(element, arrayList.toArray(new StyleData[arrayList.size()]), null);
                }
                finally {
                    this.jsfForm.setUpdatesSuspended(element, false);
                }
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backComponents(Designer.Box[] boxArray) {
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_SendToBack"));
        try {
            int n = boxArray.length;
            for (Designer.Box box : boxArray) {
                Element element = box.getComponentRootElement();
                if (element == null) {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("There is no component root element for box=" + box));
                    continue;
                }
                int n2 = 0x7FFFFFFE;
                Designer.Box box2 = box.getParent();
                if (box2 != null) {
                    for (Designer.Box box3 : box2.getChildren()) {
                        if (box3 == box || n2 != 0x7FFFFFFE && (box3.getZ() == 0x7FFFFFFE || box3.getZ() >= n2)) continue;
                        n2 = box3.getZ();
                    }
                }
                n2 = n2 == 0x7FFFFFFE ? 500 : --n2;
                try {
                    this.jsfForm.setUpdatesSuspended(element, true);
                    ArrayList arrayList = new ArrayList(1);
                    arrayList.add(new StyleData(59, Integer.toString(n2)));
                    JsfSupportUtilities.updateLocalStyleValuesForElement(element, arrayList.toArray(new StyleData[arrayList.size()]), null);
                }
                finally {
                    this.jsfForm.setUpdatesSuspended(element, false);
                }
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeComponent(Designer designer, Element element, int n, boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4, boolean bl4, Designer.Box box, boolean bl5) {
        Element element2;
        int n5 = n;
        int n6 = n2;
        if (bl5) {
            n5 = designer.snapX(n, box.getPositionedBy());
            n6 = designer.snapY(n2, box.getPositionedBy());
        }
        if ((element2 = box.getElement()) == null) {
            element2 = element;
        }
        boolean bl6 = this.isAbsolutelyPositioned(element2);
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_ResizeComponent"));
        try {
            this.jsfForm.setUpdatesSuspended(element, true);
            ArrayList<StyleData> arrayList = new ArrayList<StyleData>(5);
            ArrayList<StyleData> arrayList2 = new ArrayList<StyleData>(3);
            if (bl6 && (bl || bl2)) {
                arrayList.add(new StyleData(48, CssProvider.getValueService().getAbsoluteValue()));
                Designer.Box box2 = box.getParent();
                if (bl) {
                    arrayList.add(this.getHorizontalCssSetting(n5, n3, box, box2, element2));
                }
                if (bl2) {
                    arrayList.add(this.getVerticalCssSetting(n6, n4, box, box2, element2));
                }
            }
            if (bl3) {
                if (!JsfSupportUtilities.setStyleAttribute(element, "width", n3)) {
                    arrayList.add(new StyleData(58, Integer.toString(n3) + "px"));
                } else {
                    arrayList2.add(new StyleData(58));
                }
            }
            if (bl4) {
                if (!JsfSupportUtilities.setStyleAttribute(element, "height", n4)) {
                    arrayList.add(new StyleData(31, Integer.toString(n4) + "px"));
                } else {
                    arrayList2.add(new StyleData(31));
                }
            }
            JsfSupportUtilities.updateLocalStyleValuesForElement(element2, arrayList.toArray(new StyleData[arrayList.size()]), arrayList2.toArray(new StyleData[arrayList2.size()]));
        }
        finally {
            this.jsfForm.setUpdatesSuspended(element, false);
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapToGrid(Designer designer) {
        Element[] elementArray = designer.getSelectedComponents();
        boolean bl = false;
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_SnapToGrid"));
        try {
            for (Element element : elementArray) {
                boolean bl2;
                Designer.Box box = designer.findBoxForComponentRootElement(element);
                if (box == null || !(bl2 = box.isAbsolutelyPositioned())) continue;
                int n = box.getAbsoluteX();
                int n2 = box.getAbsoluteY();
                n = designer.snapX(n, box.getPositionedBy());
                n2 = designer.snapY(n2, box.getPositionedBy());
                this.moveComponentTo(box, n, n2);
                bl = true;
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void align(Designer designer, JsfForm.Alignment alignment) {
        Element element = designer.getPrimarySelectedComponent();
        Designer.Box box = designer.findBoxForComponentRootElement(element);
        if (box == null) {
            return;
        }
        boolean bl = false;
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_Align"));
        try {
            boolean bl2 = box.isAbsolutelyPositioned();
            int n = box.getAbsoluteX();
            int n2 = box.getAbsoluteY();
            int n3 = box.getWidth();
            int n4 = box.getHeight();
            block11: for (Element element2 : designer.getSelectedComponents()) {
                Designer.Box box2 = designer.findBoxForComponentRootElement(element2);
                if (box2 == null || !box2.isAbsolutelyPositioned()) continue;
                bl = true;
                switch (alignment) {
                    case TOP: {
                        this.moveComponentTo(box2, box2.getAbsoluteX(), n2);
                        continue block11;
                    }
                    case MIDDLE: {
                        this.moveComponentTo(box2, box2.getAbsoluteX(), n2 + n4 / 2 - box2.getHeight() / 2);
                        continue block11;
                    }
                    case BOTTOM: {
                        this.moveComponentTo(box2, box2.getAbsoluteX(), n2 + n4 - box2.getHeight());
                        continue block11;
                    }
                    case LEFT: {
                        this.moveComponentTo(box2, n, box2.getAbsoluteY());
                        continue block11;
                    }
                    case CENTER: {
                        this.moveComponentTo(box2, n + n3 / 2 - box2.getWidth() / 2, box2.getAbsoluteY());
                        continue block11;
                    }
                    case RIGHT: {
                        this.moveComponentTo(box2, n + n3 - box2.getWidth(), box2.getAbsoluteY());
                    }
                }
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNextChar(Designer designer, DomProvider.DomRange domRange) {
        if (domRange == null) {
            return false;
        }
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_DeleteText"));
        try {
            if (!domRange.isEmpty()) {
                this.deleteRangeContents(domRange);
                boolean bl = true;
                return bl;
            }
            DomProvider.DomPosition domPosition = domRange.getMark();
            DomProvider.DomPosition domPosition2 = designer.computeNextPosition(domPosition);
            if (domPosition2 == DomProvider.DomPosition.NONE || !designer.isInsideEditableRegion(domPosition2)) {
                boolean bl = false;
                return bl;
            }
            domRange.setRange(domPosition.getNode(), domPosition.getOffset(), domPosition2.getNode(), domPosition2.getOffset());
            this.deleteRangeContents(domRange);
            boolean bl = true;
            return bl;
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletePreviousChar(Designer designer, DomProvider.DomRange domRange) {
        if (domRange == null) {
            return false;
        }
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_DeleteText"));
        try {
            if (!domRange.isEmpty()) {
                this.deleteRangeContents(domRange);
                boolean bl = true;
                return bl;
            }
            DomProvider.DomPosition domPosition = domRange.getMark();
            DomProvider.DomPosition domPosition2 = designer.computePreviousPosition(domPosition);
            if (domPosition2 == DomProvider.DomPosition.NONE || !designer.isInsideEditableRegion(domPosition2)) {
                boolean bl = false;
                return bl;
            }
            domRange.setRange(domPosition2.getNode(), domPosition2.getOffset(), domPosition.getNode(), domPosition.getOffset());
            this.deleteRangeContents(domRange);
            boolean bl = true;
            return bl;
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteComponents(Element[] elementArray) {
        UndoEvent undoEvent = this.jsfForm.writeLock(NbBundle.getMessage(DomDocumentImpl.class, (String)"LBL_DeleteComponents"));
        try {
            for (Element element : elementArray) {
                if (JsfSupportUtilities.isSpecialComponent(element)) continue;
                MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
                if (markupDesignBean == null) {
                    return;
                }
                this.jsfForm.deleteDesignBean((DesignBean)markupDesignBean);
            }
        }
        finally {
            this.jsfForm.writeUnlock(undoEvent);
        }
    }

    boolean isRenderedNode(Node node) {
        return this.jsfForm.isRenderedNode(node);
    }

    JsfForm getJsfForm() {
        return this.jsfForm;
    }

    private static class DefaultDomDocumentEvent
    implements DomProvider.DomDocumentEvent {
        private final DomProvider.DomDocument document;
        private final DomProvider.DomPosition position;

        public DefaultDomDocumentEvent(DomProvider.DomDocument domDocument, DomProvider.DomPosition domPosition) {
            this.document = domDocument;
            this.position = domPosition;
        }

        public DomProvider.DomDocument getDomDocument() {
            return this.document;
        }

        public DomProvider.DomPosition getDomPosition() {
            return this.position;
        }
    }
}

