/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.ui;

import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.markup.MarkupMouseRegion;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.jsf.JsfForm;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.designer.jsf.ui.JsfTopComponent;
import org.netbeans.modules.visualweb.insync.faces.FacesPageUnit;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.w3c.dom.Element;

class JsfDesignerListener
implements Designer.DesignerListener {
    private final JsfTopComponent jsfTopComponent;

    public JsfDesignerListener(JsfTopComponent jsfTopComponent) {
        this.jsfTopComponent = jsfTopComponent;
    }

    public void userActionPerformed(Designer.DesignerEvent designerEvent) {
        if (this.handleUserAction()) {
            this.jsfTopComponent.getDesigner().finishInlineEditing(true);
        }
    }

    private boolean handleUserAction() {
        Designer.Box box = null;
        if (this.jsfTopComponent.getDesigner().getSelectedCount() > 0) {
            for (Element element : this.jsfTopComponent.getDesigner().getSelectedComponents()) {
                if (element != null && (box = this.jsfTopComponent.getDesigner().findBoxForComponentRootElement(element)) != null) break;
            }
        }
        return this.handleUserAction(box);
    }

    private boolean handleUserAction(Designer.Box box) {
        Designer.Box[] boxArray;
        if (box instanceof Designer.ExternalBox) {
            JsfDesignerListener.openExternalBox((Designer.ExternalBox)box);
            return false;
        }
        if (box != null && box.getTag() == HtmlTag.DIV && (boxArray = box.getChildren()).length == 1 && boxArray[0] instanceof Designer.ExternalBox) {
            JsfDesignerListener.openExternalBox((Designer.ExternalBox)boxArray[0]);
            return false;
        }
        return this.editEventHandler();
    }

    private boolean editEventHandler() {
        Element element = this.jsfTopComponent.getDesigner().getSelectedCount() == 0 ? null : this.getDefaultSelectionComponentRootElement();
        return this.jsfTopComponent.getJsfForm().editEventHandlerForComponent(element);
    }

    private Element getDefaultSelectionComponentRootElement() {
        Element element = this.jsfTopComponent.getDesigner().getPrimarySelection();
        if (element == null && this.jsfTopComponent.getDesigner().getSelectedCount() > 0) {
            Element element2;
            Element[] elementArray = this.jsfTopComponent.getDesigner().getSelectedComponents();
            int n = elementArray.length;
            for (int i = 0; i < n && (element = (element2 = elementArray[i])) == null; ++i) {
            }
        }
        return element;
    }

    private static void openExternalBox(Designer.ExternalBox externalBox) {
        JsfForm jsfForm = JsfForm.findJsfFormForDomProvider(externalBox.getExternalDomProvider());
        if (jsfForm == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        DataObject dataObject = jsfForm.getJspDataObject();
        if (dataObject == null) {
            return;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
        }
    }

    public void selectionChanged(Designer.DesignerEvent designerEvent) {
        Node[] nodeArray;
        Designer designer = designerEvent.getDesigner();
        Element[] elementArray = designer.getSelectedComponents();
        if (elementArray.length > 0) {
            ArrayList<Node> arrayList = new ArrayList<Node>(elementArray.length);
            for (Element element : elementArray) {
                Node node = JsfSupportUtilities.getNodeRepresentation(element);
                arrayList.add(node);
            }
            nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        } else {
            Node[] nodeArray2;
            Node node = this.jsfTopComponent.getJsfForm().getRootBeanNode();
            if (node == null) {
                nodeArray2 = new Node[]{};
            } else {
                Node[] nodeArray3 = new Node[1];
                nodeArray2 = nodeArray3;
                nodeArray3[0] = node;
            }
            nodeArray = nodeArray2;
        }
        this.jsfTopComponent.setActivatedNodes(nodeArray);
        this.jsfTopComponent.updatePasteAction();
    }

    public void userPopupActionPerformed(Designer.DesignerPopupEvent designerPopupEvent) {
        Component component = designerPopupEvent.getComponent();
        int n = designerPopupEvent.getX();
        int n2 = designerPopupEvent.getY();
        Point point = SwingUtilities.convertPoint(component, n, n2, (Component)((Object)this.jsfTopComponent));
        this.jsfTopComponent.showPopup(designerPopupEvent.getActions(), designerPopupEvent.getContext(), point.x, point.y);
    }

    public void userElementClicked(Designer.DesignerClickEvent designerClickEvent) {
        MarkupMouseRegion markupMouseRegion = JsfDesignerListener.findRegion(designerClickEvent.getBox().getElement());
        if (markupMouseRegion != null && markupMouseRegion.isClickable()) {
            Result result = markupMouseRegion.regionClicked(designerClickEvent.getClickCount());
            this.jsfTopComponent.getJsfForm().handleResult(result);
            designerClickEvent.consume();
        }
    }

    private static MarkupMouseRegion findRegion(Element element) {
        while (element != null) {
            MarkupMouseRegion markupMouseRegion = FacesPageUnit.getMarkupMouseRegionForElement((Element)element);
            if (markupMouseRegion != null) {
                return markupMouseRegion;
            }
            if (!(element.getParentNode() instanceof Element)) break;
            element = (Element)element.getParentNode();
        }
        return null;
    }
}

