/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.PartialCompletionException;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRunner
extends BasicTask<GlassfishModule.OperationState> {
    public final int HTTP_RETRY_DELAY = 3000;
    private static ExecutorService executor;
    private ServerCommand serverCmd;
    private boolean authorized;

    private static synchronized ExecutorService executor() {
        if (executor == null) {
            executor = Executors.newFixedThreadPool(1);
        }
        return executor;
    }

    public CommandRunner(Map<String, String> map, OperationStateListener ... operationStateListenerArray) {
        super(map, operationStateListenerArray);
    }

    public Future<GlassfishModule.OperationState> stopServer() {
        return this.execute(Commands.STOP, "MSG_STOP_SERVER_IN_PROGRESS");
    }

    public Map<String, List<AppDesc>> getApplications(String string) {
        Map<String, List<AppDesc>> map = Collections.emptyMap();
        try {
            Commands.ListAppsCommand listAppsCommand = new Commands.ListAppsCommand(string);
            this.serverCmd = listAppsCommand;
            Future<GlassfishModule.OperationState> future = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState operationState = future.get();
            if (operationState == GlassfishModule.OperationState.COMPLETED) {
                map = listAppsCommand.getApplicationMap();
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish").log(Level.INFO, interruptedException.getMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish").log(Level.INFO, executionException.getMessage(), executionException);
        }
        return map;
    }

    public List<ResourceDesc> getResources(String string) {
        List<ResourceDesc> list = Collections.emptyList();
        try {
            Commands.ListResourcesCommand listResourcesCommand = new Commands.ListResourcesCommand(string);
            this.serverCmd = listResourcesCommand;
            Future<GlassfishModule.OperationState> future = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState operationState = future.get();
            if (operationState == GlassfishModule.OperationState.COMPLETED) {
                list = listResourcesCommand.getResourceList();
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish").log(Level.INFO, interruptedException.getMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish").log(Level.INFO, executionException.getMessage(), executionException);
        }
        return list;
    }

    public Map<String, String> getResourceData(String string) {
        try {
            ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand("resources.*." + string);
            this.serverCmd = getPropertyCommand;
            Future<GlassfishModule.OperationState> future = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState operationState = future.get();
            if (operationState == GlassfishModule.OperationState.COMPLETED) {
                getPropertyCommand.processResponse();
                return getPropertyCommand.getData();
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish").log(Level.INFO, interruptedException.getMessage(), interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish").log(Level.INFO, executionException.getMessage(), executionException);
        }
        return new HashMap<String, String>();
    }

    public void putResourceData(Map<String, String> map) throws PartialCompletionException {
        Set<String> set = map.keySet();
        String string = null;
        Exception exception = null;
        Object object = set.iterator();
        while (object.hasNext()) {
            String string2;
            String string3 = string2 = object.next();
            String string4 = map.get(string2);
            try {
                ServerCommand.SetPropertyCommand setPropertyCommand = new ServerCommand.SetPropertyCommand(string3, string4);
                this.serverCmd = setPropertyCommand;
                Future<GlassfishModule.OperationState> future = CommandRunner.executor().submit(this);
                GlassfishModule.OperationState operationState = future.get();
                if (operationState != GlassfishModule.OperationState.COMPLETED) continue;
                setPropertyCommand.processResponse();
            }
            catch (InterruptedException interruptedException) {
                exception = interruptedException;
                Logger.getLogger("glassfish").log(Level.INFO, interruptedException.getMessage(), interruptedException);
                string = this.addName(string3, string);
            }
            catch (ExecutionException executionException) {
                exception = executionException;
                Logger.getLogger("glassfish").log(Level.INFO, executionException.getMessage(), executionException);
                string = this.addName(string3, string);
            }
        }
        if (null != string) {
            object = new PartialCompletionException(string);
            if (null != exception) {
                ((Throwable)object).initCause(exception);
            }
            throw object;
        }
    }

    public Future<GlassfishModule.OperationState> deploy(File file) {
        return this.deploy(file, file.getParentFile().getName(), null);
    }

    public Future<GlassfishModule.OperationState> deploy(File file, String string) {
        return this.deploy(file, string, null);
    }

    public Future<GlassfishModule.OperationState> deploy(File file, String string, String string2) {
        return this.execute(new Commands.DeployCommand(file.getAbsolutePath(), string, string2));
    }

    public Future<GlassfishModule.OperationState> redeploy(String string, String string2) {
        return this.execute(new Commands.RedeployCommand(string, string2));
    }

    public Future<GlassfishModule.OperationState> undeploy(String string) {
        return this.execute(new Commands.UndeployCommand(string));
    }

    public Future<GlassfishModule.OperationState> unregister(String string, String string2, String string3, boolean bl) {
        return this.execute(new Commands.UnregisterCommand(string, string2, string3, bl));
    }

    public Future<GlassfishModule.OperationState> execute(ServerCommand serverCommand) {
        return this.execute(serverCommand, null);
    }

    private String addName(String string, String string2) {
        String string3 = string2;
        string3 = null != string2 ? string3 + ", " + string : string;
        return string3;
    }

    private Future<GlassfishModule.OperationState> execute(ServerCommand serverCommand, String string) {
        this.serverCmd = serverCommand;
        if (string != null) {
            this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, string, this.instanceName);
        }
        return CommandRunner.executor().submit(this);
    }

    private static String encodePath(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (!stringTokenizer.hasMoreTokens()) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append("/").append(URLEncoder.encode(stringTokenizer.nextToken(), "UTF-8"));
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public GlassfishModule.OperationState call() {
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_ServerCmdRunning", this.serverCmd.toString(), this.instanceName);
        boolean bl = false;
        boolean bl2 = false;
        URL uRL = null;
        URLConnection uRLConnection = null;
        String string = this.serverCmd.getCommand();
        String string2 = this.constructCommandUrl(string, true);
        int n = 1;
        Logger.getLogger("glassfish").log(Level.FINEST, "CommandRunner.call(" + string2 + ") called on thread \"" + Thread.currentThread().getName() + "\"");
        try {
            uRL = new URL(string2);
            while (!bl && n-- > 0) {
                block15: {
                    try {
                        Logger.getLogger("glassfish").log(Level.FINE, "V3 HTTP Command: " + string2);
                        uRLConnection = uRL.openConnection();
                        if (uRLConnection instanceof HttpURLConnection) {
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            httpURLConnection.setAllowUserInteraction(false);
                            httpURLConnection.setDoInput(true);
                            httpURLConnection.setUseCaches(false);
                            httpURLConnection.setRequestMethod(this.serverCmd.getRequestMethod());
                            httpURLConnection.setDoOutput(this.serverCmd.getDoOutput());
                            String string3 = this.serverCmd.getContentType();
                            if (string3 != null && string3.length() > 0) {
                                httpURLConnection.setRequestProperty("Content-Type", string3);
                            }
                            httpURLConnection.setRequestProperty("User-Agent", "hk2-agent");
                            httpURLConnection.connect();
                            int n2 = httpURLConnection.getResponseCode();
                            if (n2 == 401 || n2 == 403) {
                                this.authorized = false;
                                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_AuthorizationFailed", this.serverCmd.toString(), this.instanceName);
                            }
                            if (Boolean.getBoolean("org.netbeans.modules.hk2.LogManagerCommands")) {
                                Logger.getLogger("glassfish").log(Level.FINE, "  receiving response, code: " + n2);
                            }
                            this.handleSend(httpURLConnection);
                            if (this.handleReceive(httpURLConnection)) {
                                bl2 = this.serverCmd.processResponse();
                            }
                            bl = true;
                        } else {
                            Logger.getLogger("glassfish").log(Level.INFO, "Unexpected connection type: " + uRL);
                        }
                    }
                    catch (ProtocolException protocolException) {
                        this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_Exception", protocolException.getLocalizedMessage());
                        n = 0;
                    }
                    catch (IOException iOException) {
                        if (n > 0) break block15;
                        this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_Exception", iOException.getLocalizedMessage());
                    }
                }
                if (bl || n <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger("glassfish").log(Level.WARNING, malformedURLException.getLocalizedMessage(), malformedURLException);
        }
        if (bl2) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_ServerCmdCompleted", this.serverCmd.toString(), this.instanceName);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_ServerCmdFailed", this.serverCmd.toString(), this.instanceName);
    }

    private String constructCommandUrl(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("http://");
        stringBuilder.append((String)this.ip.get("host"));
        stringBuilder.append(":");
        if ("true".equals(System.getProperty("glassfish.useadminport"))) {
            stringBuilder.append((String)this.ip.get("adminPort"));
        } else {
            stringBuilder.append((String)this.ip.get("httpportnumber"));
        }
        stringBuilder.append("/__asadmin/");
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        return bl ? string2.replaceAll(" ", "%20") : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSend(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = this.serverCmd.getInputStream();
        if (inputStream != null) {
            BufferedOutputStream bufferedOutputStream = null;
            try {
                int n;
                bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream(), 1024);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                    bufferedOutputStream = null;
                }
            }
        }
        if ("PUT".equalsIgnoreCase(this.serverCmd.getRequestMethod())) {
            Logger.getLogger("glassfish").log(Level.INFO, "HTTP PUT request but no data stream provided");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleReceive(HttpURLConnection httpURLConnection) throws IOException {
        boolean bl = false;
        InputStream inputStream = httpURLConnection.getInputStream();
        try {
            bl = this.serverCmd.readResponse(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
        return bl;
    }
}

