/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.wizards.Retriever;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AddServerLocationVisualPanel
extends JPanel
implements Retriever.Updater {
    private static final String V3_LOCATION_REFERENCE_URL = "http://serverplugins.netbeans.org/glassfishv3/v3zipfilename.txt";
    private static final String V3_DOWNLOAD_PREFIX = "http://java.net/download/";
    private static final String V3_DEFAULT_DOWNLOAD_URL = "http://java.net/download/javaee5/v3/releases/preview/glassfish-v3-preview2-final.zip";
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private Retriever retriever;
    private volatile DownloadState downloadState;
    private volatile String statusText;
    private JCheckBox agreeCheckBox;
    private JButton browseButton;
    private JButton downloadButton;
    private JLabel downloadStatusLabel;
    private JLabel hk2HomeLabel;
    private JTextField hk2HomeTextField;
    private JButton readlicenseButton;
    private JPanel statusPanel;

    public AddServerLocationVisualPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initUserComponents() {
        this.downloadButton.setEnabled(false);
        this.setName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"TITLE_ServerLocation"));
        this.hk2HomeTextField.setText(this.getPreviousValue());
        this.hk2HomeTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }
        });
        this.setDownloadState(DownloadState.AVAILABLE);
        this.updateMessageText("");
    }

    private String getPreviousValue() {
        Preferences preferences = NbPreferences.forModule(ServerWizardIterator.class);
        String string = null;
        if (null != preferences) {
            string = preferences.get("last-install-root", null);
        }
        if (null == string) {
            String string2 = System.getProperty("org.glassfish.v3.installRoot");
            if (null != string2 && string2.trim().length() != 0) {
                return string2;
            }
            return System.getProperty("user.home") + File.separatorChar + "GlassFish_V3_Prelude";
        }
        return string;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public String getHk2HomeLocation() {
        return this.hk2HomeTextField.getText();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String browseHomeLocation() {
        String string = null;
        JFileChooser jFileChooser = this.getJFileChooser();
        int n = jFileChooser.showDialog(this, NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseButton"));
        if (n == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return string;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new DirFilter());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setApproveButtonToolTipText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        jFileChooser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        jFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName"));
        File file = new File(this.hk2HomeTextField.getText());
        File file2 = file.getParentFile();
        if (file2 != null && file2.exists()) {
            jFileChooser.setCurrentDirectory(file2);
        }
        if (file.exists() && file.isDirectory()) {
            jFileChooser.setSelectedFile(file);
        }
        return jFileChooser;
    }

    public void removeNotify() {
        if (this.retriever != null) {
            this.retriever.stopRetrieval();
        }
        super.removeNotify();
    }

    public void updateMessageText(final String string) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                AddServerLocationVisualPanel.this.downloadStatusLabel.setText(string);
                AddServerLocationVisualPanel.this.fireChangeEvent();
            }
        });
    }

    public void updateStatusText(String string) {
        this.statusText = string;
        this.fireChangeEvent();
    }

    public void clearCancelState() {
        this.setDownloadState(this.retriever.getDownloadState() == 3 ? DownloadState.COMPLETED : DownloadState.AVAILABLE);
        this.retriever = null;
    }

    private void updateButton() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DownloadState downloadState = AddServerLocationVisualPanel.this.downloadState;
                boolean bl = AddServerLocationVisualPanel.this.agreeCheckBox.isSelected();
                String string = downloadState == DownloadState.DOWNLOADING ? "LBL_CancelDownload" : (downloadState == DownloadState.COMPLETED ? "LBL_DownloadComplete" : "LBL_DownloadNow");
                String string2 = NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)string);
                AddServerLocationVisualPanel.this.downloadButton.setText(string2);
                AddServerLocationVisualPanel.this.downloadButton.setEnabled(downloadState != DownloadState.COMPLETED && bl);
            }
        });
    }

    private synchronized void setDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
        this.updateButton();
    }

    private void homeFolderChanged() {
        this.updateMessageText("");
        if (this.downloadState == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        }
        this.fireChangeEvent();
    }

    private void initComponents() {
        this.hk2HomeLabel = new JLabel();
        this.hk2HomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.downloadButton = new JButton();
        this.agreeCheckBox = new JCheckBox();
        this.readlicenseButton = new JButton();
        this.statusPanel = new JPanel();
        this.downloadStatusLabel = new JLabel();
        this.hk2HomeLabel.setLabelFor(this.hk2HomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.hk2HomeLabel, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerLocationVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.downloadButton.setText("[download/cancel]");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerLocationVisualPanel.this.downloadButtonActionPerformed(actionEvent);
            }
        });
        this.agreeCheckBox.setMargin(new Insets(4, 4, 4, 4));
        this.agreeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerLocationVisualPanel.this.agreeCheckBoxActionPerformed(actionEvent);
            }
        });
        this.readlicenseButton.setText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ReadLicenseText"));
        this.readlicenseButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.readlicenseButton.setBorderPainted(false);
        this.readlicenseButton.setContentAreaFilled(false);
        this.readlicenseButton.setHorizontalAlignment(10);
        this.readlicenseButton.setVerticalAlignment(1);
        this.readlicenseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerLocationVisualPanel.this.readlicenseButtonActionPerformed(actionEvent);
            }
        });
        this.downloadStatusLabel.setText("[download status]");
        this.downloadStatusLabel.setVerticalAlignment(1);
        this.downloadStatusLabel.setHorizontalTextPosition(10);
        GroupLayout groupLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.downloadStatusLabel, -1, 510, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.downloadStatusLabel, -1, -1, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.statusPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.hk2HomeLabel).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.downloadButton).addPreferredGap(1).add((Component)this.agreeCheckBox).add(2, 2, 2).add((Component)this.readlicenseButton, -1, 339, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.hk2HomeTextField, -1, 417, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton).addPreferredGap(0))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.hk2HomeLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.hk2HomeTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.downloadButton).add((Component)this.agreeCheckBox).add((Component)this.readlicenseButton)).add(18, 18, 18).add((Component)this.statusPanel, -1, -1, Short.MAX_VALUE)));
    }

    private void readlicenseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://glassfish.dev.java.net/public/CDDL+GPL.html"));
        }
        catch (Exception exception) {
            Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
        }
    }

    private void downloadButtonActionPerformed(ActionEvent actionEvent) {
        if (this.retriever == null) {
            this.updateStatusText("");
            this.retriever = new Retriever(new File(this.hk2HomeTextField.getText()), V3_LOCATION_REFERENCE_URL, V3_DOWNLOAD_PREFIX, V3_DEFAULT_DOWNLOAD_URL, this);
            new Thread(this.retriever).start();
            this.setDownloadState(DownloadState.DOWNLOADING);
        } else {
            this.retriever.stopRetrieval();
            this.setDownloadState(DownloadState.AVAILABLE);
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.browseHomeLocation();
        if (string != null && string.length() > 0) {
            this.hk2HomeTextField.setText(string);
        }
    }

    private void agreeCheckBoxActionPerformed(ActionEvent actionEvent) {
        DownloadState downloadState = this.downloadState;
        if (downloadState == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        } else {
            this.downloadButton.setEnabled(this.agreeCheckBox.isSelected());
        }
    }

    private static class DirFilter
    extends FileFilter {
        private DirFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.canRead() && file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_DirType");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DownloadState {
        AVAILABLE,
        DOWNLOADING,
        COMPLETED;

    }
}

