/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesHelper {
    public static final String PATH_LIBRARIES = "lib";
    public static final String WEBSERVICE_CLIENTS_SUB_DIR = "webservice_clients";

    public static void addDefaultJaxWsClientJars(Project project, FileObject fileObject, WsdlSaas wsdlSaas) {
        List<String> list = LibrariesHelper.getDefaultJaxWsClientJars(wsdlSaas, "proxy");
        LibrariesHelper.addArchiveRefsToProject(project, fileObject, list, "classpath/compile");
    }

    public static void addClientJars(Project project, FileObject fileObject, WadlSaas wadlSaas) {
        LibrariesHelper.addArchivesToProject(project, fileObject, wadlSaas.getLibraryJars(), "classpath/compile");
    }

    public static void addArchiveRefsToProject(Project project, FileObject fileObject, List<String> list) {
        LibrariesHelper.addArchiveRefsToProject(project, fileObject, list, "classpath/compile");
    }

    public static void addArchiveRefsToProject(Project project, FileObject fileObject, List<String> list, String string) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (String string2 : list) {
            FileObject fileObject2 = FileUtil.toFileObject((File)new File(string2));
            if (fileObject2 == null) continue;
            arrayList.add(fileObject2);
        }
        LibrariesHelper.addArchivesToProject(project, fileObject, arrayList, string);
    }

    public static void addArchivesToProject(Project project, FileObject fileObject, List<FileObject> list) {
        LibrariesHelper.addArchivesToProject(project, fileObject, list, "classpath/compile");
    }

    public static void addArchivesToProject(Project project, FileObject fileObject, List<FileObject> list, String string) {
        ClassPath classPath;
        if (fileObject == null) {
            fileObject = LibrariesHelper.getSourceRoot(project);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)string)) != null) {
            try {
                FileObject fileObject2 = LibrariesHelper.getWebServiceClientLibraryDir(project);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                for (FileObject fileObject3 : list) {
                    FileObject fileObject4;
                    try {
                        fileObject4 = fileObject2.getFileObject(fileObject3.getNameExt());
                        if (fileObject4 == null) {
                            fileObject4 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName());
                        }
                        if (classPath.contains(fileObject4)) continue;
                        arrayList.add(new URL(fileObject4.getURL().toExternalForm() + "/"));
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    fileObject4 = arrayList.toArray(new URL[arrayList.size()]);
                    ProjectClassPathModifier.addRoots((URL[])fileObject4, (FileObject)fileObject, (String)string);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static FileObject getProjectLibraryDirectory(Project project) throws IOException {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject(PATH_LIBRARIES);
        if (fileObject2 == null) {
            fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)PATH_LIBRARIES);
        }
        return fileObject2;
    }

    public static FileObject getWebServiceClientLibraryDir(Project project) throws IOException {
        FileObject fileObject = LibrariesHelper.getProjectLibraryDirectory(project);
        FileObject fileObject2 = fileObject.getFileObject(WEBSERVICE_CLIENTS_SUB_DIR);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(WEBSERVICE_CLIENTS_SUB_DIR);
        }
        return fileObject2;
    }

    public static List<String> getDefaultJaxWsClientJars(WsdlSaas wsdlSaas, String string) {
        WsdlData wsdlData = wsdlSaas.getWsdlData();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = wsdlData.getJaxWsDescriptor().getXmlDescriptorFile().getParentFile();
        for (WsdlServiceProxyDescriptor.JarEntry jarEntry : wsdlData.getJaxWsDescriptor().getJars()) {
            if (!jarEntry.getType().equals(string)) continue;
            File file2 = new File(file, jarEntry.getName());
            arrayList.add(file2.getAbsolutePath());
        }
        return arrayList;
    }

    public static FileObject getSourceRoot(Project project) {
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!"${src.dir}".equals(sourceGroupArray[i].getName())) continue;
            return sourceGroupArray[i].getRootFolder();
        }
        if (sourceGroupArray.length != 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        return null;
    }
}

