/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.NbLocalizer;
import org.netbeans.modules.editor.lib2.EditorApiPackageAccessor;
import org.netbeans.modules.editor.options.AnnotationTypesFolder;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.cookies.EditorCookie;
import org.openide.modules.ModuleInstall;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

public class EditorModule
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(EditorModule.class.getName());
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.kits");
    private PropertyChangeListener searchSelectedPatternListener;
    private PropertyChangeListener editorHistoryChangeListener;
    private PropertyChangeListener topComponentRegistryListener;

    public void restored() {
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)new NbLocalizer(BaseKit.class));
        AnnotationTypes.getTypes().registerLoader(new AnnotationTypes.Loader(){

            public void loadTypes() {
                AnnotationTypesFolder.getAnnotationTypesFolder();
            }

            public void loadSettings() {
                Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
                int n = preferences.getInt("backgroundGlyphAlpha", Integer.MIN_VALUE);
                if (n != Integer.MIN_VALUE) {
                    AnnotationTypes.getTypes().setBackgroundGlyphAlpha(n);
                }
                boolean bl = preferences.getBoolean("backgroundDrawing", false);
                AnnotationTypes.getTypes().setBackgroundDrawing(Boolean.valueOf(bl));
                bl = preferences.getBoolean("combineGlyphs", true);
                AnnotationTypes.getTypes().setCombineGlyphs(Boolean.valueOf(bl));
                bl = preferences.getBoolean("glyphsOverLineNumbers", true);
                AnnotationTypes.getTypes().setGlyphsOverLineNumbers(Boolean.valueOf(bl));
                bl = preferences.getBoolean("showGlyphGutter", true);
                AnnotationTypes.getTypes().setShowGlyphGutter(Boolean.valueOf(bl));
            }

            public void saveType(AnnotationType annotationType) {
                AnnotationTypesFolder.getAnnotationTypesFolder().saveAnnotationType(annotationType);
            }

            public void saveSetting(String string, Object object) {
                Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
                if (object instanceof Integer) {
                    preferences.putInt(string, (Integer)object);
                } else if (object instanceof Boolean) {
                    preferences.putBoolean(string, (Boolean)object);
                } else if (object != null) {
                    preferences.put(string, object.toString());
                } else {
                    preferences.remove(string);
                }
            }
        });
        this.initAndCheckEditorKitTypeRegistry("text/plain", null);
        this.initAndCheckEditorKitTypeRegistry("text/html", HTMLEditorKit.class.getName());
        this.initAndCheckEditorKitTypeRegistry("text/rtf", RTFEditorKit.class.getName());
        this.initAndCheckEditorKitTypeRegistry("application/rtf", RTFEditorKit.class.getName());
        try {
            Field field = JEditorPane.class.getDeclaredField("kitRegistryKey");
            field.setAccessible(true);
            Object object = field.get(JEditorPane.class);
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.AppContext");
            Method method = clazz.getDeclaredMethod("getAppContext", new Class[0]);
            Method method2 = clazz.getDeclaredMethod("get", Object.class);
            Method method3 = clazz.getDeclaredMethod("put", Object.class, Object.class);
            Object object2 = method.invoke(null, new Object[0]);
            Hashtable hashtable = (Hashtable)method2.invoke(object2, object);
            method3.invoke(object2, object, new HackMap(hashtable));
        }
        catch (Throwable throwable) {
            if (debug) {
                LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kits.", throwable);
            }
            LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kits.");
        }
        this.searchSelectedPatternListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent == null) {
                    return;
                }
                FindSupport findSupport = FindSupport.getFindSupport();
                if ("last-selected".equals(propertyChangeEvent.getPropertyName())) {
                    SearchPattern searchPattern = SearchHistory.getDefault().getLastSelected();
                    if (searchPattern == null) {
                        return;
                    }
                    FindSupport.SearchPatternWrapper searchPatternWrapper = new FindSupport.SearchPatternWrapper(searchPattern.getSearchExpression(), searchPattern.isWholeWords(), searchPattern.isMatchCase(), searchPattern.isRegExp());
                    findSupport.setLastSelected(searchPatternWrapper);
                } else if ("add-to-history".equals(propertyChangeEvent.getPropertyName())) {
                    List list = SearchHistory.getDefault().getSearchPatterns();
                    ArrayList<FindSupport.SearchPatternWrapper> arrayList = new ArrayList<FindSupport.SearchPatternWrapper>();
                    for (int i = 0; i < list.size(); ++i) {
                        SearchPattern searchPattern = (SearchPattern)list.get(i);
                        FindSupport.SearchPatternWrapper searchPatternWrapper = new FindSupport.SearchPatternWrapper(searchPattern.getSearchExpression(), searchPattern.isWholeWords(), searchPattern.isMatchCase(), searchPattern.isRegExp());
                        arrayList.add(searchPatternWrapper);
                    }
                    findSupport.setHistory(arrayList);
                }
            }
        };
        this.editorHistoryChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent == null || !"find-history-prop".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                FindSupport.SearchPatternWrapper searchPatternWrapper = (FindSupport.SearchPatternWrapper)propertyChangeEvent.getNewValue();
                SearchPattern searchPattern = SearchHistory.getDefault().getLastSelected();
                if (searchPatternWrapper == null || searchPatternWrapper.getSearchExpression() == null || "".equals(searchPatternWrapper.getSearchExpression())) {
                    return;
                }
                SearchPattern searchPattern2 = SearchPattern.create((String)searchPatternWrapper.getSearchExpression(), (boolean)searchPatternWrapper.isWholeWords(), (boolean)searchPatternWrapper.isMatchCase(), (boolean)searchPatternWrapper.isRegExp());
                if (searchPattern2 == null || searchPattern2.equals((Object)searchPattern)) {
                    return;
                }
                SearchHistory.getDefault().add(searchPattern2);
                SearchHistory.getDefault().setLastSelected(searchPattern2);
            }
        };
        SearchHistory.getDefault().addPropertyChangeListener(this.searchSelectedPatternListener);
        FindSupport.getFindSupport().addPropertyChangeListener(this.editorHistoryChangeListener);
        EditorApiPackageAccessor.get().setIgnoredAncestorClass(TabbedContainer.class);
        if (this.topComponentRegistryListener == null) {
            this.topComponentRegistryListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("tcClosed".equals(propertyChangeEvent.getPropertyName())) {
                        TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                        boolean bl = topComponent instanceof CloneableEditorSupport.Pane;
                        LOG.finest("CLOSE-TC: doClose=" + bl + ", TC=" + topComponent + "\n");
                        if (bl) {
                            EditorApiPackageAccessor.get().notifyClose((JComponent)topComponent);
                        }
                    }
                }
            };
            TopComponent.getRegistry().addPropertyChangeListener(this.topComponentRegistryListener);
        }
        if (LOG.isLoggable(Level.INFO)) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    try {
                        Field field = BaseKit.class.getDeclaredField("kits");
                        field.setAccessible(true);
                        Map map = (Map)field.get(null);
                        LOG.info("Number of loaded editor kits: " + map.size());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void uninstalled() {
        try {
            Field field = JEditorPane.class.getDeclaredField("kitRegistryKey");
            field.setAccessible(true);
            Object object = field.get(JEditorPane.class);
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("sun.awt.AppContext");
            Method method = clazz.getDeclaredMethod("getAppContext", new Class[0]);
            Method method2 = clazz.getDeclaredMethod("get", Object.class);
            Method method3 = clazz.getDeclaredMethod("put", Object.class, Object.class);
            Method method4 = clazz.getDeclaredMethod("remove", Object.class, Object.class);
            Object object2 = method.invoke(null, new Object[0]);
            Hashtable hashtable = (Hashtable)method2.invoke(object2, object);
            if (hashtable instanceof HackMap) {
                if (((HackMap)hashtable).getOriginal() != null) {
                    method3.invoke(object2, object, new HackMap(hashtable));
                } else {
                    method4.invoke(object2, object);
                }
            }
        }
        catch (Throwable throwable) {
            if (debug) {
                LOG.log(Level.WARNING, "Can't release the hack from the JEditorPane's registry for kits.", throwable);
            }
            LOG.log(Level.WARNING, "Can't release the hack from the JEditorPane's registry for kits.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HashSet hashSet = new HashSet();
                hashSet.addAll(TopComponent.getRegistry().getOpened());
                for (TopComponent topComponent : hashSet) {
                    Node[] nodeArray;
                    if (!(topComponent instanceof CloneableEditor) || (nodeArray = topComponent.getActivatedNodes()) == null) continue;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        JEditorPane[] jEditorPaneArray;
                        EditorCookie editorCookie = (EditorCookie)nodeArray[i].getCookie(EditorCookie.class);
                        if (editorCookie == null || (jEditorPaneArray = editorCookie.getOpenedPanes()) == null) continue;
                        for (int j = 0; j < jEditorPaneArray.length; ++j) {
                            if (!(jEditorPaneArray[j].getEditorKit() instanceof BaseKit)) continue;
                            topComponent.close();
                        }
                    }
                }
                if (EditorModule.this.topComponentRegistryListener != null) {
                    TopComponent.getRegistry().removePropertyChangeListener(EditorModule.this.topComponentRegistryListener);
                    EditorModule.this.topComponentRegistryListener = null;
                }
            }
        });
    }

    private void initAndCheckEditorKitTypeRegistry(String string, String string2) {
        String string3 = JEditorPane.getEditorKitClassNameForContentType(string);
        if (string3 == null) {
            LOG.log(Level.WARNING, "Can't find JDK editor kit class for " + string);
        } else if (string2 != null && !string2.equals(string3)) {
            LOG.log(Level.WARNING, "Wrong JDK editor kit class for " + string + ". Expecting: " + string2 + ", but was: " + string3);
        }
    }

    private static final class DebugHashtable
    extends Hashtable {
        DebugHashtable(Hashtable hashtable) {
            if (hashtable != null) {
                this.putAll(hashtable);
                LOG.log(Level.INFO, "Existing kit classNames mappings: " + this);
            }
        }

        public Object put(Object object, Object object2) {
            Object object3 = super.put(object, object2);
            LOG.log(Level.INFO, "registering mimeType=" + object + " -> kitClassName=" + object2 + " original was " + object3);
            return object3;
        }

        public Object remove(Object object) {
            Object v = super.remove(object);
            LOG.log(Level.INFO, "removing kitClassName=" + v + " for mimeType=" + object);
            return v;
        }
    }

    private static class HackMap
    extends Hashtable {
        private final Object LOCK = new String("EditorModule.HackMap.LOCK");
        private Hashtable delegate;

        HackMap(Hashtable hashtable) {
            this.delegate = hashtable;
            if (debug) {
                LOG.log(Level.INFO, "Original kit mappings: " + hashtable);
                try {
                    Field field = JEditorPane.class.getDeclaredField("kitTypeRegistryKey");
                    field.setAccessible(true);
                    Object object = field.get(JEditorPane.class);
                    Class<?> clazz = this.getClass().getClassLoader().loadClass("sun.awt.AppContext");
                    Method method = clazz.getDeclaredMethod("getAppContext", new Class[0]);
                    Method method2 = clazz.getDeclaredMethod("get", Object.class);
                    Method method3 = clazz.getDeclaredMethod("put", Object.class, Object.class);
                    Object object2 = method.invoke(null, new Object[0]);
                    Hashtable hashtable2 = (Hashtable)method2.invoke(object2, object);
                    if (hashtable2 != null) {
                        method3.invoke(object2, object, new DebugHashtable(hashtable2));
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.", throwable);
                }
            }
        }

        private String getKitClassName(String string) {
            try {
                Field field = JEditorPane.class.getDeclaredField("kitTypeRegistryKey");
                field.setAccessible(true);
                Object object = field.get(JEditorPane.class);
                Class<?> clazz = this.getClass().getClassLoader().loadClass("sun.awt.AppContext");
                Method method = clazz.getDeclaredMethod("getAppContext", new Class[0]);
                Method method2 = clazz.getDeclaredMethod("get", Object.class);
                Object object2 = method.invoke(null, new Object[0]);
                Hashtable hashtable = (Hashtable)method2.invoke(object2, object);
                if (hashtable != null) {
                    return (String)hashtable.get(string);
                }
            }
            catch (Throwable throwable) {
                if (debug) {
                    LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.", throwable);
                }
                LOG.log(Level.WARNING, "Can't hack in to the JEditorPane's registry for kit types.");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object object) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.get key=" + object);
                }
                Object object3 = null;
                if (this.delegate != null) {
                    object3 = this.delegate.get(object);
                    if (debug && object3 != null) {
                        LOG.log(Level.INFO, "Found cached instance kit=" + object3 + " for mimeType=" + object);
                    }
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (object3 == null || this.shouldUseNbKit(object3.getClass().getName(), string)) {
                        EditorKit editorKit;
                        String string2 = this.getKitClassName(string);
                        if (debug) {
                            LOG.log(Level.INFO, "Found kitClassName=" + string2 + " for mimeType=" + string);
                        }
                        if ((string2 == null || this.shouldUseNbKit(string2, string)) && (editorKit = this.findKit(string)) != null) {
                            object3 = editorKit;
                            if (debug) {
                                LOG.log(Level.INFO, "Found kit=" + object3 + " in xml layers for mimeType=" + string);
                            }
                        }
                    }
                }
                return object3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            Object object3 = this.LOCK;
            synchronized (object3) {
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.put key=" + object + " value=" + object2);
                }
                if (this.delegate == null) {
                    this.delegate = new Hashtable();
                }
                Object object4 = this.delegate.put(object, object2);
                if (debug) {
                    LOG.log(Level.INFO, "registering mimeType=" + object + " -> kitInstance=" + object2 + " original was " + object4);
                }
                return object4;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                Object var3_3;
                if (debug) {
                    LOG.log(Level.INFO, "HackMap.remove key=" + object);
                }
                Object v0 = var3_3 = this.delegate != null ? this.delegate.remove(object) : null;
                if (debug) {
                    LOG.log(Level.INFO, "removing kitInstance=" + var3_3 + " for mimeType=" + object);
                }
                return var3_3;
            }
        }

        Hashtable getOriginal() {
            return this.delegate;
        }

        private boolean shouldUseNbKit(String string, String string2) {
            if (string2.startsWith("text/html") || string2.startsWith("text/rtf") || string2.startsWith("application/rtf")) {
                return false;
            }
            return string.startsWith("javax.swing.");
        }

        private EditorKit findKit(String string) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
            EditorKit editorKit = (EditorKit)lookup.lookup(EditorKit.class);
            return editorKit == null ? null : (EditorKit)editorKit.clone();
        }
    }
}

