/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.GlobalContextAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class MainMenuAction
extends GlobalContextAction
implements Presenter.Menu,
ChangeListener {
    public static final Icon BLANK_ICON = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/empty.gif"));
    public boolean menuInitialized = false;
    private final Icon forcedIcon;
    private boolean forceIcon;

    public MainMenuAction() {
        this(true, null);
    }

    public MainMenuAction(boolean bl, Icon icon) {
        Registry.addChangeListener((ChangeListener)this);
        this.forceIcon = bl;
        this.forcedIcon = icon;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setMenu();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setMenu();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return this.getMenuItemText();
    }

    private static JTextComponent getComponent() {
        return Utilities.getFocusedComponent();
    }

    protected static Action getActionByName(String string) {
        BaseKit baseKit = MainMenuAction.getKit();
        if (baseKit != null) {
            Action action = baseKit.getActionByName(string);
            return action;
        }
        return null;
    }

    protected static void addAccelerators(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
        Keymap keymap;
        if (jTextComponent == null || action == null || jMenuItem == null) {
            return;
        }
        Action action2 = MainMenuAction.getActionByName((String)action.getValue("Name"));
        if (action2 != null) {
            action = action2;
        }
        if ((keymap = jTextComponent.getKeymap()) != null) {
            KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
            KeyStroke keyStroke = jMenuItem.getAccelerator();
            if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                if (keyStroke == null || !keyStroke.equals(keyStrokeArray[0])) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                }
            } else if (keyStroke != null && action2 != null) {
                jMenuItem.setAccelerator(null);
            }
        }
    }

    private static BaseKit getKit() {
        JTextComponent jTextComponent = MainMenuAction.getComponent();
        return jTextComponent == null ? null : Utilities.getKit((JTextComponent)jTextComponent);
    }

    public boolean isEnabled() {
        return false;
    }

    protected Action getGlobalKitAction() {
        return null;
    }

    protected void setMenu() {
        ActionMap actionMap = this.getContextActionMap();
        Action action = null;
        if (actionMap != null) {
            action = actionMap.get(this.getActionName());
        }
        if (action == null) {
            action = this.getGlobalKitAction();
        }
        JMenuItem jMenuItem = this.getMenuPresenter();
        assert (jMenuItem != null) : "Got null return from getMenuPresenter in " + this;
        Action action2 = jMenuItem.getAction();
        if (action2 == null) {
            if (action != null) {
                jMenuItem.setAction(action);
                jMenuItem.setToolTipText(null);
                this.menuInitialized = false;
            }
        } else if (action != null && !action.equals(action2)) {
            jMenuItem.setAction(action);
            jMenuItem.setToolTipText(null);
            this.menuInitialized = false;
        }
        if (!this.menuInitialized) {
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)this.getMenuItemText());
            this.menuInitialized = true;
        }
        jMenuItem.setEnabled(action != null);
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent != null && jTextComponent instanceof JEditorPane) {
            MainMenuAction.addAccelerators(action, jMenuItem, jTextComponent);
        } else {
            jMenuItem.setAccelerator(this.getDefaultAccelerator());
        }
        if (this.forceIcon) {
            jMenuItem.setIcon(this.forcedIcon);
        }
    }

    protected abstract String getMenuItemText();

    protected abstract String getActionName();

    protected KeyStroke getDefaultAccelerator() {
        return null;
    }

    public static final class PasteFormattedAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public PasteFormattedAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(PasteFormattedAction.class).getString("paste_formatted_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "paste-formated";
        }
    }

    public static final class RemoveTrailingSpacesAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public RemoveTrailingSpacesAction() {
            super(true, null);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(RemoveTrailingSpacesAction.class).getString("remove_trailing_spaces_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "remove-trailing-spaces";
        }
    }

    public static final class StopMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StopMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(StopMacroRecordingAction.class).getString("stop_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "stop-macro-recording";
        }
    }

    public static final class SelectIdentifierAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public SelectIdentifierAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(SelectIdentifierAction.class).getString("select_identifier_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "select-identifier";
        }
    }

    public static final class SelectAllAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public SelectAllAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(SelectAllAction.class).getString("select_all_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "select-all";
        }
    }

    public static final class StartMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StartMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(StartMacroRecordingAction.class).getString("start_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "start-macro-recording";
        }
    }

    public static final class FindSelectionAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindSelectionAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_selection_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-selection";
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = EditorRegistry.focusedComponent();
            return jTextComponent != null;
        }
    }

    public static final class FindPreviousAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindPreviousAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-previous";
        }
    }

    public static final class FindNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindNextAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-next";
        }
    }

    public static final class WordMatchPrevAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchPrevAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(WordMatchPrevAction.class).getString("word_match_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-prev";
        }
    }

    public static final class WordMatchNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchNextAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(WordMatchNextAction.class).getString("word_match_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-next";
        }
    }

    public static final class ToggleCommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ToggleCommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(ToggleCommentAction.class).getString("toggle_comment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "toggle-comment";
        }
    }

    public static final class UncommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public UncommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(UncommentAction.class).getString("uncomment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "uncomment";
        }
    }

    public static final class CommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public CommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(CommentAction.class).getString("comment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "comment";
        }
    }

    public static final class ShiftLineRightAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineRightAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(ShiftLineRightAction.class).getString("shift_line_right_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-right";
        }
    }

    public static final class ShiftLineLeftAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineLeftAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(ShiftLineLeftAction.class).getString("shift_line_left_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-left";
        }
    }

    public static final class FormatAction
    extends MainMenuAction {
        private JMenuItem formatMenuItem = new JMenuItem(this.getMenuItemText());

        public FormatAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FormatAction.class).getString("format_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.formatMenuItem;
        }

        protected String getActionName() {
            return "format";
        }
    }

    public static final class JumpForwardAction
    extends MainMenuAction {
        private JMenuItem jumpForwardMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpForwardAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(JumpForwardAction.class).getString("jump_forward_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpForwardMenuItem;
        }

        protected String getActionName() {
            return "jump-list-next";
        }
    }

    public static final class JumpBackAction
    extends MainMenuAction {
        private JMenuItem jumpBackMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpBackAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(JumpBackAction.class).getString("jump_back_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpBackMenuItem;
        }

        protected String getActionName() {
            return "jump-list-prev";
        }
    }

    public static class GoToDeclarationAction
    extends MainMenuAction {
        private JMenuItem GOTO_DECL_MENU = new JMenuItem(this.getMenuItemText());

        public GoToDeclarationAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_declaration_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_DECL_MENU;
        }

        protected String getActionName() {
            return "goto-declaration";
        }
    }

    public static class GoToSuperAction
    extends MainMenuAction {
        private JMenuItem GOTO_SUPER_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSuperAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_super_implementation_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SUPER_MENU;
        }

        protected String getActionName() {
            return "goto-super-implementation";
        }
    }

    public static class GoToSourceAction
    extends MainMenuAction {
        private JMenuItem GOTO_SOURCE_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSourceAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_source_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SOURCE_MENU;
        }

        protected String getActionName() {
            return "goto-source";
        }
    }

    public static class ShowLineNumbersAction
    extends MainMenuAction {
        private static JCheckBoxMenuItem SHOW_LINE_MENU = null;
        private Action delegate = null;

        public ShowLineNumbersAction() {
            super(false, null);
        }

        protected void setMenu() {
            super.setMenu();
            JTextComponent jTextComponent = MainMenuAction.getComponent();
            MimePath mimePath = jTextComponent == null ? MimePath.EMPTY : MimePath.parse((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent));
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
            boolean bl = preferences.getBoolean("line-number-visible", false);
            SHOW_LINE_MENU.setState(bl);
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("show_line_numbers_main_menu_view_item");
        }

        public String getName() {
            return this.getMenuItemText();
        }

        public JMenuItem getMenuPresenter() {
            if (SHOW_LINE_MENU == null) {
                SHOW_LINE_MENU = new JCheckBoxMenuItem(this.getMenuItemText());
                this.setMenu();
            }
            return SHOW_LINE_MENU;
        }

        protected String getActionName() {
            return "toggle-line-numbers";
        }

        protected Action getGlobalKitAction() {
            if (this.delegate == null) {
                this.delegate = new NbEditorKit.NbToggleLineNumbersAction();
            }
            return this.delegate;
        }
    }

    public static class ShowToolBarAction
    extends MainMenuAction {
        private static JCheckBoxMenuItem SHOW_TOOLBAR_MENU = null;
        private Action delegate = null;

        public ShowToolBarAction() {
            super(false, null);
        }

        protected void setMenu() {
            super.setMenu();
            JTextComponent jTextComponent = MainMenuAction.getComponent();
            MimePath mimePath = jTextComponent == null ? MimePath.EMPTY : MimePath.parse((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent));
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
            boolean bl = preferences.getBoolean("toolbarVisible", true);
            SHOW_TOOLBAR_MENU.setState(bl);
        }

        public JMenuItem getMenuPresenter() {
            if (SHOW_TOOLBAR_MENU == null) {
                SHOW_TOOLBAR_MENU = new JCheckBoxMenuItem(this.getMenuItemText());
                this.setMenu();
            }
            return SHOW_TOOLBAR_MENU;
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("show_editor_toolbar_main_menu_view_item");
        }

        protected String getActionName() {
            return "toggle-toolbar";
        }

        protected Action getGlobalKitAction() {
            if (this.delegate == null) {
                this.delegate = new NbEditorKit.ToggleToolbarAction();
            }
            return this.delegate;
        }
    }
}

