/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.impl.actions.NavigationHistoryBackAction;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NavigationHistoryLastEditAction
extends BaseAction
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryLastEditAction.class.getName());

    public NavigationHistoryLastEditAction() {
        super("jump-list-last-edit");
        this.putValue("IconResource", "org/netbeans/modules/editor/resources/last_edit_location_16.png");
        this.update();
        NavigationHistory navigationHistory = NavigationHistory.getEdits();
        navigationHistory.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)navigationHistory));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        NavigationHistory navigationHistory = NavigationHistory.getEdits();
        Object object = navigationHistory.getCurrentWaypoint();
        if (object != null) {
            object = this.isStandingThere(jTextComponent, (NavigationHistory.Waypoint)object) ? navigationHistory.navigateBack() : null;
        }
        if (object == null) {
            object = navigationHistory.navigateLast();
        }
        if (object != null) {
            NavigationHistoryBackAction.show(object);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }

    private void update() {
        NavigationHistory navigationHistory = NavigationHistory.getEdits();
        this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryLastEditAction.class, (String)"NavigationHistoryLastEditAction_Tooltip_simple"));
        this.setEnabled(navigationHistory.hasNextWaypoints() || navigationHistory.hasPreviousWaypoints() || null != navigationHistory.getCurrentWaypoint());
    }

    private boolean isStandingThere(JTextComponent jTextComponent, NavigationHistory.Waypoint waypoint) {
        return jTextComponent == waypoint.getComponent() && jTextComponent.getCaret().getDot() == waypoint.getOffset();
    }

    public static final class MainMenu
    extends MainMenuAction {
        private JMenuItem jumpLastEditItem = new JMenuItem(this.getMenuItemText());

        public MainMenu() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(NavigationHistoryLastEditAction.class).getString("jump_back_main_menu_item-main-menu");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpLastEditItem;
        }

        protected String getActionName() {
            return "jump-list-last-edit";
        }
    }
}

