/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Image;
import java.io.PrintStream;
import java.util.Enumeration;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.Tracer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class AbstractCsmNode
extends AbstractNode {
    public AbstractCsmNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    public AbstractCsmNode(Children children) {
        this(children, null);
    }

    public abstract CsmObject getCsmObject();

    public Image getIcon(int n) {
        try {
            CsmObject csmObject = this.getCsmObject();
            return csmObject == null ? super.getIcon(n) : CsmImageLoader.getImage(csmObject);
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public void dump(PrintStream printStream) {
        this.dump(new Tracer(printStream));
    }

    protected void dump(Tracer tracer) {
        tracer.trace(this.getDisplayName());
        tracer.indent();
        Enumeration enumeration = this.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!(node instanceof AbstractCsmNode)) continue;
            ((AbstractCsmNode)node).dump(tracer);
        }
        tracer.unindent();
    }
}

