/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssAstElement;
import org.netbeans.modules.css.gsf.EditorAwareSourceTaskSupport;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(final CompilationInfo compilationInfo) {
        EditorAwareSourceTaskSupport.instance().fire(compilationInfo);
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            return Collections.emptyList();
        }
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 19) {
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
                    assert (simpleNode2.kind() == 18);
                    int n = AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource);
                    int n2 = AstUtils.documentPosition(simpleNode2.endOffset(), translatedSource);
                    if (n2 != n) {
                        int n3 = AstUtils.documentPosition(simpleNode.startOffset(), translatedSource);
                        int n4 = AstUtils.documentPosition(simpleNode.endOffset(), translatedSource);
                        String string = compilationInfo.getText().substring(n3, n4);
                        if (string.length() > 0) {
                            arrayList.add(new CssRuleStructureItem(string, CssAstElement.getElement(compilationInfo, simpleNode2)));
                        }
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        return arrayList;
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        final BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        final ArrayList arrayList = new ArrayList();
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 18) {
                    int n = AstUtils.documentPosition(simpleNode.startOffset(), translatedSource);
                    int n2 = AstUtils.documentPosition(simpleNode.endOffset(), translatedSource);
                    try {
                        if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2)) {
                            arrayList.add(new OffsetRange(n, n2));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        hashMap.put("codeblocks", arrayList);
        return hashMap;
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CssRuleStructureItem
    implements StructureItem {
        private String name;
        private CssAstElement element;

        private CssRuleStructureItem(String string, CssAstElement cssAstElement) {
            this.name = string;
            this.element = cssAstElement;
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            return this.getName();
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return AstUtils.documentPosition(this.element.node().startOffset(), this.element.translatedSource());
        }

        public long getEndPosition() {
            return AstUtils.documentPosition(this.element.node().endOffset(), this.element.translatedSource());
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

